/*
 * Decompiled with CFR 0.152.
 */
package kandata.launcher;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kandata.launcher.Site;

class SiteInfoPane
extends JPanel
implements ChangeListener {
    JTextField nameField = new JTextField();
    JTextField descField = new JTextField();
    JTextField urlField = new JTextField();
    JTextField clientTypeField = new JTextField();
    JTextField versionField = new JTextField();
    JCheckBox clientTypeCheck = new JCheckBox("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30bf\u30a4\u30d7");
    JCheckBox versionCheck;
    JButton ok;
    JButton cancel;
    Image image;
    Site site;

    SiteInfoPane() {
        this.clientTypeCheck.addChangeListener(this);
        this.versionCheck = new JCheckBox("\u30d0\u30fc\u30b8\u30e7\u30f3");
        this.versionCheck.addChangeListener(this);
        this.setLayout(new GridLayout(11, 1, 5, 5));
        this.add(new JLabel("\u540d\u524d"));
        this.add(this.nameField);
        this.add(new JLabel("\u8a73\u7d30\u306a\u8aac\u660e"));
        this.add(this.descField);
        this.add(new JLabel("URL"));
        this.add(this.urlField);
        this.add(this.clientTypeCheck);
        this.add(this.clientTypeField);
        this.add(this.versionCheck);
        this.add(this.versionField);
    }

    void setSite(Site site) {
        this.site = site;
        this.nameField.setText(site.getName());
        this.descField.setText(site.getDesc());
        this.urlField.setText(site.getUrl());
        if (site.getClientType() != null) {
            this.clientTypeCheck.setSelected(true);
            this.clientTypeField.setText(site.getClientType());
            this.clientTypeField.setEditable(true);
        } else {
            this.clientTypeCheck.setSelected(false);
            this.clientTypeField.setText("");
            this.clientTypeField.setEditable(false);
        }
        if (site.getVersion() != null) {
            this.versionCheck.setSelected(true);
            this.versionField.setText(site.getVersion());
            this.versionField.setEditable(true);
        } else {
            this.versionCheck.setSelected(false);
            this.versionField.setText("");
            this.versionField.setEditable(false);
        }
        this.image = site.getIcon();
    }

    Site getSite() {
        return new Site(this.urlField.getText(), this.clientTypeCheck.isSelected() ? this.clientTypeField.getText() : null, this.versionCheck.isSelected() ? this.versionField.getText() : null, this.nameField.getText(), this.descField.getText(), this.image);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.clientTypeCheck) {
            this.clientTypeField.setEditable(this.clientTypeCheck.isSelected());
        } else if (e.getSource() == this.versionCheck) {
            this.versionField.setEditable(this.versionCheck.isSelected());
        }
    }

    static Site showModal(Component parent, String title, Site site) {
        int rc;
        SiteInfoPane pane = new SiteInfoPane();
        if (site != null) {
            pane.setSite(site);
        }
        if ((rc = JOptionPane.showConfirmDialog(parent, pane, title, 2, -1, null)) == 2) {
            return null;
        }
        return pane.getSite();
    }

    class RegistFromClipboard
    extends AbstractAction {
        SiteInfoPane pane;

        public RegistFromClipboard(SiteInfoPane pane) {
            super("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u304b\u3089\u4e00\u767a\u767b\u9332");
            this.pane = pane;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = c.getContents(this);
            try {
                String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                System.out.println("\u30da\u30fc\u30b9\u30c8\u3055\u308c\u305f\u6587\u5b57\u5217\u306f:" + s);
                Properties prop = new Properties();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new StringReader(s));
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line == null) {
                            break;
                        }
                        int pos = line.indexOf(61);
                        String key = line.substring(0, pos);
                        String value = line.substring(pos + 1);
                        System.out.println("key=[" + key + "] value=[" + value + "]");
                        prop.put(key, value);
                    }
                }
                finally {
                    if (reader == null) {
                        reader.close();
                    }
                }
                String name = prop.getProperty("Name");
                String desc = prop.getProperty("Desc");
                String url = prop.getProperty("Url");
                String clientType = prop.getProperty("ClientType");
                String version = prop.getProperty("Version");
                String iconUrl = prop.getProperty("IconUrl");
                System.out.println(name);
                System.out.println(desc);
                System.out.println(url);
                System.out.println(clientType);
                System.out.println(version);
                System.out.println(iconUrl);
                if (name == null || url == null) {
                    JOptionPane.showMessageDialog(this.pane, "\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u304b\u3089\u4e00\u767a\u767b\u9332", 0);
                    return;
                }
                SiteInfoPane.this.setSite(new Site(url, clientType, version, name, desc, null));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.pane, "\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u304b\u3089\u4e00\u767a\u767b\u9332", 0);
            }
        }
    }
}

