/*
 * Decompiled with CFR 0.152.
 */
package kandata.launcher;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import kandata.launcher.KandataLauncher;
import kandata.launcher.Site;
import kandata.launcher.SiteCategory;
import kandata.launcher.SiteListModel;
import kandata.launcher.SiteListMouseListener;
import kandata.launcher.SiteRenderer;

class SiteListBox
extends JList {
    private SiteCategory category;
    static SiteRenderer siteRenderer = new SiteRenderer();
    KandataLauncher launcher;
    private SiteListModel model;

    SiteListBox(KandataLauncher launcher, SiteCategory category) {
        this.launcher = launcher;
        this.category = category;
        this.model = new SiteListModel(category);
        this.setModel(this.model);
        this.setCellRenderer(siteRenderer);
        this.addMouseListener(new SiteListMouseListener(launcher));
        this.setToolTipText("\u3061\u3063\u3077\u3059");
        this.setFixedCellHeight(40);
    }

    public String getToolTipText(MouseEvent event) {
        int index = this.locationToIndex(event.getPoint());
        if (index == -1) {
            return null;
        }
        Rectangle rect = this.getCellBounds(index, index);
        if (!rect.contains(event.getPoint())) {
            return null;
        }
        Site site = this.category.getSiteInfo(index);
        return "<html>" + site.getName() + "<br>" + "<b>description</b>=" + site.getDesc() + "<br>" + "<b>url</b>=" + site.getUrl() + "<br>" + "<b>client type</b>=" + site.getClientType() + "<br>" + "<b>version</b>=" + site.getVersion() + "<br>";
    }

    void fireChanged() {
        this.model.fireChanged();
    }
}

