
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import jp.ne.nifty.iga.midori.shell.MdShellVersion;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.util.Vector;

public class MdShellCommandHelp
	extends MdShellCmdDefault
{
	public MdShellCommandHelp()
	{
		setCommand("help");
		setDisplayString("show help              , ? is alias");
	}

	public void registerImplementedCommand(Vector vecList)
	{
		vecList.addElement(getCommand());
		//vecList.addElement("?"); // ? is alias. but now is not to regist.
	}

	public boolean isThisCommand(MdShellEnv shellenv,String strCommand)
	{
		Collator collator=shellenv.getCollatorInstance();
		if(collator.equals(strCommand,getCommand())==false
		&& collator.equals(strCommand,"?")==false)
		{
			return false;
		}
		return true;
	}

	public void processCommand(MdShellEnv shellenv)
	{
		{
			shellenv.getOut().println(MdShellDef.PRODUCT_NAME+" "+MdShellVersion.getVersion()+", "+MdShellDef.COPYRIGHT);
			shellenv.getOut().println("Console mode shell program written in JAVA.");
			shellenv.getOut().println("  (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)");
			shellenv.getOut().println();
			shellenv.getOut().println("    This program is free software; you can redistribute it and/or modify");
			shellenv.getOut().println("    it under the terms of the GNU General Public License as published by");
			shellenv.getOut().println("    the Free Software Foundation; either version 2 of the License, or");
			shellenv.getOut().println("    (at your option) any later version.");
			shellenv.getOut().println();
			shellenv.getOut().println("    This program is distributed in the hope that it will be useful,");
			shellenv.getOut().println("    but WITHOUT ANY WARRANTY; without even the implied warranty of");
			shellenv.getOut().println("    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
			shellenv.getOut().println("    GNU General Public License for more details.");
			shellenv.getOut().println();
			shellenv.getOut().println(MdShellDef.PRODUCT_NAME+" command list.");

			shellenv.getOut().println(shellenv.getCommandList().getImplementedCommandListForDisplayString());
		}
	}
}


