
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.io.*;
import java.util.*;

public class MdShellCommandSplit
	extends MdShellCmdDefault
{
	public MdShellCommandSplit()
	{
		setCommand("split");
		setDisplayString("split file into several files. (and reverse) [experimental]");
	}

	public void processCommand(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		Vector vecList=new Vector();
		vecList.addElement("divide");
		vecList.addElement("merge");

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select what to select: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strSubCommand=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));

		if(strSubCommand==null)
		{
			throw new MdShellCancelException();
		}

		if(strSubCommand.equals("divide"))
		{
			MdShellDirFileAbstract dirNodeInterface=MdShellSelectFileUtil.selectFile(shellenv);
			if(dirNodeInterface!=null)
			{
				splitFile(shellenv,dirNodeInterface);
			}
		}
		else if (strSubCommand.equals("merge"))
		{
			MdShellDirFileAbstract dirNodeInterface=MdShellSelectFileUtil.selectFile(shellenv);
			if(dirNodeInterface!=null)
			{
				mergeFile(shellenv,dirNodeInterface);
			}
		}
	}

	private void splitFile(MdShellEnv shellenv,MdShellDirFileAbstract dirfileInput)
	{
		//split(MdShellDirFactory.trimDeviceName(dirfileInput.getName()));
		split(shellenv,dirfileInput);
	}

	private void mergeFile(MdShellEnv shellenv,MdShellDirFileAbstract dirfileInput)
	{
		merge(shellenv,dirfileInput);
	}

	private final static int FILE_LOOP_COUNT=10;
	private static final void split(MdShellEnv shellenv,MdShellDirFileAbstract dirfileInput)
	{
		try{
			InputStream inStream=dirfileInput.getInputStream();
			byte[] byteBuf=new byte[10000];
			mainLoop:
			for(int iLoop=0;;iLoop++)
			{
				MdShellDirFileAbstract dirfileOut=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,dirfileInput.getName()+"-"+(iLoop),false);
				System.out.println("processing file ["+dirfileOut.getName()+"]");
				OutputStream outStream=new BufferedOutputStream(dirfileOut.getOutputStream());
				for(int readLoop=0;readLoop<FILE_LOOP_COUNT;readLoop++)
				{
					int iLen=inStream.read(byteBuf);
					if(iLen<=0)
					{
						outStream.flush();
						outStream.close();
						break mainLoop;
					}
					outStream.write(byteBuf,0,iLen);
				}
				outStream.flush();
				outStream.close();
				dirfileOut.setLastModified(dirfileInput.getLastModified());
			}
			inStream.close();
		}catch(Exception ex){
			System.out.println(ex);
			ex.printStackTrace();
		}
	}

	private static final void merge(MdShellEnv shellenv,MdShellDirFileAbstract dirfileInput)
	{
		if(dirfileInput.getName().endsWith("-0")==false)
		{
			System.out.println("aborted. "+dirfileInput.getName()+" is not generated by this program.");
			return;
		}
		String strDstFileName=dirfileInput.getName().substring(0,dirfileInput.getName().length()-2);
		try{
			MdShellDirFileAbstract dirfileOut=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,strDstFileName,false);
			OutputStream outStream=new BufferedOutputStream(dirfileOut.getOutputStream());
			byte[] byteBuf=new byte[10000];
			mainLoop:
			for(int iLoop=0;;iLoop++)
			{
				MdShellDirFileAbstract dirfileInCurrent=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,strDstFileName+"-"+(iLoop),false);
				if(dirfileInCurrent.canRead()==false)
				{
					outStream.flush();
					outStream.close();
					break mainLoop;
				}
				InputStream inStream=new BufferedInputStream(dirfileInCurrent.getInputStream());
				if(inStream==null)
				{
					break;
				}

				System.out.println("processing file ["+dirfileInCurrent.getName()+"]");
				for(int readLoop=0;;readLoop++)
				{
					int iLen=inStream.read(byteBuf);
					if(iLen<=0)
					{
						break;
					}
					outStream.write(byteBuf,0,iLen);
				}
				inStream.close();
			}
			outStream.flush();
			outStream.close();
			dirfileOut.setLastModified(dirfileInput.getLastModified());
			System.out.println(dirfileOut.getName()+" is created.");
		}catch(Exception ex){
			System.out.println(ex);
			ex.printStackTrace();
		}
	}
}


