
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.util;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.io.*;
import java.util.*;

public class MdShellSelectFileUtil
{
	public static final MdShellDirFileAbstract selectFile(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		shellenv.getOut().print("input option if exist. (ex. -Rt *.java): ");

		shellenv.promptInputIfNoDataExist();
		String[] strArgs=shellenv.getArgsArray();

		jp.ne.nifty.iga.midori.shell.util.dir.Dir dirWrk=new jp.ne.nifty.iga.midori.shell.util.dir.Dir();
		Vector vecList=dirWrk.buildData(shellenv,strArgs);

		MdShellDirLongListFormatter formatter=new MdShellDirLongListFormatter();
		if(vecList.size()==0)
		{
			shellenv.getOut().println("no file is selected");
			return null;
		}
		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,formatter);
		shellenv.getOut().print("select file (or input all): ");
		String strSelectOneOrAll=shellenv.getNextLine();
		if(strSelectOneOrAll==null)
		{
			throw new MdShellCancelException();
		}

		MdShellDirFileAbstract dirfileSelect=null;
		if(strSelectOneOrAll.equals("all"))
		{
			shellenv.getOut().println("all command not implemented.");
			return null;
		}
		else
		{
			dirfileSelect=(MdShellDirFileAbstract)MdShellListSelection.selectFromList(shellenv,vecList,new MdShellDirectoryNameFormatter(),strSelectOneOrAll);
		}
		return dirfileSelect;
	}
}


