
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.util;

import java.io.*;
import java.text.*;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : string utility.
 */
public class MdShellUtilString
{
	/**
	 * error= -1.
	 */
	public static final int parseInt(String strNumber)
	{
		try{
			return Integer.parseInt(strNumber);
		}catch(NumberFormatException ex){
			return -1;
		}
	}

	/**
	 * One line reading.
	 */
	public static final String readLine(InputStream inStream)
	{
		try{
			BufferedReader reader=new BufferedReader(new InputStreamReader(inStream));
			return reader.readLine();
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
			return null;
		}
	}

	/**
	 * get first command token
	 */
	public static final String readFirstCommandToken(String strReadLine)
	{
		StringTokenizer toknizerCommand=new StringTokenizer(strReadLine," \t\n",false);
		String strCommand=null;
		try{
			strCommand=toknizerCommand.nextToken();
		}catch(NoSuchElementException ex){
			// Nothing is here.
			return null;
		}
		return strCommand;
	}

	/**
	 * full fill string length
	 */
	public static final String fullfillStringLengthRight(String strArg,int fullfillLength)
	{
		StringBuffer strbufWrk=new StringBuffer();
		for(int iLength=strArg.length();iLength<fullfillLength;iLength++)
		{
			strbufWrk.append(" ");
		}
		return strbufWrk.toString()+strArg;
	}

	/**
	 * full fill string length
	 */
	public static final String fullfillStringLengthLeft(String strArg,int fullfillLength)
	{
		StringBuffer strbufWrk=new StringBuffer();
		for(int iLength=strArg.length();iLength<fullfillLength;iLength++)
		{
			strbufWrk.append(" ");
		}
		return strArg+strbufWrk.toString();
	}

	public static final String eraseChar(String strArg,char cErase)
	{
		for(;;)
		{
			int iFind=strArg.indexOf(cErase);
			if(iFind<0)
			{
				break;
			}
			StringBuffer strbufWrk=new StringBuffer();
			strbufWrk.append(strArg.substring(0,iFind));
			strbufWrk.append(strArg.substring(iFind+1,strArg.length()));
			strArg=strbufWrk.toString();
		}
		return strArg;
	}

	public static final String[] vectorToStringarray(Vector vecArgs)
	{
		String[] args=new String[vecArgs.size()];
		for(int index=0;index<vecArgs.size();index++)
		{
			args[index]=(String)vecArgs.elementAt(index);
		}
		return args;
	}

	private static SimpleDateFormat simpledateformat=null;
	private static SimpleDateFormat getSimpleDateFormatInstance()
	{
		if(simpledateformat==null)
		{
			simpledateformat=new SimpleDateFormat("yyyy/MM/dd HH:mm");
		}
		return simpledateformat;
	}
	public static String convertLastModifiedToString(long lastModified)
	{
		return getSimpleDateFormatInstance().format(new Date(lastModified));
	}

	public static String numberToString(long lLength,int fullfillLength)
	{
		NumberFormat numberfmt=NumberFormat.getNumberInstance();
		return MdShellUtilString.fullfillStringLengthRight(numberfmt.format(lLength),fullfillLength);
	}
}


