
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.io;

import java.io.*;
import java.util.zip.*;

public final class MdShellBase64InputStream extends InputStream
{
	private InputStream inStream=null;
	private MdShellBase64Util mdshellbase64util=new MdShellBase64Util();
	private int iBufferCount=0;
	private int iBufferLength=0;
	private int[] bufferBase64=new int[3];

	public MdShellBase64InputStream(InputStream inStream)
	{
		this.inStream=inStream;
	}

	public final int read() throws IOException
	{
		if(iBufferCount==0||iBufferCount>=iBufferLength)internalDo();
		return bufferBase64[iBufferCount++];
	}

	public final void close() throws IOException
	{
		inStream.close();
	}

	private final void internalDo() throws IOException
	{
		bufferBase64[0]=-1;bufferBase64[1]=-1;bufferBase64[2]=-1;
		int[] iByteRead=new int[4];
		for(int index=0;index<4;)
		{
			int iRead=inStream.read();
			iByteRead[index]=iRead;
			if(iByteRead[index]<0)break;
			if(mdshellbase64util.decode(iRead)<0)continue;
			index++;
		}
		iBufferLength=mdshellbase64util.decodeBuf(iByteRead,bufferBase64);
		iBufferCount=0;
	}
}



