/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package kandata;

import java.io.*;
//import java.net.*;
//import java.lang.reflect.*;
import java.util.Properties;
import kandata.client.*;
import kandata.server.*;

/**
 * fobOp̃RlN^.
 * NCAgƃT[oP̃vZXŎsB
 */
public class DebugConnector implements KandataConnector, KandataServerContext {

	static final boolean TRACE_ENABLE = true;
	static final void TRACE(String message) { if (TRACE_ENABLE) System.out.println(message); }
	static final void TRACE(Throwable ex) { if (TRACE_ENABLE) ex.printStackTrace(System.out); }

	static KandataServer server = null;

	/** ݒt@C. */
	private static final String CONFIG_FILENAME = "kandata.properties";

	protected KandataClientContext clientContext = new KandataClientContext(System.currentTimeMillis());

	/** T[oAṽNX. */
	protected String serverClassName;// = null;//"roomreservation.server.RoomReservationServer";

	/** T[oAṽ\[XpX. */
	protected String serverResourcePath;// = "server_resources";

	/** NCAgAṽGgNX. */
	protected String clientEntryClassName;// = "roomreservation.client.RoomReservationClient";

	/** NCAgAṽNXpX. */
	protected String clientClassPath;// = "classes";

	/** NCAgAṽ\[XpX. */
	protected String clientResourcePath;// = "client_resources";



	/** ڑ */
	public void connect() throws KandataClientException {
		TRACE("DebugConnector.connect()");

		// ݒt@Cǂݍ
		loadConfiguration(CONFIG_FILENAME);

		server.init(this);
		server.connected(clientContext);
	}

	/** ؒf */
	public void disconnect() throws KandataClientException {
		TRACE("DebugConnector.disconnect()");
		server.disconnected(clientContext);
		server.exit();
	}

	/**
	 * T[õ\[X擾܂.
	 * @param	path	擪<code>File.separator</code>t܂.
	 */
	public byte[] getResource(String path) throws KandataClientException {
		TRACE("DebugConnector.getResource("+path+") "+clientResourcePath+path);
		InputStream in = null;
		try {
			File file = new File(clientResourcePath + path);
			in = new FileInputStream(file);
			byte[] buf = new byte[ (int) file.length() ];
			in.read(buf);
			return buf;
		}
		catch (IOException e) {
			throw new KandataClientException(
						"t@C̓ǂݍ݂Ɏs܂ :"+clientResourcePath+path, e);
		}
		finally {
			if (in != null) try { in.close(); } catch (IOException e) {}
		}
	}

	/** T[õ\[X̃pXԂ. */
	public String getResourcePath() {
		return serverResourcePath;
	}

	/** T[õ\bhĂяo. */
	public Object invoke(String command, Object[] args) throws KandataClientException {
		TRACE("DebugConnector.invoke("+command+")");
		if (args != null) {
			for (int i=0; i<args.length; i++) {
				TRACE("  args["+i+"]="+args[i]);
			}
		}
		Object ret;
		if (command.charAt(0) == '@') {
			ret = invokeSystemRequest(clientContext, command, args);
		}
		else {
			ret = server.invoke(clientContext, command, args);
		}
		TRACE("   ret="+ret);
		return ret;
	}

	/**
	 * VXevɓ.
	 * VXev'@'n܂B
	 * <ul>
	 *   <code>@getEntryClassName</code>	Gg̃NXԂB
	 *   <code>@getResource</code>			\[XԂB
	 * </ul>
	 */
	protected Object invokeSystemRequest(KandataClientContext context, String command, Object[] args) {

		if (command.equals("@getEntryClassName")) {
			return clientEntryClassName;
		}
		else if (command.equals("@getResource")) {
			String path = clientResourcePath + (String) args[0];
			TRACE("path="+path);
			FileInputStream in = null;
			try {
				File file = new File(path);
				byte[] buf = new byte[(int) file.length()];
				in = new FileInputStream(file);
				in.read(buf, 0, (int) file.length());
				return buf;
			} catch (IOException e) {
				TRACE(e);
				return null;
			}
			finally {
				if (in != null) try { in.close(); } catch (IOException e) {}
			}
		}
		else {
			TRACE("`̃R}hł command="+command);
		}
		return null;
	}

	/** Gg̃NX擾. */
	public String getEntryClassName() throws KandataClientException {
		return (String) invoke("@getEntryClassName", null);
	}
	/**
	 * ݒǂݍ.
	 * XMLł͂ȂAPropertiesɂĂBJDK1.3ł̓ftHgœĂȂ̂.
	 */
	protected void loadConfiguration(String fname) {
		FileInputStream in = null;
		try {
			in = new FileInputStream(fname);
			Properties prop = new Properties();
			prop.load(in);
			String appname       = prop.getProperty("application.name");
			serverClassName      = prop.getProperty("application.serverclassname");
			serverResourcePath   = prop.getProperty("application.serverresourcepath");
			clientEntryClassName = prop.getProperty("application.cliententryclassname");
			clientClassPath      = prop.getProperty("application.clientclasspath");
			clientResourcePath   = prop.getProperty("application.clientresourcepath");
			in.close();
			TRACE("application.name="+appname);
			TRACE("application.serverclassname="+serverClassName);
			TRACE("application.serverresourcepath="+serverResourcePath);
			TRACE("application.cliententryclassname="+clientEntryClassName);
			TRACE("application.clientclasspath="+clientClassPath);
			TRACE("application.clientresourcepath="+clientResourcePath);
		}
		catch (IOException e) {
			TRACE(e);
		}
		finally {
			if (in != null) try { in.close(); } catch (IOException e) {}
		}
	}

	public static void main(String[] args) throws Exception {
		if (args.length < 1) {
			System.err.println("usage: java kandata.DebugConnector <server-classname> [<client-type> [<version>]]");
			System.exit(-1);
		}
		
		// AvP[VT[oN.
		String classname  = args[0];
		String clientType = (args.length > 2) ? args[1] : null;
		String version    = (args.length > 3) ? args[2] : null;
		Class serverClass = Class.forName(classname);
		server = (KandataServer) serverClass.newInstance();
		// fobOpNCAgN.
		DebugConnector connector = new DebugConnector();
		connector.connect();
		String entry_classname = connector.getEntryClassName();
		Class entry_class = Class.forName(entry_classname);
		KandataClient client = (KandataClient) entry_class.newInstance();
		client.init(connector);
	}
}
