/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package kandata.client.http;

import kandata.client.*;

/**
 * HTTPgāAT[õNXǂݍ.
 * T[oǂݍނɂ́AHttpConnectorgetClass()\bhg.
 */
class HttpClassLoader extends ClassLoader {
	HttpConnector connector;

	public HttpClassLoader(HttpConnector connector) {
		this.connector = connector;
	}

	public Class findClass(String name) {
		byte[] b = loadClassData(name);
		return defineClass(name, b, 0, b.length);
	}

	private byte[] loadClassData(String name) {
		try {
			// HttpConnectorgāAT[õNX擾.
			return connector.getClass(name);
		}
		catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
 }
