/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package kandata.client.http;

import java.io.*;
import kandata.client.*;

/**
 * HttpoRŃNXVACYƂÃNXɓƎNX[_g.
 * T[oƃNCAgԂŃNXVACY邱Ƃ\łB
 * W̃NXȂ΁AȂVACY邱Ƃł܂B
 * AƎ̃NXVACYہANCAg͂̃NXm܂B
 * NCAg̃NXFAVACY邽߂ɂ́A
 * ̃Xg[gKv܂B
 * Ȃ킿ÃNXǂݍނƂłNX[_ĂXg[łB
 */
class HttpObjectInputStream extends ObjectInputStream {
	/** NXɎgANX[_. */
	protected ClassLoader classLoader;	// ۂɂ HttpClassLoader

	/** w肳ꂽNX[_ǂݍނƂ̂łAIuWFNgXg[쐬. */
	public HttpObjectInputStream(InputStream in, ClassLoader classLoader)
								throws IOException {
		super(in);
		this.classLoader = classLoader;
	}

	/** NX. */
	public Class resolveClass(ObjectStreamClass desc)
                      throws IOException, ClassNotFoundException {
		try {
			// egĒTB
			return super.resolveClass(desc);
		}
		catch (ClassNotFoundException ex) {
			// eȂƂ́AŌB
			return Class.forName(desc.getName(), true, classLoader);
			// łȂ΁AÔ܂܏ɃX[B
		}
		// ȊO̗OX[B
	}
}
