/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.dir;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryRoot;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileFileSystem;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInfo;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFileNameComparator;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;

public class MdShellDirDirectoryFileSystem
extends MdShellDirDirectoryAbstract {
    private File fileMySelf = null;
    private MdShellEnv shellenv = null;

    public MdShellDirDirectoryFileSystem(MdShellEnv shellenv, String strUri, File file) {
        this.shellenv = shellenv;
        this.fileMySelf = file;
        this.setType(1);
        this.setName(strUri);
        if (!strUri.endsWith(MdShellDirFactory.getWindowsRootStyle())) {
            this.setFileLength(this.fileMySelf.length());
            this.lastModified = this.fileMySelf.lastModified();
            this.bCanWrite = this.fileMySelf.canWrite();
            this.bCanRead = this.fileMySelf.canRead();
        }
    }

    public String getShortName() {
        return MdShellDirFactory.getShortName(this.getName());
    }

    public MdShellDirDirectoryAbstract getParentDirectory() {
        try {
            if (this.fileMySelf == null) {
                return null;
            }
            File fileWrkParent = this.fileMySelf.getParentFile();
            if (fileWrkParent == null) {
                return new MdShellDirDirectoryRoot();
            }
            String strWrkDirectory = fileWrkParent.getCanonicalPath();
            return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(this.shellenv, MdShellDirFactory.native2uri(strWrkDirectory), true);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            return null;
        }
    }

    public MdShellDirDirectoryAbstract getChildDirectory(String strSubDirectory) {
        String strSeparator = System.getProperty("file.separator");
        String strCurrentDirectory = this.getName();
        String strFullPathDirectory = null;
        strFullPathDirectory = strCurrentDirectory.endsWith(strSeparator) ? strCurrentDirectory + strSubDirectory : strCurrentDirectory + strSeparator + strSubDirectory;
        MdShellDirDirectoryFileSystem filesystemnode = (MdShellDirDirectoryFileSystem)MdShellDirFactory.getInstance(this.shellenv, MdShellDirFactory.native2uri(strFullPathDirectory), true);
        if (filesystemnode.isDirectoryExist()) {
            return filesystemnode;
        }
        return null;
    }

    public boolean isDirectoryExist() {
        return this.fileMySelf.exists();
    }

    public Vector listDirectory(MdShellEnv shellenv, int iSelect, String strRe) {
        Vector<MdShellDirNodeInfo> vecList = new Vector<MdShellDirNodeInfo>(1024);
        File[] fileList = this.fileMySelf.listFiles();
        if (fileList == null) {
            return null;
        }
        for (int index = 0; index < fileList.length; ++index) {
            try {
                MdShellDirNodeInfo look;
                File fileCheckFile = fileList[index];
                if (fileCheckFile.isDirectory()) {
                    if (iSelect != 1 && iSelect != 2 || !MdShellDirDirectoryFileSystem.isReMatch(strRe, ((MdShellDirDirectoryFileSystem)(look = (MdShellDirDirectoryFileSystem)MdShellDirFactory.getInstance(shellenv, MdShellDirFactory.native2uri(fileCheckFile.getCanonicalPath()), true))).getShortName())) continue;
                    vecList.addElement(look);
                    continue;
                }
                if (iSelect != 1 && iSelect != 3 || !MdShellDirDirectoryFileSystem.isReMatch(strRe, ((MdShellDirFileFileSystem)(look = (MdShellDirFileFileSystem)MdShellDirFactory.getInstance(shellenv, MdShellDirFactory.native2uri(fileCheckFile.getCanonicalPath()), false))).getShortName())) continue;
                vecList.addElement(look);
                continue;
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
        }
        Collections.sort(vecList, new MdShellFileNameComparator(MdShellDirDirectoryFileSystem.getCollatorInstance()));
        return vecList;
    }

    public boolean delete() {
        return this.fileMySelf.delete();
    }
}

