/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.cmd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdDefault;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellUtilExec;

public class MdShellCommandMmake
extends MdShellCmdDefault {
    public final boolean isRebuild = true;
    public final String CLASS_PATH = ".;xerces.jar";

    public MdShellCommandMmake() {
        this.setCommand("mmake");
        this.setDisplayString("compile java source code in current and child directory.");
    }

    public void processCommand(MdShellEnv shellenv) {
        try {
            Vector vecTotalDirectory = shellenv.getCurrentDirectory().listDirectoryWithSubDirectory(shellenv, 3, ".java$");
            String strCurrentDirectory = shellenv.getCurrentDirectory().getName();
            int iBaseLength = strCurrentDirectory.length();
            HashMap<String, MdShellDirFileAbstract> hashDirectoryToCompile = new HashMap<String, MdShellDirFileAbstract>(8192);
            for (int index = 0; index < vecTotalDirectory.size(); ++index) {
                String strLook;
                MdShellDirFileAbstract look;
                if (!(vecTotalDirectory.elementAt(index) instanceof MdShellDirFileAbstract) || !(look = (MdShellDirFileAbstract)vecTotalDirectory.elementAt(index)).getName().endsWith(".java") || hashDirectoryToCompile.get(strLook = MdShellDirFactory.getPathWithoutShortName(look.getName())) != null) continue;
                strLook = strLook.length() > iBaseLength ? strLook.substring(iBaseLength + 1) : strLook.substring(iBaseLength);
                hashDirectoryToCompile.put(strLook, look);
            }
            if (hashDirectoryToCompile.size() == 0) {
                shellenv.getOut().println("There was no necessary file of build.");
                return;
            }
            StringBuffer strbufCompile = new StringBuffer("javac -g:none -classpath .;xerces.jar");
            Set setDir = hashDirectoryToCompile.entrySet();
            String strSeparator = System.getProperty("file.separator");
            Iterator iterator = setDir.iterator();
            while (iterator.hasNext()) {
                Map.Entry mapDirectory = iterator.next();
                if (mapDirectory.getKey().toString().length() > 0) {
                    strbufCompile.append(" " + MdShellDirFactory.uri2native((String)mapDirectory.getKey()) + strSeparator + "*.java");
                    continue;
                }
                strbufCompile.append(" " + MdShellDirFactory.uri2native((String)mapDirectory.getKey()) + "*.java");
            }
            MdShellUtilExec.exec(shellenv, strbufCompile.toString());
        }
        catch (Exception ex) {
            shellenv.getOut().println(ex);
            ex.printStackTrace();
        }
    }
}

