
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.eng;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import java.io.*;
import java.util.*;

public abstract class MdShellHistory
{
	private Vector vecFileHistory=new Vector(1024);
	protected String strFileName=null;

	public MdShellHistory(String strFileName)
	{
		this.strFileName=strFileName;
	}

	public void init()
	{
		load();
	}

	public void load()
	{
		try{
			File fileLoad=new File(strFileName);
			if(fileLoad.exists()==false)
			{
				return;
			}
			BufferedReader reader=new BufferedReader(new FileReader(fileLoad));
			for(;;)
			{
				String strRead=reader.readLine();
				if(strRead==null)
				{
					break;
				}
				strRead=strRead.trim();
				if(strRead!=null
				&& strRead.length()>0)
				{
					vecFileHistory.addElement(strRead);
				}
			}
			reader.close();
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
	}

	public void save()
	{
		try{
			BufferedWriter writer=new BufferedWriter(new FileWriter(strFileName));
			for(int index=0;index<vecFileHistory.size();index++)
			{
				writer.write((String)vecFileHistory.elementAt(index));
				writer.newLine();
			}
			writer.flush();
			writer.close();
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
	}

	public Vector getHistory()
	{
		return vecFileHistory;
	}

	public void addHistory(String strAdd)
	{
		for(int index=0;index<vecFileHistory.size();index++)
		{
			if(strAdd.equals((String)vecFileHistory.elementAt(index)))
			{
				// hit
				return;
			}
		}
		vecFileHistory.addElement(strAdd);
	}
}

