
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.io;

import java.io.*;

public final class MdShellBase64OutputStream
	extends OutputStream
{
	private OutputStream outStream=null;
	private MdShellBase64Util mdshellbase64util=new MdShellBase64Util();
	private int iBufferCount=0;
	private int iBufferLength=0;
	private int[] bufferBase64=new int[3];

	public MdShellBase64OutputStream(OutputStream outStream)
	{
		this.outStream=outStream;
	}

	public final void write(int bArg) throws IOException
	{
		bufferBase64[iBufferCount++]=bArg;iBufferLength++;
		if(iBufferCount==3||iBufferLength>56)internalDo();
	}

	public final void flush() throws IOException
	{
		internalDo();
		outStream.flush();
	}

	public final void close() throws IOException
	{
		internalDo();
		outStream.close();
	}

	private final void internalDo() throws IOException
	{
		if(iBufferCount==0)return;
		byte[] byteOutWork=mdshellbase64util.encodeBuf(bufferBase64,iBufferCount);
		outStream.write(byteOutWork[0]);
		outStream.write(byteOutWork[1]);
		outStream.write(byteOutWork[2]);
		outStream.write(byteOutWork[3]);
		if(iBufferLength>56){iBufferLength=0;outStream.write(0x0a);}
		iBufferCount=0;
	}
}



