/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.cmd;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdDefault;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellUtilExec;

public class MdShellCommandEdit
extends MdShellCmdDefault {
    public MdShellCommandEdit() {
        this.setCommand("edit");
        this.setDisplayString("text editor");
    }

    public void processCommand(MdShellEnv shellenv) throws MdShellCancelException {
        String strFilename = this.getFileNameFromHistory(shellenv);
        if (strFilename != null) {
            StringTokenizer toknizerTab = new StringTokenizer(strFilename, "\t\n", false);
            while (true) {
                String strFile = null;
                try {
                    strFile = toknizerTab.nextToken();
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                MdShellUtilExec.exec(shellenv, shellenv.getCommandList().getFullPathNameByCommand("$edit") + " " + MdShellDirFactory.quoteFileNameWhenSpaceIsExist(strFile) + "&");
            }
        }
    }

    private String getFileNameFromHistory(MdShellEnv shellenv) throws MdShellCancelException {
        String strFilename = null;
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, shellenv.getFileHistory(), new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select file.: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        strFilename = formatter.format(MdShellListSelection.selectFromList(shellenv, shellenv.getFileHistory(), formatter, shellenv.getNextLine()));
        if (strFilename == null) {
            throw new MdShellCancelException();
        }
        shellenv.getOut().println("get from history [" + strFilename + "]");
        return strFilename;
    }
}

