/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.io;

import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInterface;
import jp.ne.nifty.iga.midori.shell.io.MdShellDisplayFormatterInterface;
import jp.ne.nifty.iga.midori.shell.util.MdShellUtilString;

public class MdShellDirLongListFormatter
implements MdShellDisplayFormatterInterface {
    public int iTotalFileLength = 0;
    public int iTotalDirectoryCount = 0;
    public int iTotalFileCount = 0;

    public String format(Object objArg) {
        if (objArg == null) {
            return null;
        }
        MdShellDirNodeInterface path = (MdShellDirNodeInterface)objArg;
        StringBuffer strbufWrk = new StringBuffer();
        if (path instanceof MdShellDirDirectoryAbstract) {
            strbufWrk.append("d");
            ++this.iTotalDirectoryCount;
        } else {
            strbufWrk.append("-");
            ++this.iTotalFileCount;
        }
        this.iTotalFileLength = (int)((long)this.iTotalFileLength + path.getFileLength());
        if (path.canRead()) {
            strbufWrk.append("r");
        } else {
            strbufWrk.append("-");
        }
        if (path.canWrite()) {
            strbufWrk.append("w");
        } else {
            strbufWrk.append("-");
        }
        if (path instanceof MdShellDirDirectoryAbstract || path.getShortName().toUpperCase().endsWith(".BAT") || path.getShortName().toUpperCase().endsWith(".EXE")) {
            strbufWrk.append("x");
        } else {
            strbufWrk.append("-");
        }
        strbufWrk.append(" ");
        strbufWrk.append(MdShellUtilString.numberToString(path.getFileLength(), 12) + " ");
        strbufWrk.append(MdShellUtilString.convertLastModifiedToString(path.getLastModified()));
        strbufWrk.append(" ");
        strbufWrk.append(path.getShortName());
        return strbufWrk.toString();
    }
}

