/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInfo;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFtpServerNode;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellFtpcCloseThread;
import jp.ne.nifty.iga.midori.shell.io.MdShellFtpcInputStream;
import jp.ne.nifty.iga.midori.shell.io.MdShellFtpcNode;
import jp.ne.nifty.iga.midori.shell.io.MdShellFtpcOutputStream;

public class MdShellFtpc {
    private static MdShellFtpcCloseThread closethread = null;
    private static final Vector vecFtpc = new Vector();
    String strUri = null;
    private static final int FTP_PORT = 21;
    private boolean isLogined = false;
    private Socket socketFtpc = null;
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private String strReadMessage = null;
    private ServerSocket socketDataStream = null;
    private Socket socketDataStreamRead = null;
    private Socket socketDataStreamWrite = null;

    public static final MdShellFtpc getInstance(MdShellEnv shellenv, String strUri) {
        if (closethread == null) {
            closethread = new MdShellFtpcCloseThread(vecFtpc);
            closethread.start();
        }
        Vector vector = vecFtpc;
        synchronized (vector) {
            MdShellFtpcNode ftpcnode = MdShellFtpcNode.findByHostName(vecFtpc, MdShellDirFactory.getHostName(strUri));
            if (ftpcnode == null) {
                MdShellFtpc ftpc = new MdShellFtpc();
                ftpc.strUri = strUri;
                shellenv.getOut().println("connecting... " + MdShellDirFactory.getHostName(strUri));
                MdShellFtpServerNode ftpservernode = (MdShellFtpServerNode)shellenv.getFtpServerList().get(MdShellDirNodeInfo.SZ_PROTOCOL[2] + MdShellDirFactory.getHostName(strUri));
                if (!ftpc.login(MdShellDirFactory.getHostName(strUri), ftpservernode.strUser, ftpservernode.strPassword)) {
                    System.out.println("connect failed to [" + strUri + "]");
                    MdShellFtpc mdShellFtpc = null;
                    return mdShellFtpc;
                }
                ftpcnode = new MdShellFtpcNode(MdShellDirFactory.getHostName(strUri), ftpc);
                vecFtpc.addElement(ftpcnode);
                MdShellFtpc mdShellFtpc = ftpc;
                return mdShellFtpc;
            }
            ftpcnode.touch();
            MdShellFtpc mdShellFtpc = ftpcnode.ftpc;
            return mdShellFtpc;
        }
    }

    private final void addRef() {
        Vector vector = vecFtpc;
        synchronized (vector) {
            MdShellFtpcNode ftpcnode = MdShellFtpcNode.findByFtpc(vecFtpc, this);
            if (ftpcnode != null) {
                ftpcnode.addRef();
                ftpcnode.touch();
            }
        }
    }

    private final void releaseRef() {
        Vector vector = vecFtpc;
        synchronized (vector) {
            MdShellFtpcNode ftpcnode = MdShellFtpcNode.findByFtpc(vecFtpc, this);
            if (ftpcnode != null) {
                ftpcnode.releaseRef();
                ftpcnode.touch();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        MdShellFtpc ftpc = new MdShellFtpc();
        ftpc.login("Host", "User", "Pass");
        System.out.println(ftpc.pwd());
        ftpc.ls();
        ftpc.ascii();
        ftpc.binary();
        ftpc.cd("joy");
        System.out.println(ftpc.pwd());
        ftpc.cd("..");
        System.out.println(ftpc.pwd());
        ftpc.logout();
    }

    public final boolean isConnected() {
        return this.socketFtpc != null;
    }

    private final boolean assertConnection() {
        if (!this.isConnected() || !this.isLogined) {
            System.out.println("not connected.");
            return false;
        }
        return true;
    }

    private boolean writeCommand(String strCommand) {
        try {
            this.writer.write(strCommand, 0, strCommand.length());
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException ex) {
            System.out.println("MdShellFtpc.writeCommand(" + strCommand + "): " + ex.toString());
            return false;
        }
        return true;
    }

    private boolean login(String strDstServerName, String strUserName, String strPassword) {
        try {
            this.socketFtpc = new Socket(strDstServerName, 21);
        }
        catch (UnknownHostException ex) {
            System.err.println("unknown host: " + strDstServerName + ": " + ex.toString());
            return false;
        }
        catch (IOException ex) {
            System.err.println("fail to connect host: " + strDstServerName + ": " + ex.toString());
            return false;
        }
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.socketFtpc.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socketFtpc.getOutputStream()));
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("220")) {
                System.err.println("fail to connect.");
                return false;
            }
            this.writeCommand("USER " + strUserName);
            if (!this.readLinesWithIgnore("331 ", new String[]{"530"})) {
                return false;
            }
            this.writeCommand("PASS " + strPassword);
            if (!this.readLinesWithIgnore("230 ", new String[0])) {
                System.err.println("login failed.");
                return false;
            }
            this.isLogined = true;
        }
        catch (IOException ex) {
            System.err.println("login failed: " + ex.toString());
            return false;
        }
        this.binary();
        return true;
    }

    private boolean logout() {
        if (!this.isConnected()) {
            return false;
        }
        try {
            if (this.socketFtpc != null) {
                this.writeCommand("QUIT");
                this.strReadMessage = this.reader.readLine();
                if (this.strReadMessage != null && !this.strReadMessage.startsWith("221")) {
                    System.err.println("fail to disconnect.");
                }
                this.reader.close();
                this.reader = null;
                this.writer.close();
                this.writer = null;
                this.socketFtpc.close();
                this.socketFtpc = null;
                this.isLogined = false;
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
        }
        return true;
    }

    private boolean readLinesWithIgnore(String strSuccess, String[] strError) throws IOException {
        this.strReadMessage = this.reader.readLine();
        if (this.strReadMessage == null) {
            return false;
        }
        do {
            if (this.strReadMessage.startsWith(strSuccess)) {
                return true;
            }
            int index = 0;
            while (index < strError.length) {
                if (this.strReadMessage.startsWith(strError[index])) {
                    return false;
                }
                ++index;
            }
            this.strReadMessage = this.reader.readLine();
        } while (this.strReadMessage != null);
        return false;
    }

    private ServerSocket port() {
        if (!this.assertConnection()) {
            return null;
        }
        ServerSocket socketDataStream = null;
        try {
            socketDataStream = new ServerSocket(0);
            int iDataPort = socketDataStream.getLocalPort();
            this.addRef();
            String strPort = "PORT " + this.socketFtpc.getLocalAddress().getHostAddress().replace('.', ',') + "," + iDataPort / 256 + "," + iDataPort % 256;
            this.writeCommand(strPort);
            if (!this.readLinesWithIgnore("200", new String[0])) {
                System.err.println("PORT command failed.");
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
            return null;
        }
        return socketDataStream;
    }

    public boolean ascii() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            this.writeCommand("TYPE A N");
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("200")) {
                System.err.println("TYPE A N failed.");
                return false;
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
            return false;
        }
        return true;
    }

    public boolean binary() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            this.writeCommand("TYPE I");
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("200")) {
                System.err.println("TYPE I failed.");
                return false;
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
            return false;
        }
        return true;
    }

    public String pwd() {
        if (!this.assertConnection()) {
            return null;
        }
        try {
            this.writeCommand("PWD");
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("257")) {
                System.err.println("PWD failed");
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
            return null;
        }
        return this.strReadMessage.substring(this.strReadMessage.indexOf(34) + 1, this.strReadMessage.lastIndexOf(34));
    }

    public boolean cd(String strDirectory) {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (strDirectory.equals("..")) {
                this.writeCommand("CDUP");
                this.strReadMessage = this.reader.readLine();
                if (!this.strReadMessage.startsWith("250")) {
                    System.err.println("CDUP failed.");
                    return false;
                }
            } else {
                this.writeCommand("CWD " + strDirectory);
                this.strReadMessage = this.reader.readLine();
                if (!this.strReadMessage.startsWith("250")) {
                    System.err.println("CWD failed.");
                    return false;
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] ls() {
        byte[] byteResult = null;
        if (!this.assertConnection()) {
            return null;
        }
        try {
            try {
                int iReadLen;
                ServerSocket socketDataStreamLs = this.port();
                if (socketDataStreamLs == null) {
                    return null;
                }
                this.writeCommand("LIST");
                this.strReadMessage = this.reader.readLine();
                if (!this.strReadMessage.startsWith("150")) {
                    System.err.println("LIST failed.");
                    return null;
                }
                Socket socRead = socketDataStreamLs.accept();
                BufferedInputStream inStream = new BufferedInputStream(socRead.getInputStream());
                ByteArrayOutputStream outStream = new ByteArrayOutputStream(8192);
                byte[] byteWrk = new byte[256];
                while ((iReadLen = ((InputStream)inStream).read(byteWrk)) != -1) {
                    outStream.write(byteWrk, 0, iReadLen);
                }
                outStream.flush();
                byteResult = outStream.toByteArray();
                ((InputStream)inStream).close();
                socRead.close();
                socketDataStreamLs.close();
                socketDataStreamLs = null;
                this.releaseRef();
                this.strReadMessage = this.reader.readLine();
                if (this.strReadMessage.startsWith("226")) return byteResult;
                System.err.println("transfer failed.");
                return null;
            }
            catch (IOException e) {
                System.err.println("Error: " + e.toString());
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            throw throwable;
        }
    }

    public InputStream getInputStream(String strFilename) {
        if (!this.assertConnection()) {
            return null;
        }
        try {
            this.socketDataStream = this.port();
            if (this.socketDataStream == null) {
                return null;
            }
            this.writeCommand("RETR " + strFilename);
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("150")) {
                System.err.println("RETR failed.");
                return null;
            }
            this.socketDataStreamRead = this.socketDataStream.accept();
            this.addRef();
            return new MdShellFtpcInputStream(this, this.socketDataStreamRead.getInputStream());
        }
        catch (IOException ex) {
            System.err.println("Error: " + ex.toString());
            return null;
        }
    }

    public OutputStream getOutputStream(String strFilename) {
        if (!this.assertConnection()) {
            return null;
        }
        try {
            this.socketDataStream = this.port();
            if (this.socketDataStream == null) {
                return null;
            }
            this.writeCommand("STOR " + strFilename);
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("150")) {
                System.err.println("STOR failed.");
                return null;
            }
            this.socketDataStreamWrite = this.socketDataStream.accept();
            this.addRef();
            return new MdShellFtpcOutputStream(this, this.socketDataStreamWrite.getOutputStream());
        }
        catch (IOException ex) {
            System.err.println("Error: " + ex.toString());
            return null;
        }
    }

    public boolean closeDataSocketStream() {
        try {
            if (this.socketDataStreamRead != null) {
                this.socketDataStreamRead.close();
                this.socketDataStreamRead = null;
                this.releaseRef();
            }
            if (this.socketDataStreamWrite != null) {
                this.socketDataStreamWrite.close();
                this.socketDataStreamWrite = null;
                this.releaseRef();
            }
            if (this.socketDataStream != null) {
                this.socketDataStream.close();
                this.socketDataStream = null;
                this.releaseRef();
            }
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("226")) {
                System.err.println("transfer failed.");
                return false;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    void close() {
        this.logout();
    }

    protected void finalize() {
        this.logout();
    }

    public boolean delete(String strDirectory, String strFileName) {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (!this.cd(strDirectory)) {
                return false;
            }
            this.writeCommand("DELE " + strFileName);
            this.strReadMessage = this.reader.readLine();
            if (!this.strReadMessage.startsWith("250")) {
                System.err.println("DELE failed.");
                return false;
            }
        }
        catch (IOException ex) {
            System.err.println("Error: " + ex.toString());
            return false;
        }
        return true;
    }
}

