
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEngine;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import java.io.*;

public class JMichelle
{
	MdShellEnv shellenv=new MdShellEnv();

	public static final void main(String[] args)
	{
		JMichelle mdshell=new JMichelle();

		mdshell.init();

		int iRet=mdshell.process();

		mdshell.exit(iRet);
	}

	private void init()
	{
		shellenv.setIn(System.in);
		shellenv.setOut(System.out);
		shellenv.setErr(System.err);
	}

	private void exit(int iRet)
	{
		shellenv.save();
		System.exit(iRet);
	}

	/**
	 * Entry point for shell instance.
	 */
	public int process()
	{
		MdShellEngine shelleng=new MdShellEngine(shellenv);

		int iRet=shelleng.process();

		return iRet;
	}

	public void setIn(InputStream streamIn)
	{
		shellenv.setIn(streamIn);
	}
	public InputStream getIn()
	{
		return shellenv.getIn();
	}

	public void setOut(PrintStream printArg)
	{
		shellenv.setOut(printArg);
	}
	public PrintStream getOut()
	{
		return shellenv.getOut();
	}

	public void setErr(PrintStream printArg)
	{
		shellenv.setErr(printArg);
	}
	public PrintStream getErr()
	{
		return shellenv.getErr();
	}
}


