
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.io.*;
import java.util.*;

public class MdShellCommandSelect
	extends MdShellCmdDefault
{
	public MdShellCommandSelect()
	{
		setCommand("select");
		setDisplayString("select file or directory");
	}

	public void processCommand(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		shellenv.getOut().println("under construction.");

		Vector vecList=new Vector();
		vecList.addElement("file");
		vecList.addElement("directory");
		vecList.addElement("group");

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select what to select: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strSubCommand=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));

		if(strSubCommand==null)
		{
			throw new MdShellCancelException();
		}

		if(strSubCommand.equals("file"))
		{
			selectFile(shellenv);
		}
		else if (strSubCommand.equals("directory"))
		{
			selectDirectoryImpl(shellenv);
		}
		else if (strSubCommand.equals("group"))
		{
			shellenv.getOut().println("not implemented.");
		}
	}

	public void selectFile(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		shellenv.getOut().print("input option if exist. (ex. -Rt *.java): ");

		shellenv.promptInputIfNoDataExist();
		String[] strArgs=shellenv.getArgsArray();

		jp.ne.nifty.iga.midori.shell.util.dir.Dir dirWrk=new jp.ne.nifty.iga.midori.shell.util.dir.Dir();
		Vector vecList=dirWrk.buildData(shellenv,strArgs);

		//String strFilter=shellenv.getNextLine();
		//Vector vecList=shellenv.getCurrentDirectory().listDirectory(MdShellDirNodeInfo.SELECT_DIRECTORY_FILE,strFilter);

		MdShellDirLongListFormatter formatter=new MdShellDirLongListFormatter();
		if(vecList.size()==0)
		{
			shellenv.getOut().println("no file is selected");
			return;
		}
		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,formatter);
		shellenv.getOut().print("select file (or input all): ");
		String strSelectOneOrAll=shellenv.getNextLine();
		if(strSelectOneOrAll==null)
		{
			throw new MdShellCancelException();
		}

		MdShellDirNodeInterface dirNodeInterface=null;
		if(strSelectOneOrAll.equals("all"))
		{
			shellenv.getOut().println("all command not implemented.");
			return;
		}
		else
		{
			// specify maching formatter as directory name.
			dirNodeInterface=(MdShellDirNodeInterface)MdShellListSelection.selectFromList(shellenv,vecList,new MdShellDirectoryNameFormatter(),strSelectOneOrAll);
		}

		if(dirNodeInterface!=null)
		{
			selectProcess(shellenv,dirNodeInterface);
		}
	}

	public void selectDirectoryImpl(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		shellenv.getOut().println("select source directory.");
		MdShellDirDirectoryAbstract dirSourceDirectory=jp.ne.nifty.iga.midori.shell.util.mcd.Mcd.selectDirectoryContinuous(shellenv,shellenv.getCurrentDirectory());
		if(dirSourceDirectory==null)
		{
			throw new MdShellCancelException();
		}

		Vector vecList=new Vector();
		vecList.addElement("copy");
		vecList.addElement("delete");

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select what to do: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strSubCommand=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));

		if(strSubCommand==null)
		{
			throw new MdShellCancelException();
		}

		if(strSubCommand.equals("copy"))
		{
			shellenv.getOut().println("select target directory.");
			MdShellDirDirectoryAbstract dirTargetDirectory=jp.ne.nifty.iga.midori.shell.util.mcd.Mcd.selectDirectoryContinuous(shellenv,shellenv.getCurrentDirectory());
			if(dirTargetDirectory==null)
			{
				throw new MdShellCancelException();
			}

			shellenv.getOut().println("start to copy plan.");
			shellenv.getOut().println("copy "+dirSourceDirectory.getName()+" -> "+dirTargetDirectory.getName());
		}

		shellenv.getOut().println("not implemented.");
	}

	public void selectProcess(MdShellEnv shellenv,MdShellDirNodeInterface dirNodeInterface)
		throws MdShellCancelException
	{
		Vector vecList=new Vector();
		vecList.addElement("copy");
		vecList.addElement("delete");
		vecList.addElement("edit");

		if(shellenv.getCommandList().getFullPathNameByCommand("wedit")!=null
		&&(dirNodeInterface.getName().endsWith("html")||dirNodeInterface.getName().endsWith("htm")))
		{
			vecList.addElement("wedit");
		}

		vecList.addElement("cat");
		vecList.addElement("n2a");
		vecList.addElement("a2n");

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select what to do: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strSubCommand=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));

		if(strSubCommand==null)
		{
			throw new MdShellCancelException();
		}

		if(strSubCommand.equals("copy"))
		{
			shellenv.getOut().println("select target directory.");
			MdShellDirDirectoryAbstract dirTargetDirectory=jp.ne.nifty.iga.midori.shell.util.mcd.Mcd.selectDirectoryContinuous(shellenv,shellenv.getCurrentDirectory());
			if(dirTargetDirectory!=null)
			{
				shellenv.getOut().println("start to copy plan.");

				String strBaseDirectory=shellenv.getCurrentDirectory().getName();
				shellenv.getOut().println("base directory: "+strBaseDirectory);
				shellenv.getOut().println("copy "+dirNodeInterface.getName().substring(strBaseDirectory.length()+1)+" -> "+dirTargetDirectory.getName());
			}
		}
		else if(strSubCommand.equals("delete"))
		{
			shellenv.getOut().println("start to delete.");
			dirNodeInterface.delete();
			return;
		}
		else if(strSubCommand.equals("edit"))
		{
			shellenv.getOut().println("edit file");
			MdShellUtilExec.exec(shellenv,shellenv.getCommandList().getFullPathNameByCommand("$edit")+" "+MdShellDirFactory.quoteFileNameWhenSpaceIsExist(MdShellDirFactory.uri2native(dirNodeInterface.getName()))+"&");
			shellenv.getFileHistory().addElement(MdShellDirFactory.uri2native(dirNodeInterface.getName()));
			return;
		}
		else if(strSubCommand.equals("wedit"))
		{
			shellenv.getOut().println("edit web file");
			MdShellUtilExec.exec(shellenv,shellenv.getCommandList().getFullPathNameByCommand("wedit").replace('&',' ')+" "+MdShellDirFactory.quoteFileNameWhenSpaceIsExist(MdShellDirFactory.uri2native(dirNodeInterface.getName()))+"&");
			shellenv.getFileHistory().addElement(MdShellDirFactory.uri2native(dirNodeInterface.getName()));
			return;
		}
		else if(strSubCommand.equals("cat"))
		{
			jp.ne.nifty.iga.midori.shell.util.cat.Cat catWrk=new jp.ne.nifty.iga.midori.shell.util.cat.Cat();
			catWrk.cat(shellenv,(MdShellDirFileAbstract)dirNodeInterface);
			return;
		}
		else if(strSubCommand.equals("n2a"))
		{
			try{
				MdShellDirFileAbstract dirfileOutput=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,dirNodeInterface.getName()+".ascii.temp",false);
				InputStream inStream=((MdShellDirFileAbstract)dirNodeInterface).getInputStream();
				OutputStream outStream=dirfileOutput.getOutputStream();
				MdShellNativeToAscii.native2ascii(inStream,outStream);
				inStream.close();
				outStream.flush();
				outStream.close();
				dirfileOutput.setLastModified(dirNodeInterface.getLastModified());
			}catch(IOException ex){
				System.out.println(ex.toString());
				ex.printStackTrace();
			}
			return;
		}
		else if(strSubCommand.equals("a2n"))
		{
			try{
				MdShellDirFileAbstract dirfileOutput=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,dirNodeInterface.getName()+".native.temp",false);
				InputStream inStream=((MdShellDirFileAbstract)dirNodeInterface).getInputStream();
				OutputStream outStream=dirfileOutput.getOutputStream();
				MdShellNativeToAscii.ascii2native(inStream,outStream);
				inStream.close();
				outStream.flush();
				outStream.close();
				dirfileOutput.setLastModified(dirNodeInterface.getLastModified());
			}catch(IOException ex){
				System.out.println(ex.toString());
				ex.printStackTrace();
			}
			return;
		}

		shellenv.getOut().println("not implemented.["+strSubCommand+"]");
	}
}


