
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import gnu.regexp.*;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import java.io.*;
import java.text.Collator;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public abstract class MdShellDirDirectoryAbstract
	extends MdShellDirNodeInfo
{
	public abstract String getShortName();

	// it only set member valiable.
	public void setLastModified(long lastModified)
	{
		this.lastModified=lastModified;
	}

	public abstract MdShellDirDirectoryAbstract getParentDirectory();
	public abstract MdShellDirDirectoryAbstract getChildDirectory(String strSubDirectory);

	public abstract Vector listDirectory(MdShellEnv shellenv,int iSelect,String strRe);

	public final Vector listDirectoryWithSubDirectory(MdShellEnv shellenv,int iSelect,String strRe)
	{
		Vector vecTotalDirectory=new Vector(8192);
		listDirectoryWithSubDirectoryInternal(shellenv,iSelect,strRe,vecTotalDirectory,this);
		return vecTotalDirectory;
	}
	private final void listDirectoryWithSubDirectoryInternal(MdShellEnv shellenv,int iSelect,String strRe,Vector vecTotalDirectory,MdShellDirDirectoryAbstract dirDirCurrent)
	{
		int iWrk=iSelect;
		if(iWrk==SELECT_FILE)
		{
			iWrk=SELECT_DIRECTORY_FILE;
		}
		Vector vecList=dirDirCurrent.listDirectory(shellenv,iWrk,null);
		for(int index=0;index<vecList.size();index++)
		{
			if(vecList.elementAt(index) instanceof MdShellDirDirectoryAbstract)
			{
				//System.out.println(((MdShellDirDirectoryAbstract)vecList.elementAt(index)).getName());
				MdShellDirDirectoryAbstract look=(MdShellDirDirectoryAbstract)vecList.elementAt(index);
				if(iSelect==SELECT_DIRECTORY_FILE
				|| iSelect==SELECT_DIRECTORY)
				{
					if(isReMatch(strRe,look.getShortName()))
					{
						vecTotalDirectory.addElement(look);
					}
				}
				if(look.getName().endsWith(".")==false
				&& look.getName().endsWith("..")==false)
				{
					listDirectoryWithSubDirectoryInternal(shellenv,iSelect,strRe,vecTotalDirectory,look);
				}
			}
			else if(vecList.elementAt(index) instanceof MdShellDirFileAbstract)
			{
				MdShellDirFileAbstract look=(MdShellDirFileAbstract)vecList.elementAt(index);
				//System.out.println(look.getName());
				if(iSelect==SELECT_DIRECTORY_FILE
				|| iSelect==SELECT_FILE)
				{
					if(isReMatch(strRe,look.getShortName()))
					{
						vecTotalDirectory.addElement(look);
					}
				}
			}
		}
	}

	public static final boolean isReMatch(String strRe,String strLine)
	{
		if(strRe!=null
		&& strRe.length()>0)
		{
			try{
				//String strReWrk="^"+strRe+"$";
				String strReWrk=strRe;
				//System.out.println("new RE("+strReWrk+")");
				RE rex=new RE(strReWrk,RE.REG_ICASE,RESyntax.RE_SYNTAX_GREP);//RE_SYNTAX_GREP
				if(rex.getMatch(strLine)!=null)
				{
					return true;
				}
				else if(rex.isMatch(strLine))
				{
					return true;
				}
			}catch(REException ex){
				System.out.println(ex.toString());
				//ex.printStackTrace();
			}
		}
		else
		{
			// !!!
			return true;
		}
		return false;
	}

	public static final Collator getCollatorInstance()
	{
		Collator collator=Collator.getInstance();
		collator.setStrength(Collator.PRIMARY);
		collator.setDecomposition(Collator.FULL_DECOMPOSITION);
		return collator;
	}
}


