
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import java.io.*;
import java.text.Collator;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public class MdShellDirDirectoryFileSystem
	extends MdShellDirDirectoryAbstract
{
	private File fileMySelf=null;
	private MdShellEnv shellenv=null;

	public MdShellDirDirectoryFileSystem(MdShellEnv shellenv,String strUri,File file)
	{
		this.shellenv=shellenv;
		this.fileMySelf=file;
		setType(FILE);
		setName(strUri);

		if(strUri.endsWith(MdShellDirFactory.getWindowsRootStyle())==false)
		{
			setFileLength(fileMySelf.length());
			this.lastModified=fileMySelf.lastModified();
			bCanWrite=fileMySelf.canWrite();
			bCanRead=fileMySelf.canRead();
		}
	}

	public String getShortName()
	{
		return MdShellDirFactory.getShortName(getName());
	}

	public MdShellDirDirectoryAbstract getParentDirectory()
	{
		try{
			if(fileMySelf==null)
			{
				return null;
			}
			File fileWrkParent=fileMySelf.getParentFile();
			if(fileWrkParent==null)
			{
				// ROOT means special root directory for Windows environment.
				return new MdShellDirDirectoryRoot();
			}
			String strWrkDirectory=fileWrkParent.getCanonicalPath();
			return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(shellenv,MdShellDirFactory.native2uri(strWrkDirectory),true);
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
		return null;
	}

	public MdShellDirDirectoryAbstract getChildDirectory(String strSubDirectory)
	{
		String strSeparator=System.getProperty("file.separator");

		//try{
			String strCurrentDirectory=getName();

			String strFullPathDirectory=null;
			if(strCurrentDirectory.endsWith(strSeparator))
			{
				strFullPathDirectory=strCurrentDirectory+strSubDirectory;
			}
			else
			{
				strFullPathDirectory=strCurrentDirectory+strSeparator+strSubDirectory;
			}

			MdShellDirDirectoryFileSystem filesystemnode=(MdShellDirDirectoryFileSystem)MdShellDirFactory.getInstance(shellenv,MdShellDirFactory.native2uri(strFullPathDirectory),true);

			if(filesystemnode.isDirectoryExist())
			{
				return filesystemnode;
			}
		//}catch(IOException ex){
		//	System.out.println(ex.toString());
		//	ex.printStackTrace();
		//}
		return null;
	}

	// ???
	public boolean isDirectoryExist()
	{
		return fileMySelf.exists();
	}

	/**
	 * @param int iDirectoryAndFile: 1:DIRECTORY&FILE 2:DIRECTORY 3:FILE
	 */
	public Vector listDirectory(MdShellEnv shellenv,int iSelect,String strRe)
	{
		Vector vecList=new Vector(1024);

		File[] fileList=fileMySelf.listFiles();

		if(fileList==null)
		{
			return null;
		}

		for(int index=0;index<fileList.length;index++)
		{
			try{
				File fileCheckFile=fileList[index];
				if(fileCheckFile.isDirectory())
				{
					if(iSelect==SELECT_DIRECTORY_FILE
					|| iSelect==SELECT_DIRECTORY)
					{
						//MdShellDirDirectoryFileSystem look=new MdShellDirDirectoryFileSystem(fileCheckFile);
						MdShellDirDirectoryFileSystem look=(MdShellDirDirectoryFileSystem)MdShellDirFactory.getInstance(shellenv,MdShellDirFactory.native2uri(fileCheckFile.getCanonicalPath()),true);

						if(isReMatch(strRe,look.getShortName()))
						{
							vecList.addElement(look);
						}
					}
				}
				else
				{
					if(iSelect==SELECT_DIRECTORY_FILE
					|| iSelect==SELECT_FILE)
					{
						MdShellDirFileFileSystem look=(MdShellDirFileFileSystem)MdShellDirFactory.getInstance(shellenv,MdShellDirFactory.native2uri(fileCheckFile.getCanonicalPath()),false);
						if(isReMatch(strRe,look.getShortName()))
						{
							vecList.addElement(look);
						}
					}
				}
			}catch(IOException ex){
				System.out.println(ex.toString());
				ex.printStackTrace();
			}
		}

		Collections.sort(vecList,new MdShellFileNameComparator(getCollatorInstance()));

		return vecList;
	}

	public boolean delete()
	{
		return fileMySelf.delete();
	}
}


