
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.*;
import java.io.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public class MdShellDirFileFtpClient
	extends MdShellDirFileAbstract
{
	private MdShellEnv shellenv=null;

	private String strUsername;
	private String strPassword;

	public MdShellDirFileFtpClient(MdShellEnv shellenv,String strUri)
	{
		this.shellenv=shellenv;

		setType(FTP);
		setName(strUri);

		MdShellFtpServerNode ftpservernode=(MdShellFtpServerNode)shellenv.getFtpServerList().get(SZ_PROTOCOL[getType()]+MdShellDirFactory.getHostName(strUri));
		strUsername=ftpservernode.strUser;
		strPassword=ftpservernode.strPassword;

		setFileLength(0);
		lastModified=0;
		bCanWrite=true;
		bCanRead=true;
	}

	public String getShortName()
	{
		int iFind=getName().lastIndexOf('/');
		if(iFind>=0)
		{
			return getName().substring(getName().lastIndexOf('/')+1);
		}

		return getName();
	}

	public MdShellDirDirectoryAbstract getPath()
	{
		//System.out.println("debug: 1: "+getName());
		//if(new File(MdShellDirFileSystemUtil.trimDeviceName(getName())).isDirectory())
		//{
		//	// As a matter of fact, it was a directory though it thought that 
		//	// this was file so far.
		//	return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(getName());
		//}

		//String strPathWithoutShortName=MdShellDirFileSystemUtil.getPathWithoutShortName(getName());
		//System.out.println("debug: 2: "+strPathWithoutShortName);
		return null;
	}

	public void setLastModified(long lastModified)
	{
		this.lastModified=lastModified;
	}

	public final InputStream getInputStream()
	{
		MdShellFtpc ftpc=MdShellFtpc.getInstance(shellenv,getName());
		if(ftpc==null)
		{
			return null;
		}
		if(ftpc.cd(MdShellDirFactory.getDirectory(getName(),false))==false)
		{
			System.out.println("cd is failed");
			return null;
		}

		InputStream inStream=ftpc.getInputStream(MdShellDirFactory.getShortName(getName()));
		return inStream;
	}

	public final OutputStream getOutputStream()
	{
		MdShellFtpc ftpc=MdShellFtpc.getInstance(shellenv,getName());
		if(ftpc==null)
		{
			return null;
		}
		if(ftpc.cd(MdShellDirFactory.getDirectory(getName(),false))==false)
		{
			System.out.println("cd is failed");
			return null;
		}

		OutputStream outStream=ftpc.getOutputStream(MdShellDirFactory.getShortName(getName()));
		return outStream;
	}

	public boolean delete()
	{
		MdShellFtpc ftpc=MdShellFtpc.getInstance(shellenv,getName());
		if(ftpc==null)
		{
			return false;
		}
		boolean bRet=ftpc.delete(MdShellDirFactory.getDirectory(getName(),false),MdShellDirFactory.getShortName(getName()));
		return bRet;
	}
}


