
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.util;

import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.io.*;
import java.util.*;

// !!! causion. this class depends on sun.io.CharToByteConverter;
import sun.io.CharToByteConverter;

public class MdShellNativeToAscii
{
	public static final void native2ascii(InputStream inStream,OutputStream outStream)
		throws IOException
	{
		BufferedReader reader=new BufferedReader(new InputStreamReader(inStream));
		for(;;)
		{
			int iRead=reader.read();
			if(iRead<0)break;
			if(iRead>0x007f)
			{
				outStream.write('\\');
				outStream.write('u');
				String strHex=Integer.toHexString(iRead);
				strHex=fillHexToLength(strHex,4);
				for(int index=0;index<4;index++)
				{
					outStream.write(strHex.charAt(index));
				}
			}
			else
			{
				outStream.write((char)iRead);
			}
		}
		outStream.flush();
	}

	public static final void ascii2native(InputStream inStream,OutputStream outStream)
		throws IOException
	{
		CharToByteConverter c2b=CharToByteConverter.getDefault();
		c2b.setSubstitutionMode(false);

		BufferedReader reader=new BufferedReader(new InputStreamReader(inStream));
		BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(outStream));
		for(;;)
		{
			CharArrayWriter writerBuf=new CharArrayWriter();
			int iRead=reader.read();
			if(iRead<0)break;
			writerBuf.write((char)iRead);

			if(iRead=='\\')
			{
				iRead=reader.read();
				if(iRead<0)break;
				writerBuf.write((char)iRead);

				if(iRead=='u')
				{
					iRead=reader.read();
					if(iRead<0)break;
					writerBuf.write((char)iRead);

					iRead=reader.read();
					if(iRead<0)break;
					writerBuf.write((char)iRead);

					iRead=reader.read();
					if(iRead<0)break;
					writerBuf.write((char)iRead);

					iRead=reader.read();
					if(iRead<0)break;
					writerBuf.write((char)iRead);

					String strCharCheck=writerBuf.toString();
					char cCheck=(char)Integer.parseInt(strCharCheck.substring(2),16);
					if(c2b.canConvert(cCheck))
					{
						writer.write(cCheck);
						continue;
					}
				}
			}

			writer.write(writerBuf.toCharArray());
		}
		writer.flush();
	}

	private static final String fillHexToLength(String strArgs,int iLength)
	{
		for(;strArgs.length()<iLength;)
		{
			strArgs="0"+strArgs;
		}
		return strArgs;
	}

}



