
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.util.mcd;

import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.util.*;

public class Mcd
{
	public static MdShellDirDirectoryAbstract selectDirectory(
		MdShellEnv shellenv,MdShellDirDirectoryAbstract dirBaseDirectory)
		throws MdShellCancelException
	{
		Vector vecList=new Vector();
		if(dirBaseDirectory instanceof MdShellDirDirectoryRoot==false)
		{
			vecList.addElement("..");
			vecList.addElement("parent");
		}

		vecList.addElement("child");
		vecList.addElement("history");

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select how to move directory: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strSubCommand=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));

		if(strSubCommand==null)
		{
			throw new MdShellCancelException();
		}

		if(strSubCommand.equals(".."))
		{
			return dirBaseDirectory.getParentDirectory();
		}
		else if(strSubCommand.equals("parent"))
		{
			return cdParentDirectory(shellenv,dirBaseDirectory);
		}
		if(strSubCommand.equals("child"))
		{
			return cdChildDirectory(shellenv,dirBaseDirectory);
		}
		if(strSubCommand.equals("history"))
		{
			return cdHistoryDirectory(shellenv,dirBaseDirectory);
		}
		else
		{
			shellenv.getOut().println("not yet implemented.");
		}

		{
			shellenv.getOut().println("current directory: "+dirBaseDirectory.getName());
			shellenv.getOut().println("select directory to move: ");
		}
		return null;
	}

	public static MdShellDirDirectoryAbstract selectDirectoryContinuous(
		MdShellEnv shellenv,MdShellDirDirectoryAbstract dirBaseDirectory)
		throws MdShellCancelException
	{
		MdShellDirDirectoryAbstract dirTargetDirectory=null;
		try{
			for(MdShellDirDirectoryAbstract dirNextDirectory=dirBaseDirectory;;)
			{
				dirNextDirectory=selectDirectory(shellenv,dirNextDirectory);
				if(dirNextDirectory==null)
				{
					break;
				}
				shellenv.getOut().println("current target is :"+dirNextDirectory.getName());
				dirTargetDirectory=dirNextDirectory;
			}
		}catch(MdShellCancelException ex){
			;
		}

		if(dirTargetDirectory==null)
		{
			throw new MdShellCancelException();
		}

		shellenv.getOut().println("selected target directory is :"+dirTargetDirectory.getName());
		//shellenv.getOut().println("Here is under construction.");

		return dirTargetDirectory;
	}

	private static MdShellDirDirectoryAbstract cdParentDirectory(
		MdShellEnv shellenv,MdShellDirDirectoryAbstract dirBaseDirectory)
		throws MdShellCancelException
	{
		Vector vecList=new Vector();

		for(MdShellDirDirectoryAbstract dirLook=dirBaseDirectory;;)
		{
			dirLook=dirLook.getParentDirectory();
			if(dirLook==null)
			{
				break;
			}
			//shellenv.getOut().println("debug: "+dirLook.getName());
			vecList.addElement(dirLook);
		}

		Collections.sort(vecList,new MdShellFileNameComparator(shellenv.getCollatorInstance()));

		MdShellDirectoryNameFormatter formatter=new MdShellDirectoryNameFormatter();
		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,formatter);
		shellenv.getOut().print("select directory to move: ");
		MdShellDirDirectoryAbstract dirNewDirectory=(MdShellDirDirectoryAbstract)MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine());
		if(dirNewDirectory==null)
		{
			throw new MdShellCancelException();
		}

		return dirNewDirectory;
	}

	private static MdShellDirDirectoryAbstract cdChildDirectory(
		MdShellEnv shellenv,MdShellDirDirectoryAbstract dirBaseDirectory)
		throws MdShellCancelException
	{
		Vector vecList=dirBaseDirectory.listDirectory(shellenv,MdShellDirNodeInfo.SELECT_DIRECTORY,null);
		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDirectoryShortNameFormatter());
		shellenv.getOut().print("select directory to move: ");
		MdShellDirectoryShortNameFormatter formatter=new MdShellDirectoryShortNameFormatter();
		MdShellDirDirectoryAbstract dirNewDirectory=(MdShellDirDirectoryAbstract)MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine());
		if(dirNewDirectory==null)
		{
			throw new MdShellCancelException();
		}

		return dirNewDirectory;
	}

	private static MdShellDirDirectoryAbstract cdHistoryDirectory(
		MdShellEnv shellenv,MdShellDirDirectoryAbstract dirBaseDirectory)
		throws MdShellCancelException
	{
		MdShellListSelection.showVectorListWithNumberAndString(shellenv,shellenv.getDirectoryHistory().getHistory(),new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select directory.: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strDirectoryName=formatter.format(MdShellListSelection.selectFromList(shellenv,shellenv.getDirectoryHistory().getHistory(),formatter,shellenv.getNextLine()));
		if(strDirectoryName==null)
		{
			throw new MdShellCancelException();
		}
		shellenv.getOut().println("get from history ["+strDirectoryName+"]");
		return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(shellenv,strDirectoryName,true);
	}
}


