
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.util.*;

public class MdShellCommandMcd
	extends MdShellCmdDefault
{
	public MdShellCommandMcd()
	{
		setCommand("mcd");
		setDisplayString("change directory       , cd is alias");
	}

	public void registerImplementedCommand(Vector vecList)
	{
		vecList.addElement(getCommand());
		vecList.addElement("cd");
	}

	public boolean isThisCommand(MdShellEnv shellenv,String strCommand)
	{
		Collator collator=shellenv.getCollatorInstance();
		if(collator.equals(strCommand,getCommand())==false
		&& collator.equals(strCommand,"cd")==false)
		{
			return false;
		}
		return true;
	}


	public void processCommand(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		shellenv.getOut().println(shellenv.getCurrentDirectory().getName());

		MdShellDirDirectoryAbstract dirNewDirectory=jp.ne.nifty.iga.midori.shell.util.mcd.Mcd.selectDirectory(shellenv,shellenv.getCurrentDirectory());
		if(dirNewDirectory!=null)
		{
			shellenv.setCurrentDirectory(dirNewDirectory);
			shellenv.getOut().println(shellenv.getCurrentDirectory().getName());

			// add directory history
			shellenv.getDirectoryHistory().addHistory(dirNewDirectory.getName());
		}

		// bellow code is for continuing change directory.
		//for(;processCommandImplementation(shellenv);)
		//{
		//}

	}
}


