
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import gnu.regexp.*;

import java.io.*;
import java.text.Collator;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public abstract class MdShellDirNodeInfo
	implements MdShellDirNodeInterface
{
	private int iType=-1;

	protected long lastModified=-1;
	private long fileLength=0;

	public static final int ROOT=0;
	public static final int FILE=1;
	public static final int FTP=2;
	public static final int HTTP=3;
	public static final String[] SZ_PROTOCOL={"root://","file://","ftp://","http://","mail://","sql://","nfs://"};

	public static final int SELECT_DIRECTORY_FILE=1;
	public static final int SELECT_DIRECTORY=2;
	public static final int SELECT_FILE=3;

	private String strCacheName=null;
	public final String getName()
	{
		return strCacheName;
	}
	protected final void setName(String strName)
	{
		this.strCacheName=strName;
	}

	public final void setType(int iType)
	{
		this.iType=iType;
	}

	public final int getType()
	{
		return iType;
	}

	public final long getLastModified()
	{
		return lastModified;
	}

	public abstract void setLastModified(long lastModified);

	public final long getFileLength()
	{
		return fileLength;
	}

	public final void setFileLength(long fileLength)
	{
		this.fileLength=fileLength;
	}

	protected boolean bCanRead=false;
	protected boolean bCanWrite=false;

	public boolean canRead()
	{
		return bCanRead;
	}

	public boolean canWrite()
	{
		return bCanWrite;
	}


}


