/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "kz-sidebar.h"

#ifndef __KZ_THUMBNAILS_SIDEBAR_H__
#define __KZ_THUMBNAILS_SIDEBAR_H__

#define KZ_TYPE_THUMBNAILS_SIDEBAR			(kz_thumbnails_sidebar_get_type ())
#define KZ_THUMBNAILS_SIDEBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_THUMBNAILS_SIDEBAR, KzThumbnailsSidebar))
#define KZ_THUMBNAILS_SIDEBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_THUMBNAILS_SIDEBAR, KzThumbnailsSidebarClass))
#define KZ_IS_THUMBNAILS_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_THUMBNAILS_SIDEBAR))
#define KZ_IS_THUMBNAILS_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_THUMBNAILS_SIDEBAR))
#define KZ_THUMBNAILS_SIDEBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_THUMBNAILS_SIDEBAR, KzThumbnailsSidebarClass))

typedef struct _KzThumbnailsSidebar		KzThumbnailsSidebar;
typedef struct _KzThumbnailsSidebarClass		KzThumbnailsSidebarClass;
typedef struct _KzThumbnailsSidebarPriv		KzThumbnailsSidebarPriv;
typedef struct _KzThumbnailsSidebarItem		KzThumbnailsSidebarItem;

struct _KzThumbnailsSidebar
{
	GtkVBox          parent;

	GtkWidget	*view;
	KzSidebar       *sidebar;
};

struct _KzThumbnailsSidebarClass
{
	GtkVBoxClass parent_class;
};

KzSidebarEntry   *kz_thumbnails_sidebar_get_entry (gint idx);

GtkType	          kz_thumbnails_sidebar_get_type  (void);


#endif /* __KZ_THUMBNAILS_SIDEBAR_H__ */
