/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-embed-event.h"

KzEmbedEvent *
kz_embed_event_new  (KzEmbedEventType type)
{
	KzEmbedEvent *event;

	switch (type) {
	case KZ_EMBED_EVENT_KEY:
		event = (KzEmbedEvent *) g_new0(KzEmbedEventKey, 1);
		break;
	case KZ_EMBED_EVENT_MOUSE:
		event = (KzEmbedEvent *) g_new0(KzEmbedEventMouse, 1);
		break;
	default:
		g_warning("invalid event type: %d\n", type);
		return NULL;
	}

	event->type      = type;
	event->link      = NULL;
	event->linktext  = NULL;
	event->img       = NULL;
	event->frame_src = NULL;

	return event;
}


void
kz_embed_event_free (KzEmbedEvent *event)
{
	g_free(event->link);
	event->link = NULL;

	g_free(event->linktext);
	event->linktext = NULL;

	g_free(event->img);
	event->img = NULL;

	if(event->frame_src)
		g_free(event->frame_src);
	event->img = NULL;

	g_free(event);
}
