
#include "thumbnailmanager.h"


ThumbnailList::ThumbnailList(QString file,unsigned int size,unsigned int width)
{
    // ͥꥹ
    // QPtrListǽ
    // ޥ˥ԥˤݲ򤷤ɤ
    filename = file;
    if (width == 0) width = size;
    iconwidth = width;
    iconsize = size;
}

ThumbnailList::~ThumbnailList() {
}


// ǤprivateľԽʡ

QString ThumbnailList::getFilename()
{
    return(filename);
}


unsigned int ThumbnailList::getIconsize()
{
    return(iconsize);
}

unsigned int ThumbnailList::getIconwidth()
{
    return(iconwidth);
}



// ThumbnailManagerΡ


ThumbnailManager::ThumbnailManager()
{
    KGlobal::dirs()->addResourceType("thumbnails","share/thumbnails/");
    file = 0;
    stop = true;
}


ThumbnailManager::~ThumbnailManager()
{
}

void ThumbnailManager::create(int num)
{
    kdDebug() << "CREATE:" <<  files.at(num)->getFilename() <<endl;
    KURL url = KURL(files.at(num)->getFilename());
    unsigned int w = files.at(num)->getIconwidth();
    preview = KIO::filePreview(url,w,w,0,0,true,false);
    
    // ʲΥʥ/åȴϢդϤ˰֤ǤʤФʤʤ
    // 󥹥ȥ饯Ǥϥᡪ
    connect(preview,SIGNAL(gotPreview(const KFileItem*,const QPixmap&)),
    SLOT(save(const KFileItem*,const QPixmap&)));
    connect(preview,SIGNAL(failed(const KFileItem*)),
    SLOT(next()));

}


void ThumbnailManager::save(const KFileItem * item,const QPixmap & pixmap)
{
    // Save Thumbnail.
    kdDebug() << "SAVE" <<endl;
    KURL url = item->url();
    QString thumbpath = getThumbpath(url);
    pixmap.save(thumbpath,"PNG");
    
    
    emit next();
}

void ThumbnailManager::next()
{
    emit changed();
    file ++;
    if (file < files.count()) {
//        delete preview;
        if (!stop) {
            kdDebug() << "Next..." << endl;
            create(file);
        }
    } else {
        kdDebug() << "END..." << endl;
        emit eofl();
    }
        emit changed();

}


int ThumbnailManager::progress()
{
    return ((file * 100) / files.count());
}

QString ThumbnailManager::getThumbpath(KURL url)
{
    QString fileName = url.fileName();
    url.setPath(QDir::cleanDirPath(url.directory()));
    QString sizedir;
    switch(files.at(file)->getIconsize()) {
        case ICON_XXL:
            sizedir = "xxl/";
            break;
        case ICON_LARGE:
            sizedir = "large/";
            break;
        case ICON_MED:
            sizedir = "med/";
            break;
        case ICON_SMALL:
            sizedir = "small/";
            break;
        default:
            sizedir = QString::number(files.at(file)->getIconsize()) + "/";
    }
    KMD5 md5(QFile::encodeName(url.url()));
    QCString hash = md5.hexDigest();
    QString thumbpath = locateLocal("thumbnails",
        QString::fromLatin1( hash.data(), 4 ) + "/" +
        QString::fromLatin1( hash.data()+4, 4 ) + "/" +
        QString::fromLatin1( hash.data()+8 ) + "/" +
        sizedir);
    thumbpath += fileName;
    kdDebug() << "#####" << thumbpath << endl;
    
    return(thumbpath);

}

void ThumbnailManager::remove()
{
    // SLOT
    // ¿ʬޤȤʤ
    for(unsigned int i = 0;i != files.count();i ++) {
        KURL url = KURL(files.at(i)->getFilename());
        QFile f(getThumbpath(url));
        if (f.exists()) f.remove();
    }
    emit eofl();
}

void ThumbnailManager::start()
{
    // ͥϡ
    // ǻ椫Ƴ
    kdDebug() << "FILESCOUNT: " << files.count() << endl;
    if (files.count() == 0) {
        emit eofl();
    } else {
        stop = false;
        emit changed();
        create(file);
    }
}




void ThumbnailManager::addFile(QString filename, unsigned int size, unsigned int width)
{
    // QPtrList<ThumbnailList>ؤΥեɲå᥽åɡ
    files.append(new ThumbnailList(filename,size,width));
}


ThumbnailList * ThumbnailManager::getPrcessingThumbnail()
{
    return(files.at(file));
}


#include "thumbnailmanager.moc"

