<?php
/*
 * $Id: rss10.inc.php,v 1.1.1.1 2005/06/12 15:38:47 youka Exp $
 *
 * このプラグインはhaltさんのrss10コマンドを元に作られています。
 */


class Plugin_rss10 extends Plugin 
{
	public function do_inline($page, $param1, $param2)
	{
		$num = trim($param1) > 0 ? '&amp;recent=' . (int)trim($param1) : '';
		return '<a href="' . SCRIPTURL . '?plugin=rss10' . $num . '"><img src="' . dirname(SCRIPTURL) . '/' . PLUGIN_DIR . 'rss10/rss10.png"></a>';
	}
	
	
	public function do_url()
	{
		$num = isset(Vars::$get['recent']) && Vars::$get['recent'] > 0 ? (int)Vars::$get['recent'] : 15;
		
		$db = DataBase::getinstance();
		$query  = "SELECT pagename,timestamp FROM page";
		$query .= " ORDER BY timestamp DESC, pagename ASC LIMIT $num";
		$result = $db->query($query);
		
		$list = array();
		while($row = $db->fetch($result)){
			$item['timestamp'] = $this->convertDcDate($row['timestamp']);
			$item['pagename'] = $row['pagename'];
			$item['url'] = getURL(Page::getinstance($row['pagename']));
			$list[] = $item;
		}
		
		$smarty = $this->getSmarty();
		$smarty->assign('site_name', SITENAME);
		$smarty->assign('base_url', SCRIPTURL);
		$smarty->assign('list', $list);
		header('Content-Type: application/xml; charset=UTF-8');
		$smarty->display('rss10.tpl.htm');
		exit();
	}
	
	
	/**
	 * timestampをdc:date形式に変換する
	 */
	private function convertDcDate($timestamp)
	{
		return date("Y-m-d\TH:i:s",$timestamp) . '+09:00';
	}
}

?>