/* $Id: conf.c,v 1.3 2005/12/09 16:06:02 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/param.h>

#include "kircd.h"

int
readconf(unsigned char *conf, struct config *cf)
{
	FILE *fp;
	unsigned char buf[BUFSIZ], *p;
	unsigned char *sep = CONFSEP;

	if ((fp = fopen(conf, "r")) == NULL) {
		printf("Could not open configuration file.\n");
		return(-1);
	}

	while(fgets(buf, sizeof(buf), fp) != NULL) {
		if (((p = strtok(buf, sep)) == NULL) || (*p == '#')) continue;
			if (!strncmp(p, "HOST=", 5)) 
				{ strcpy(cf->hostname, p + 5); continue; }
			if (!strncmp(p, "SERVER_PORT=", 12))
				{ strcpy(cf->server_port, p + 12); continue; }
			if (!strncmp(p, "CLIENT_PORT=", 12))
				{ strcpy(cf->client_port, p + 12); continue; }
			if (!strncmp(p, "PASSWORD=", 9))
				{ strcpy(cf->password, p + 9); continue; }
			if (!strncmp(p, "USERNAME=", 9))
				{ strcpy(cf->username, p + 9); continue; }
			if (!strncmp(p, "NICKNAME=", 9))
				{ strcpy(cf->nickname, p + 9); continue; }
			if (!strncmp(p, "MAX_LINE=", 9))
				{ cf->max_line = atoi(p + 9); continue; }
			if (!strncmp(p, "LINE_REVERSE=", 13))
				{ cf->line_reverse = atoi(p + 13); continue; }
			if (!strncmp(p, "COOKIE_EXPIRE=", 14)) 
				{ cf->cookie_expire = atoi(p + 14); continue; }
			if (!strncmp(p, "WEB_USER=", 9))
				{ strcpy(cf->auth_user, p + 9); continue; }
			if (!strncmp(p, "WEB_PASS=", 9))
				{ strcpy(cf->auth_pass, p + 9); continue; }
	}
	fclose(fp);

	return (0);
}
