/* $Id: httpd.c,v 1.11 2005/12/10 13:15:55 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"
#include "httpd.h"

void httpd_proc(struct tparam *, int);
void print_command_page(int);

gpointer
httpd(gpointer param)
{
	struct tparam *th2;
	int s2, s3;

	th2 = (struct tparam *)param;
	s2 = th2->server_socket;

	for (;;) {
		s3 = accept(s2, NULL, NULL);
		if (s3 < 0) {
			printf("error: accepting a socket.\n");
			exit (1);
		}
		usleep(10000);
		httpd_proc(th2, s3);

		close(s3);
	}
}

void httpd_proc(struct tparam *th2, int socket)
{
	time_t timer;
	struct tm *date;
	
	char buf[SBUFLEN];
	char meth_name[64];
	char channel[C_NAME], channel2[C_NAME];
	char uri_addr[64];
	char base64[HTTPBUF];
	char message[HTTPBUF];
	char post_message[HTTPBUF + 256]; /* include url_encode mergin */
	char post_message2[HTTPBUF + 256];
	char web_user[64], web_pass[64];
	char cookie_user[64], cookie_pass[64], date_str[40];
	char *s, *q;
	char cmd_cname[C_NAME], cmd_cmd[20], cmd_topic[IRC_MAX];
	char cmd_buf[IRC_MAX];

	int n = 0;
	int r_fd = 0;
	char http_ver[4];

	int number = 0;
	int update = 0;
	int start_number = 0;
	int post_length = 0;
	int post_ch_number = 0;

	unsigned char *p;

	/* memset zero */
	memset(buf, 0, sizeof(buf));
	memset(meth_name, 0, sizeof(meth_name));
	memset(uri_addr, 0, sizeof(uri_addr));
	memset(base64, 0, sizeof(base64));
	memset(message, 0, sizeof(message));
	memset(channel, 0, sizeof(channel));
	memset(channel2, 0, sizeof(channel2));
	memset(post_message, 0, sizeof(post_message));
	memset(post_message2, 0, sizeof(post_message2));
	memset(th2->postdata, 0, sizeof(th2->postdata));

	memset(cmd_cname, 0, sizeof(cmd_cname));
	memset(cmd_cmd, 0, sizeof(cmd_cmd));
	memset(cmd_topic, 0, sizeof(cmd_topic));
	memset(cmd_buf, 0, sizeof(cmd_buf));

	if (read(socket, buf, SBUFLEN) <= 0 ) {
		printf("error: reading a request.\n");
		return;
	}

	if ((sscanf(buf, "%s %s HTTP/%s\n",
			meth_name, uri_addr, http_ver)) < 3) {
		printf("error: catch strings of request.\n");
	}
#ifdef DEBUG
	printf("HTTP(DEBUG):meth_name= %s\n", meth_name);
	printf("HTTP(DEBUG):uri_addr= %s\n", uri_addr);
	printf("HTTP(DEBUG):http_ver= %s\n", http_ver);
	printf("---------------------------\n");
	printf("BUF(DEBUG):%s\n", buf);

#endif
	/* Cookie Authentication */
	if ((p = strstr(buf, "Cookie:")) != NULL) {
		strcpy(base64, p + 8);
#ifdef DEBUG2
	printf("DEBUG: Cookie get.\n");
#endif

		if (sscanf(base64, "user=%[^;]; pass=%s\n",
		    cookie_user, cookie_pass) == 2);
		else if (sscanf(base64, "pass=%[^;]; user=%s\n",
			 cookie_pass, cookie_user) == 2);
		else
			printf("DEBUG:error\n");
	}
	/* Password Authentication */
	if ((p = strstr(buf, "Authorization: Basic")) != NULL) {
#ifdef DEBUG2
	printf("DEBUG: Passwd get.\n");
#endif
		strcpy(base64, p + 21);
		sscanf(base64_decode(base64),
		       "%[^:]:%s\n", web_user, web_pass);
	}

	if ((strcmp(cookie_user, th2->auth_user) == 0) &&
	    (strcmp(cookie_pass, th2->auth_pass) == 0)) {
		/* send header HTTP/1.1 200 OK */
		send_msg(socket, http_header0);
#ifdef DEBUG2
	printf("DEBUG: Cookie Authentication done.\n");
#endif
	} else if ((strcmp(web_user, th2->auth_user) == 0) &&
		   (strcmp(web_pass, th2->auth_pass) == 0)) {
		/* send header HTTP/1.1 200 OK */
		send_msg(socket, http_header0);
#ifdef DEBUG2
	printf("DEBUG: Passwd Authentication done.\n");
#endif
		/* send cookie info */
		timer = time(NULL) + th2->cookie_expire * 24 * 60 * 60;
		date = gmtime(&timer);
		strftime(date_str, 255, "%a, %d-%b-%Y %H:%M:%S GMT;\n", date);
		/* user */
		sprintf(message, "Set-Cookie: user=%s; expires=", web_user);
		strcat(message, date_str);
		send_msg(socket, message);
		/* pass */
		sprintf(message, "Set-Cookie: pass=%s; expires=",web_pass);
		strcat(message, date_str);
                send_msg(socket, message);
	} else {
		/* cannot auth */
		send_msg(socket, http_auth_401_header);
		return;
	}

	/* check and clear auth info */
	memset(web_user, 0, sizeof(web_user));
	memset(web_pass, 0, sizeof(web_pass));
	memset(cookie_user, 0, sizeof(cookie_user));
	memset(cookie_pass, 0, sizeof(cookie_pass));

	/* POST session */
	if ((strcmp(meth_name, "POST")) == 0) {
#ifdef DEBUG
		printf("status: POST Session\n");
#endif
		/* wait for flags clear */
		while ((!th2->t_empty) || (th2->t_lock)) {
			usleep(10000); /* 100ms */
		}
		th2->t_lock = 1;	/* now writing */

		/* Get length of post data */
		if ((s = strstr(buf, "Content-Length: ")))
			post_length = atoi(s + 16);

		/* Get post message */
		if ((s = strstr(buf, "m="))) {
			sprintf(post_message, "%.*s",
				post_length - 2, s + 2);

			/* URL decord */
#ifdef DEBUG
			printf("decode: %s\n", post_message);
#endif
			if (url_decode_jis(post_message2, post_message))
				goto index_start;

			/* Get channel number to post */
			sscanf(uri_addr + 1, "channel%d",
				&post_ch_number);

			/* channel decode (%hoge -> #hoge:*.jp) */
			channel_decode(channel2,
					th2->name[post_ch_number]);

			/* transfer message to data buffer */
			sprintf(th2->postdata,
				":%s PRIVMSG %s :%s\r\n",
				 th2->real_nickname, channel2,
				 post_message2);

			/* clear trans. empty flag */
			th2->t_empty = 0;
			th2->t_lock = 0;

		} else if ((s = strstr(buf, "cname="))) {
			/* clear buffer */
			memset(cmd_cname, 0, sizeof(cmd_cname));        
			memset(cmd_cmd, 0, sizeof(cmd_cmd));    
			memset(cmd_topic, 0, sizeof(cmd_topic));

			sprintf(post_message,
				"%.*s", post_length, s);

			q = strtok(post_message, "&");
				if (q != NULL) strcpy(cmd_cname, q + 6);
			if (strstr(buf, "cmd=")) {
				q = strtok(NULL, "&");
				if (q != NULL) {
					strcpy(cmd_cmd, q + 4);
				}
			}
			q = strtok(NULL, "&");
			if (q != NULL) {
				strcpy(cmd_buf, q + 5);
			}

			/* make command message */
			if (strcmp(cmd_cmd, "join") == 0) {
				url_decode_rawdata(channel, cmd_cname);
				channel_decode(channel2, channel);
				sprintf(post_message, ":%s JOIN %s\r\n",
					th2->real_nickname,
					channel2);
			} else if (strcmp(cmd_cmd, "part") == 0) {
				url_decode_rawdata(channel, cmd_cname);
				channel_decode(channel2, channel);
				sprintf(post_message, ":%s PART %s\r\n",
					th2->real_nickname,
					channel2);
			} else if (strcmp(cmd_cmd, "topic") == 0) {
				url_decode_rawdata(channel, cmd_cname);
				channel_decode(channel2, channel);
				url_decode_jis(cmd_topic, cmd_buf);
				sprintf(post_message, ":%s TOPIC %s :%s\r\n",
					th2->real_nickname,
					channel2, cmd_topic);
			} else if (strcmp(cmd_cmd, "list") == 0) {
				if (strlen(cmd_cname) > 0) {
				    url_decode_rawdata(channel, cmd_cname);
				    channel_decode(channel2, channel);
				    sprintf(post_message, "NAMES %s\r\n",
					    channel2); 
				}
			} else {
				goto command_start;
			}

			/* transfer message */
			strcpy(th2->postdata, post_message);
		}

		/* clear trans lock and empty flag */
		th2->t_empty = 0;
		th2->t_lock = 0;
	}	/* POST */

	/* favicon.ico */
	if (strstr(uri_addr + 1, "favicon.ico")) {
#ifdef DEBUG
		printf("favicon session\n");
#endif
		if ((r_fd = open(uri_addr, O_RDONLY,
				 0666)) == -1) {
			printf("favicon.ico file not found\n");
		} else if (strcmp(http_ver,"1.0") == 0) {
			send_msg(socket, ico_header10);
			while((n = read(r_fd, buf, HTTPBUF)) > 0) {
			   if (write(socket, buf, n) != n) {
			   	printf("error: writing a file\n");
				break;
			   }
			} /* while */
		} else if (strcmp(http_ver,"1.1") == 0) {
			printf("ver 1.1\n");

		}

		close(r_fd);
		send_msg(socket, http_footer);
		return;
	} /* favicon.ico */

	/* start COMMAND page */
command_start:
	if ((strcmp(uri_addr + 1, "cmd")) == 0) {
#ifdef DEBUG
		printf("COMMAND page\n");
#endif
		/* send header */
		send_msg(socket, http_header1);
		send_msg(socket, http_header2);

		print_command_page(socket);

		send_msg(socket, http_footer);

		return;
	}

index_start:
	/* start index of each channels */
	if ((sscanf(uri_addr + 1, "channel%d", &number)) == 1) {
#ifdef DEBUG
		printf("Sub index session\n");
#endif
		/* send header */
		send_msg(socket, http_header1);
		send_msg(socket, http_header2);

		/* check update or not */
		if (number >= 50) {
			update = 1;
			number -= 50;
		}

		/* print TOPIC */
		if (strlen(th2->topic[number]) > 0) {
			sprintf(message, "$B$H$T$/(B :%s<br>",
				th2->topic[number]);
			send_msg(socket, message);
		}

		/* print NAMES */
		if (strlen(th2->member_names[number]) > 0) {
			sprintf(message, "users:%s<br>",
				th2->member_names[number]);
			send_msg(socket, message);
		}

		/* print FORM */
		sprintf(message,
			"<form action=\"/channel%d\" method=\"post\">",
			number);
		send_msg(socket, message);
		send_msg(socket,
			 "<input type=text name=\"m\" size=\"10\">");
		send_msg(socket,
			 "<input type=submit value=\" $BAw?.(B \"></form>");
		send_msg(socket,
			"<a accesskey=\"8\" href=\"../\">back[8]</a><hr>");

		if (update)
			start_number = th2->read_count[number];
		else
			start_number = 0;

		if (th2->line_reverse) {
			for (n = start_number;
			     n < th2->history_count[number]; n++) {
				sprintf(message, "%s",
					th2->data[number][n]);
				send_msg(socket, message);
			}
		} else {
			for (n = th2->history_count[number] - 1;
			     n >= start_number; n--) {
				sprintf(message, "%s",
					th2->data[number][n]);
				send_msg(socket, message);
			}
		}
		th2->read_count[number] = th2->history_count[number];
		send_msg(socket, http_footer);

		update = 0;

		return;
	}

	/* start main index */
	/* send header */
	send_msg(socket, http_header1);
	send_msg(socket, http_header2);

	for (n = 0; n <= th2->ch_count; n++) {
	    if (n < 9) {
	       sprintf(message,
		   "%d <a accesskey=\"%d\" href=\"channel%d\">%s</a> \
		    <a href=\"channel%d\">(%d)</a><br>",
		    n, n, n, th2->name[n],
		    n + 50, th2->history_count[n] -
		    th2->read_count[n]);
	    } else {
	sprintf(message,
		   "* <a href=\"channel%d\">%s</a> \
		    <a href=\"channel%d\">(%d)</a><br>",
		    n, th2->name[n],
		    n + 50, th2->history_count[n] -
		    th2->read_count[n]); 	
	    }
		send_msg(socket, message);
	}
	sprintf(message,
		"<hr>9 <a accesskey=9 href=\"cmd\"> \
			command page[9]</a><br>");
	send_msg(socket, message);
	sprintf(message,
		"<br><left>kircd Ver %s </left>", VERSION);
	send_msg(socket, message);
	send_msg(socket, http_footer);

	return;
}


int send_msg(int fd, char *msg)
{
	int n;
	n = strlen(msg);

	if (write(fd, msg, n) != n){
		printf("error: writing.");
	}

	return n;
}

void print_command_page(int socket)
{
	send_msg(socket,
	   "<form action=\"/cmd\" method=\"post\">");
	send_msg(socket,
	   "<input type=\"submit\" \
		accesskey=\"1\" value=\"OK[1]\">");
	send_msg(socket,
	   "<a accesskey=\"8\" href=\"../\"> back[8]</a><hr>");
	send_msg(socket,
	   "channel <input type=text name=\"cname\" size=\"10\">");
	send_msg(socket,
	   "<br><input type=radio name=\"cmd\" value=\"join\">JOIN");
	send_msg(socket,
	   "<br><input type=radio name=\"cmd\" value=\"part\">PART");
	send_msg(socket,
	   "<br><input type=radio name=\"cmd\" value=\"list\">USER update");
	send_msg(socket,
	   "<br><input type=radio name=\"cmd\" value=\"topic\">TOPIC");
	send_msg(socket,
	   "<input type=text name=\"toto\" size=\"7\"></form>");
}
