/* $Id: kircd.h,v 1.8 2005/12/10 13:09:55 ichiro Exp $ */
#define DEBUG
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib/gthread.h>


#define CLIENT 0
#define SERVER 1

#define SBUFLEN 4096
#define LBUFLEN 4096
#define HTTPBUF 4096

#define CONFSEP ";\n"

/* channel */
#define CH_MAX 20

/* max cache line */
#define C_HISTORY_NUM 31

#define C_NAME 40

/* rfc1459, max length of IRC message is 512 byte */
#define IRC_MAX 515

struct tparam {
	int socket_number;
	int server_socket;

	char real_nickname[40];

	/* recieve buffer */
	int s_read;
	int s_count;
	int s_empty;	/* recieve buffer empty */
	char *s_buff;
	char *l_buff;
	int s_lock;

	int max_line;
	int line_reverse;
	int cookie_expire;
	char name[CH_MAX][C_NAME];
	int  ch_count;
	char data[CH_MAX][C_HISTORY_NUM][IRC_MAX];
	int  history_count[CH_MAX];
	int  read_count[CH_MAX];
	char topic[CH_MAX][IRC_MAX];
	char member_names[CH_MAX][IRC_MAX];

	/* transfer buffer */
	int  t_empty;	/* trans buffer empty */
	int  t_lock;	/* trans buffer writing */
	char postdata[IRC_MAX];

	/* auth (copy) */
	char auth_user[40];
	char auth_pass[40];
};
struct config {
	char hostname[128];
	char server_port[40];
	char client_port[40];
	char password[40];
	char username[40];
	char nickname[40];

	/* auth */
	char auth_user[40];
	char auth_pass[40];
	int max_line;
	int line_reverse;
	int cookie_expire;
};

int main(int ac, char *av[]);
int get_addr(struct addrinfo, const char*, const char*, int);
void init(int, struct config *);
gpointer watch(gpointer);
gpointer lineget(gpointer);
extern gpointer httpd(gpointer);

extern int send_msg(int, char *);
extern int readconf(unsigned char *, struct config *);
extern int keitai_start(struct tparam *);
extern int priv_recv(struct tparam *);
extern int topic_recv(struct tparam *, char *, char *, char *);
extern int part_recv(struct tparam *, char *);
extern int join_recv(struct tparam *, char *);
extern int names_recv(struct tparam *, char *, char *);

extern int url_decode_jis(char *, char *);
extern int url_decode_rawdata(char *, char *);
extern int sjis2jis(char *, char *);
extern int euc2jis(char *, char *);
extern int channel_encode(char *, char *);
extern int channel_decode(char *, char *);
extern int ltgt_encode(char *, char *);
extern char * base64_decode(char *);
extern char * href_conv(char *);
