/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include <kapplication.h>
#include <dcopclient.h>
#include <qdatastream.h>
#include <qstring.h>

int main( int argc, char **argv )
{
    KApplication app( argc, argv, "kita_client", false );

    // get our DCOP client and attach so that we may use it
    DCOPClient *client = app.dcopClient();
    client->attach();

    // do a 'send' for now
    QByteArray data;
    QDataStream ds( data, IO_WriteOnly );
    if ( argc > 1 )
        ds << QString( argv[ 1 ] );
    else
        ds << QString( "http://www.kde.org" );
    client->send( "kita", "KitaIface", "openURL(QString)", data );

    return app.exec();
}
