/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITAPREF_H_
#define _KITAPREF_H_

#include <kdialogbase.h>
#include <qframe.h>

#include "asciiartprefbase.h"
#include "uiprefbase.h"
#include "debugprefbase.h"
#include "faceprefbase.h"

#include "libkita/favoritethreads.h"
#include "libkita/threadinfo.h"
#include "libkita/favoriteboards.h"

class DebugPrefPage;

namespace Kita
{
    class AsciiArtPrefPage;
    class UIPrefPage;
    class AbonePrefPage;
    class LoginPrefPage;
    class FacePrefPage;
    class WritePrefPage;
}

class KitaPreferences : public KDialogBase
{
    Q_OBJECT

public:
    KitaPreferences();

protected:
    virtual void slotApply();

private:
    Kita::FacePrefPage* m_facePage;
    Kita::AsciiArtPrefPage* m_asciiArtPage;
    Kita::UIPrefPage* m_uiPage;
    Kita::AbonePrefPage* m_abonePage;
    Kita::LoginPrefPage* m_loginPage;
    Kita::WritePrefPage* m_writePage;
    //    DebugPrefPage* m_debugPage;

private slots:
    void slotChanged();
    virtual void slotOk();
    virtual void slotDefault();
    void slotAboutToShowPage( QWidget* page );

signals:
    void fontChanged( const QFont& );
};

class DebugPrefPage : public DebugPrefBase
{
    Q_OBJECT

public:
    DebugPrefPage( QWidget* parent = 0 );

public slots:
    void replace();
};

namespace Kita
{
    class AsciiArtPrefPage : public AsciiArtPrefBase
    {
        Q_OBJECT
    public:
        AsciiArtPrefPage( QWidget* parent = 0 );
    public slots:
        void init();
        void apply();
        void reset();

    signals:
        void changed();
    };

    class UIPrefPage : public UIPrefBase
    {
        Q_OBJECT
    public:
        UIPrefPage( QWidget* parent = 0 );
        void apply();
        void reset();

    private slots:
        /// open 'file association setting dialog'
        void slotEditFileAssociation();

    signals:
        void changed();
    };

    class FacePrefPage : public FacePrefBase
    {
        Q_OBJECT

        bool m_threadFontchanged;
        bool m_threadColorChanged;

    public:
        FacePrefPage( QWidget* parent = 0 );
        void apply();
        void reset();

    public slots:
        void slotFontButtonClicked();
        void slotPopupFontButtonClicked();
        void slotThreadFontButtonClicked();
        void slotColorChanged();

    private:
        void updateButtons();

    signals:
        void fontChanged( const QFont& );
        void setFontOfHTMLPart();
        void changed();
        void setStyleSheetOfHTMLPart();
    };
}

#endif // _KITAPREF_H_
