/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAHTMLPART_H
#define KITAHTMLPART_H

#include <khtml_part.h>
#include <qframe.h>
#include <qevent.h>

/* mode */
enum {
    /* This part is not initialized. This part works as just KHTMLPart */
    HTMLPART_MODE_KHTML,

    /* on main window */
    HTMLPART_MODE_MAINPART,

    /* on Kita Navi   */
    HTMLPART_MODE_NAVI,

    /* on popup       */
    HTMLPART_MODE_POPUP
};

/* ID of user defined event */
#define EVENT_GotoAnchor ( QEvent::User + 100 )

class KitaDomTree;
class KitaImgView;
class KURL;

namespace Kita
{
    class ResPopup;
}

namespace DOM
{
    class Node;
}


/*-------------------------------------------------------------*/

class KitaHTMLPart : public KHTMLPart
{
    Q_OBJECT

    KitaDomTree* m_domtree;
    Kita::ResPopup* m_popup;

    /* basic information */
    int m_mode;
    KURL m_datURL;
    bool m_updatedKokoyon;


    /* cache */
    bool m_firstReceive;
    int m_centerNum;

    /* goto anchor */
    QStringList m_anchorStack;
    int m_jumpNumAfterLoading; /* see also slotFinishLoad() */

    /* mouse event */
    bool m_pushctrl;
    bool m_pushmidbt;
    bool m_pushrightbt;

    /* search */
    DOM::Node m_findNode;
    int m_findPos;
    int m_find_y;

    /* res popup */
    bool m_multiPopup;
    bool m_kitaIsActive;


public:

    KitaHTMLPart( QWidget* parent, const char* name = 0 );
    ~KitaHTMLPart();
    bool setup( int mode , const KURL& url );
    const int getMode() const;

    /* rendering */
    void showResponses( int startnum, int endnum );
    void parseResponses( int startnum, int endnum );
    void showAll();
    void insertBeltNode( const QString& idstr );
    void insertHeaderNode( const QString& str );
    void insertFooterNode( const QString& str );
    void updateScreen( bool showHeaderEtc, bool clock );
    void setInnerHTML( const QString& innerHTML );

    /* cache */
    bool load( int centerNum );
    bool reload( int jumpNum );

    /* goto anchor */
    bool gotoAnchor( const QString& anc, bool pushPosition );

    /* search */
    bool findText( const QString &query, bool reverse );

    /* popup */
    bool isPopupVisible();

public slots:

    /* rendering */
    void slotRedrawHTMLPart( const KURL& datURL, bool force );
    void slotRedrawAllHTMLPart( bool force );
    void slotSetFontOfHTMLPart();
    void slotSetStyleSheetOfHTMLPart();

    /* cache */
    void slotReceiveData();
    void slotFinishLoad();

    /* goto anchor */
    void slotGotoKokoyon();
    void slotGobackAnchor();

    /* Tugi100, Mae100 etc.  */
    void slotClickTugi100();
    void slotClickNokori();
    void slotClickGotoFooter();
    void slotClickMae100();
    void slotClickMaeZenbu();
    void slotClickTmpNext100();
    void slotClickShowAll();

    /* res popup */
    void slotDeletePopup();
    void slotShowResPopup( QPoint point, int refNum, int refNum2 );

private:

    void clearPart();

    /* setup */
    void connectSignals();
    void createHTMLDocument();

    /* goto anchor */
    void pushCurrentPosition();
    QString getCurrentIDofNode();

    /* popup menu */
    void showPopupMenu( const KURL& kurl );

    /* click */
    void clickAnchor( const KURL& urlin );
    void showWritePopupMenu( const QString& refstr );
    void showIDPopup( const QString& refstr );
    void showBePopupMenu( const QString& refstr );
    bool showNext100Etc( const QString& refstr );

    /* search */
    void findTextInit();

    /* res popup */
    void showPopup( const KURL& url, const QString& innerHTML );
    void showPopupCore( const KURL& url, const QString& innerHTML, QPoint point );
    bool startMultiPopup();
    bool isMultiPopupMode();
    void hidePopup();
    bool isUnderMouse( int mrgwd, int mrght );
    bool showSelectedDigitPopup();

protected:

    /* user event */
    virtual void customEvent( QCustomEvent * e );

    /* mouse event */
    virtual void khtmlMousePressEvent( khtml::MousePressEvent* e );


private slots:

    /* click */
    void slotOpenURLRequest( const KURL&, const KParts::URLArgs& );

    /* res popup */
    void slotLeave();
    void slotVSliderReleased();
    void slotHSliderReleased();
    void slotHideChildPopup();
    void slotKitaIsActive();
    void slotOnURL( const QString& url );


signals:

    void openWriteDialog( QString );
    void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                            QString mimetype = QString::null,
                            int usr1 = 0,
                            const KURL& usrUrl1 = KURL() );
    void redrawHTMLPart( const KURL& url, bool force );
    void mousePressed(); /* to KitaThreadView */

    /* cache */
    void receiveData();
    void finishReload();

    /* res popup */
    void hideChildPopup();
    void isKitaActive();

    /* kita navi */
    void showKitaNavi( const KURL& , int , int );
    void showKitaNaviByID( const KURL& , QString );
    void showKitaNaviByWord( const KURL& , QString );
    void showKitaNaviByName( const KURL& , QString );
    void showKitaNaviResTree( const KURL&, int );
    void showKitaNaviRevResTree( const KURL&, int );

    /* write dock */
    void activateThreadView( const KURL& );
    void closeWriteTab( const KURL& );

    /* image viewr */
    void redrawImage( const KURL& );

    /* subject tab */
    void updateSubjectTab( const KURL& );
};



/*---------------------------------------------------*/
/*---------------------------------------------------*/
/*---------------------------------------------------*/


namespace Kita
{
    class ResPopup : public QFrame
    {
        Q_OBJECT

        KitaHTMLPart* m_htmlPart;
        KitaImgView* m_imgview;
        KURL m_url;


    public:
        ResPopup( KHTMLView* view, const KURL& datURL );
        ~ResPopup();
        void setText( const QString& str );
        void adjustSize();
        void adjustPos( QPoint pos );
        void moveMouseAbove();

    private:
        void showImage( const KURL& url );

    private slots:
        void slotReceiveImgData( const KURL& url, unsigned int size, unsigned int total );
        void slotFinishImgLoad( const KURL& url );

    signals:
        void hideChildPopup();
    };
}


/* user defined events */

class GotoAnchorEvent : public QCustomEvent
{
    QString m_anc;

public:

    GotoAnchorEvent( const QString& anc )
            : QCustomEvent( EVENT_GotoAnchor ), m_anc( anc ) {};

    const QString& getAnc() const { return m_anc; }
};


#endif
