/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitasubjecttabwidget.h"

KitaSubjectTabWidget::KitaSubjectTabWidget(QWidget *parent, const char *name, WFlags f)
 : QTabWidget(parent, name, f)
{
  KitaSubjectView* view = new KitaSubjectView( this );
  addTab( view, "        " );
  m_latestView = view;

  m_favoriteList = new FavoriteListView( this, "favoriteTab" );
  addTab( m_favoriteList, "Favorite" );

  connectSignals( m_favoriteList );
  connectSignals( view );

  connect( this, SIGNAL( currentChanged( QWidget* ) ),
                 SLOT( slotCurrentChanged( QWidget* ) ) );
}

KitaSubjectTabWidget::~KitaSubjectTabWidget()
{
}

void KitaSubjectTabWidget::loadBoard( const Kita::Board* board )
{
  m_latestView->loadBoard( board );
  setTabLabel( m_latestView, board->name() );
}

void KitaSubjectTabWidget::updateThread( const Kita::Thread& thread )
{
  for( int i=0; i<count(); i++ ) {
    QWidget* widget = page( i );
    // TODO: classȽꤷ褦
    if( QString::compare( widget->name(), "favoriteTab" ) == 0 ) {
      static_cast<FavoriteListView*>( widget )->updateThread( thread );
    } else {
      static_cast<KitaSubjectView*>( widget )->updateThread( thread );
    }
  }
}

void KitaSubjectTabWidget::connectSignals( FavoriteListView* view )
{
  connect( view, SIGNAL( signalShowThread( const Kita::Thread& ) ),
           this, SIGNAL( signalShowThread( const Kita::Thread& ) ) );
  connect( view, SIGNAL( signalShowThreadWithNewTab( const Kita::Thread& ) ),
           this, SIGNAL( signalShowThreadWithNewTab( const Kita::Thread& ) ) );
//  connect( view, SIGNAL( loadBoardCompleted( const KURL& ) ),
//           this, SIGNAL( loadBoardCompleted( const KURL& ) ) );
}

void KitaSubjectTabWidget::connectSignals( KitaSubjectView* view )
{
  connect( view, SIGNAL( signalShowThread( const Kita::Thread& ) ),
           this, SIGNAL( signalShowThread( const Kita::Thread& ) ) );
  connect( view, SIGNAL( signalShowThreadWithNewTab( const Kita::Thread& ) ),
           this, SIGNAL( signalShowThreadWithNewTab( const Kita::Thread& ) ) );
  connect( view, SIGNAL( loadBoardCompleted( const KURL& ) ),
           this, SIGNAL( loadBoardCompleted( const KURL& ) ) );
}

void KitaSubjectTabWidget::slotCurrentChanged(QWidget* widget)
{
  if( QString::compare(widget->name(), "favoriteTab") == 0 ) {
    m_favoriteList->update();
  } else {
    m_latestView = static_cast<KitaSubjectView*>( widget );
  }
}
