/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "board.h"

#include <config.h>

#include <kio/slaveconfig.h>
#include <kio/netaccess.h>
#include <kdebug.h>

#include <kfilterdev.h>

#include <qregexp.h>
#include <qdict.h>

#include "kita_misc.h"
#include "threadinfo.h"

#include "qcp932codec.h"

using namespace Kita;

QDict<Board>* Board::m_boardDict = 0;

Board::Board()
{
}

Board::Board(const QString& boardURL, const QString boardName) : m_boardURL(boardURL), m_boardName(boardName)
{
}

Board::~Board()
{
}

const KURL Board::subjectTxtURL() const
{
  if( m_boardURL.isEmpty() ) {
    return KURL();
  } else {
    return KURL(m_boardURL, "./subject.txt");
  }
}

const QString& Board::url() const
{
  return m_boardURL;
}

const QString& Board::name() const
{
  return m_boardName;
}

const QString Board::id() const
{
  return KURL( m_boardURL ).fileName();
}

const QPtrList<Thread> Board::getThreadList() const
{
  if( m_boardURL.isEmpty() ) {
    kdWarning() << "Waring: board url is empty!" << endl;
    return QPtrList<Thread>();
  }
  QPtrList<Thread> threadList;

  KIO::SlaveConfig::self()->setConfigData("http",
    KURL( m_boardURL ).host() ,
    "UserAgent",
    QString( "Monazilla/1.00 (Kita/%1)" ).arg( VERSION ) );
  QString tmpFile;
  if(KIO::NetAccess::download(subjectTxtURL(), tmpFile)) {
    QIODevice* tmpDevice = KFilterDev::deviceForFile(tmpFile, "application/x-gzip");
    tmpDevice->open(IO_ReadOnly);

    QCp932Codec cp932Codec;
    QTextStream stream(tmpDevice);
    stream.setCodec(&cp932Codec);

    // parse subject.txt(only one format...)
    QRegExp regexp("(\\d+\\.dat)<>(.*)\\((\\d+)\\)");
    QString line;

    while((line = stream.readLine()) != QString::null) {
      int pos = regexp.search(line);
      if(pos != -1) {
        QString fname = regexp.cap(1);
        QString subject = regexp.cap(2);
        QString num = regexp.cap(3);

        KURL datURL = m_boardURL;
        datURL.addPath("/dat/" + fname);
        Kita::Board::setName( datToBoard( datURL.url() ), name() );
        Kita::Thread* thread = new Kita::Thread( datURL.url(), subject );
        KitaThreadInfo::setResNum( datURL.url(), num.toInt() );
        threadList.append(thread);
      }
    }

    KIO::NetAccess::removeTempFile(tmpFile);
  }
  return threadList;
}

const QString Board::toXmlFragment() const
{
  QString ret;

  // FIXME: Thread饹إԡ
  ret += "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n";
  ret += QString("<url>%1</url>\n").arg( m_boardURL );
  ret += QString("<name>%1</name>\n").arg( m_boardName );
  ret += "</board>\n";

  return ret;
}

Board* Board::getByURL( const QString& boardURL )
{
    // FIXME: null֥Ȥ׵ΤӤ˺äƤ롣
    if ( boardURL.isNull() ) {
        return new NullBoard();
    }

    if ( m_boardDict == 0 ) {
        // FIXME: setAutoDeleteäưȤΤ뤳
        m_boardDict = new QDict<Board>();
    }

    if( m_boardDict->find( boardURL ) ) {
        return m_boardDict->find( boardURL );
    }

    Board* newBoard = new Board( boardURL );
    m_boardDict->insert( boardURL, newBoard );

    return newBoard;
}

void Board::setName( const QString& boardURL, const QString& boardName )
{
    if ( boardURL.isNull() ) {
        return;
    }

    if ( m_boardDict == 0 ) {
        // FIXME: setAutoDeleteäưȤΤ뤳
        m_boardDict = new QDict<Board>();
    }

    Board* newBoard = new Board( boardURL, boardName );
    m_boardDict->replace( boardURL, newBoard );

    return;
}

NullBoard::NullBoard()
{
}

NullBoard::~ NullBoard()
{
}

bool BoardXmlParser::startElement( const QString&, const QString& localName, const QString&, const QXmlAttributes& )
{
  if( m_inBoard == true ) {
    if( localName == "url" ) {
    } else if( localName == "name" ) {
    } else {
      // error
      return false;
    }
  } else {
    if( localName == "board" ) {
      m_inBoard = true;
    } else {
      // error
      return false;
    }
  }
  return true;
}

bool BoardXmlParser::endElement( const QString&, const QString& localName, const QString& )
{
  if( localName == "board" ) {
    m_inBoard = false;
    Kita::Board::setName( m_urlStr, m_nameStr );
    m_board = Kita::Board::getByURL( m_urlStr );
    m_isValid = true;
    // create board;
  } else if( localName == "url" ) {
    m_urlStr = m_characters;
  } else if( localName == "name" ) {
    m_nameStr = m_characters;
  } else {
    // error
    return false;
  }
  return true;
}

bool BoardXmlParser::characters( const QString& ch )
{
  m_characters = ch;
  return true;
}
