# Merlot class definition (python)

KNH_PACKAGE = {
  'author': 'Kimio Kuramitsu',
}

KNH_NAMESPACE = "knh"
KNH_PACKAGE_DEP = ''

KNH_FLAGS = [
    ('Nue', [
        ['NUE', 'GCHook', '1',  'knh_Object_head(%s)->flag', 'is:set:*:*'],
        ['NUE', 'ObjectText', '2',  'knh_Object_head(%s)->flag', 'is:set:*:*'],
    ]),
    ('String', [
        ['STRING', 'STEXT', '1',  'knh_Object_head(%s)->flag', 'is:set:*:*'],
    ]),
    ('Object', [
        ['OF', 'Release!Debug',     'knh_flag_of_t',  'knh_Object_head(%s)->flag', 'is:*:is:*'],
        ['OF', 'Immutable', 'knh_flag_of_t',  'knh_Object_head(%s)->flag', 'is:*:is:*'],
        ['OF', 'MetaData',  'knh_flag_of_t',  'knh_Object_head(%s)->flag', 'has:set:has:*'],
        ['OF', 'Synchronized', 'knh_flag_of_t', 'knh_Object_head(%s)->flag', 'is:*:is:*'],
        ['OF', 'Modified',  'knh_flag_of_t',  'knh_Object_head(%s)->flag', 'is:set:is:set'],
#        ['OF', 'NullObject', 'knh_flag_of_t', 'knh_Object_head(%s)->flag', 'is:*:is:*'],
        ['OF', 'Local4', 'knh_flag_of_t', 'knh_Object_head(%s)->flag', 'is:set:*:*'],
        ['OF', 'Local3', 'knh_flag_of_t', 'knh_Object_head(%s)->flag', 'is:set:*:*'],
        ['OF', 'Local2', 'knh_flag_of_t', 'knh_Object_head(%s)->flag', 'is:set:*:*'],
        ['OF', 'Local1', 'knh_flag_of_t', 'knh_Object_head(%s)->flag', 'is:set:*:*'],
    ]),
    
    ('Class', [
        ['CF', 'Release!Debug', 'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
        ['CF', 'Immutable', 'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
        ['CF', 'MetaExtensible', 'knh_flag_cf_t',  'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
#        ['CF', 'Syncronized', 'knh_flag_cf_t', 'knh_tclass_cflag(knh_Class_cid(%s)', 'is:*:is:*'],
        ['CF', 'Private!Public',  'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
        ['CF', 'Final',  'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
        ['CF', 'Strict', 'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:*:*'],
        ['CF', 'System',  'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
        ['CF', 'NullObject', 'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:*:*'],
        ['CF', 'NA',  'knh_flag_cf_t', 'knh_tclass_table(knh_Class_cid(%s))->cflag', 'is:*:is:*'],
    ]),
    
    ('ClassStruct', [
        ['CFF', 'Hidden',    'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
        ['CFF', 'AutoName',  'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
        ['CFF', 'SafeValue', 'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
        ['CFF', 'Protected', 'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
        ['CFF', 'Getter',    'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
        ['CFF', 'Setter',    'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
        ['CFF', 'Key',       'knh_flag_cff_t', '((ClassStruct)%s)->fields[n].flag', 'is:set:*:*'],
    ]),
    
    ('Method', [
        ['MF', 'Public!Private', 'knh_flag_mf_t', '((Method*)%s)->flag', 'is:set:is:*'],
        ['MF', 'Virtual!Final',  'knh_flag_mf_t', '((Method*)%s)->flag', 'is:set:is:*'],
        ['MF', 'Static', 'knh_flag_mf_t', '((Method*)%s)->flag', 'is:*:is:*'],
        ['MF', 'VarArgs',  'knh_flag_mf_t', '((Method*)%s)->mf->flag', 'is:set:is:*'],
        ['MF', 'Aspect',  'knh_flag_mf_t', '((Method*)%s)->mf->flag', 'is:set:is:*'],
        ['MF', 'ObjectCode',  'knh_flag_mf_t', '((Method*)%s)->flag', 'is:set:*:*'],
        ['MF', 'Generated',  'knh_flag_mf_t', '((Method*)%s)->mf->flag', 'is:set:*:*'],
    ]),
#    'MAPF DB HighPriority Synonym LossLess Total Static Temporal Interface Derived',
    ('MapMap', [
        ['MMF', 'Interface', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'VerySignificant', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', '*:*:*:*'],
        ['MMF', 'Significant', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'Synonym', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'LossLess', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'Total!Partial', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'Static!Temporal', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'Local', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
        ['MMF', 'Derived', 'knh_flag_mmf_t', '((MapMap*)%s)->flag', 'is:set:is:*'],
    ]),
    
    # 'EF   Fatal Logging Static Generated',
    ('Exception', [
        ['EF', 'Fatal', 'knh_flag_ef_t', '((Exception*)%s)->flag', 'is:*:is:*'],
        ['EF', 'Logging', 'knh_flag_ef_t', '((Exception*)%s)->flag', 'is:*:is:*'],
        ['EF', 'Generated', 'knh_flag_ef_t', '((Exception*)%s)->flag', 'is:*:is:*'],
        ['EF', 'Caught', 'knh_flag_ef_t', '((Exception*)%s)->flag', 'is:set:*:*'],
    ]),

    ('ExceptionHandler', [
        ['EHF', 'Catching', '1', 'knh_Object_head(%s)->flag', 'is:set:*:*'],
    ]),

    ('IntUnit', [
        ['UF', 'Unsigned', 'knh_flag_uf_t', '((IntUnit*)%s)->spec.flag', 'is:*:is:*'],
    ]),
    
]

KNH_CLASSES = [
  ['Object', 'Object', None, None, 0],
  ['Tuple1', 'Object', None, None, 1],
  ['Tuple2', 'Object', None, None, 2],
  ['Tuple3', 'Object', None, None, 3],
  ['Tuple4', 'Object', None, None, 4],
  ['Tuple5', 'Object', None, None, 5],
  ['Tuple6', 'Object', None, None, 6],
  ['Tuple7', 'Object', None, None, 7],
  ['Tuple8', 'Object', None, None, 8],
  ['Tuple9', 'Object', None, None, 9],
  ['Tuple10', 'Object', None, None, 10],
  ['Tuple11', 'Object', None, None, 11],
  ['Tuple12', 'Object', None, None, 12],
  ['Tuple13', 'Object', None, None, 13],
  ['Tuple14', 'Object', None, None, 14],
  ['Tuple15', 'Object', None, None, 15],

  ['Prototype', 'Object', None, None, [
    ['Object*',  'value[KNH_PROTOTYPE_FIELDSIZE]'],
    ['Object*', 'ns'],
  ]],

  ['Nue', 'Object', None, None, [
    ['void*', 'msg'],
  ]],
#num.h
  ['Bool', 'Object', None, None, [
    ['knh_bool_t', 'value'],
  ]],
  ['Int', 'Object', None, None, [
    ['knh_int_t', 'value', '@cast'],
  ]],
  ['Float', 'Object', None, None, [
    ['knh_float_t', 'value', '@cast'],
  ]],
  ['Long', 'Object', None, None, [
    ['knh_int64_t', 'value', '@cast'],
  ]],

# string.h
  ['String', 'Object', None, None, [
    ['knh_uchar_t*', 'value', '@cast'],
    ['size_t',   'strlen', '@cast'],
    ['knh_hcode_t',  'hcode'],
    ['Object*',     'orig'],
  ]],
  
  ['Bytes', 'Object', None, None, [
    ['knh_uchar_t*', 'value', '@cast'],
    ['size_t', 'size', '@get'],
    ['size_t', 'capacity'],
  ]],

#  ['ID', 'Object', None, None, [
#    ['knh_uchar_t*', 'value', '@cast'],
#    ['size_t', 'size', '@get'],
#  ]],

  ['Regex', 'Object', None, None, [
    ['knh_String*', 'pstr'],
    ['void *', 're'],
  ]],

# collection.h
  ['Array', 'Object', None, None, [
    ['Object**', 'list', '@size(b->capacity)'],
    ['size_t', 'size', '@get'],
    ['size_t', 'capacity'],
  ]],
  
  ['HashMap', 'Object', None, None, [
    ['size_t', 'size', '@get'],
    ['size_t', 'capacity'],
    ['knh_hashmape_t**', 'array'],
    ['float',  'factor', '@get'],
  ]],
  
  ['HashSet', 'Object', None, None, [
    ['size_t', 'size', '@get'],
    ['size_t', 'capacity'],
    ['knh_hashsete_t**', 'array'],
    ['float',  'factor', '@get'],
  ]],
  
  ['DictMap', 'Object', None, None, [
    ['size_t', 'size', '@get'],
    ['size_t', 'capacity'],
    ['knh_dictmape_t*', 'list'],
    ['size_t',  'sorted'],
  ]],
  
  ['DictSet', 'Object', None, None, [
    ['size_t', 'size', '@get'],
    ['size_t', 'capacity'],
    ['knh_dictsete_t*', 'list'],
    ['size_t',  'sorted'],
  ]],
  
  ['Iterator', 'Object', None, None, [
     ['Object*',  'source', '@get'],
     ['knh_class_t', 'cid'],
     ['knh_flag_t',  'flag'],
     ['f_each', 'feach'],
     ['size_t', 'pos'],
     ['void*',  'ref'],
     ['f_next', 'fnext'],
     ['size_t', 'count'],
     ['size_t', 'start'],
     ['size_t', 'end'],
  ]],
  
  ['DictIdx', 'Object', None, None, [
     ['knh_int_t',  'offset'],
     ['knh_Array*', 'terms'],
     ['knh_DictSet*', 'termsDictSet'],
  ]],

  #class.h
  ['Class', 'Object', None, None, [
     ['knh_class_t',  'bcid', '@g'],
     ['knh_type_t',   'type', '@g'],
  ]],
  
  ['ClassStruct',  'Object', None, None, [
#     ['flag_cf_t',   'cflag'],
#     ['flag_of_t',   'oflag'],
#     ['class_t',     'supcid'],
     ['knh_struct_t',    'sid'],
     ['knh_ushort_t',    'fsize'],
     ['knh_cfield_t*',   'fields'],
     ['knh_Array*',      'methods'],
  ]],
  
  ['MethodField',  'Object', None, None, [
     ['knh_flag_t',    'flag'],
     ['knh_ushort_t',  'size'],
     ['knh_mfield_t*', 'params'],
  ]],
  
  ['Method',  'Object', None, None, [
     ['knh_flag_mf_t', 'flag'],
     ['knh_class_t',   'cid'],
     ['knh_methodn_t', 'mn'],
     ['knh_ushort_t',  'delta'],
     ['knh_MethodField*', 'mf'],
     ['f_method', 'func'],
     ['void*', 'code'],
  ]],
  
  ['MapMap',  'Object', None, None, [
     ['knh_ushort_t', 'size'],
     ['knh_flag_mmf_t', 'flag'],
     ['knh_class_t',  'scid'],
     ['knh_class_t',  'tcid'],
     ['f_mapmap',      'fmap'],
     ['Object*',    'config'],
  ]],
  
  ['ClassRel',  'Object', None, None, [
     ['knh_MapMap**', 'maplist'],
     ['knh_ushort_t', 'size'],
     ['knh_ushort_t', 'capacity'],
     ['knh_ushort_t', 'psize'],
     ['knh_ushort_t', 'sorted'],
  ]],

#  ['ClassParam',  'Object', None, None, [
#    ['pztype_t', 'params[KNH_CLASSPARAM_SIZE]'],
#  ]],

  ['Closure',  'Object', None, '@tuple', [
    ['Object*', 'self'],
    ['knh_Method*', 'method'],
  ]],

  ['IntUnit',  'Object', None, None, [
    ['knh_cspec_t', 'spec'],
    ['f_iunit_chk',  'fchk'],
    ['f_iunit_cmp',  'fcmp'],
    ['f_iunit_fmt',  'ffmt'],
    ['knh_int_t',    'min', '@get'],
    ['knh_int_t',    'max', '@get'],
    ['knh_int_t',   'step', '@get'],
    ['knh_int_t',   'bfoffset'],
    ['size_t',     'bfsize'],
    ['Object**',   'bfarray'],
  ]],

  ['FloatUnit',  'Object', None, None, [
    ['knh_cspec_t', 'spec'],
    ['f_funit_chk',  'fchk'],
    ['f_funit_cmp',  'fcmp'],
    ['f_funit_fmt',  'ffmt'],
    ['knh_float_t',    'min', '@get'],
    ['knh_float_t',    'max', '@get'],
    ['knh_float_t',   'step', '@get'],
  ]],

  ['Vocabulary',  'Object', None, None, [
    ['knh_cspec_t', 'spec'],
    ['f_vocab_nmz',    'fnmz'],
    ['f_vocab_val',    'fval'],
    ['f_vocab_cmp',    'fcmp'],
    ['knh_ushort_t',    'bytelen', '@get'],
    ['knh_ushort_t',    'charlen', '@get'],
    ['Object*',        'pattern', '@get'],
    ['knh_DictIdx*',    'vocabDictIdx'],
  ]],

  ['AffineConv',  'Object', None, None, [
    ['knh_float_t', 'scale', '@get'],
    ['knh_float_t', 'shift', '@get'],
    ['knh_int_t',   'iscale'],
    ['knh_int_t',   'ishift'],
  ]],

  ['StreamStat',  'Object', None, None, [
    ['knh_String*',  'urn'],
    ['knh_filen_t',  'filen'],
    ['knh_ushort_t', 'prev'],
    ['size_t',       'line'],
    ['size_t', 'size'],
    ['size_t', 'pos'],
  ]],

  ['InputStream',  'Object', None, None, [
    ['knh_StreamStat*',  'stat'],
    ['f_in_traverse', 'ftraverse'],
    ['f_in_getc',     'fgetc'],
    ['f_in_close',    'fclose'],
    ['input_u', 'in'],
  ]],

  ['OutputStream',  'Object', None, None, [
    ['knh_StreamStat*',  'stat'],
    ['f_out_traverse', 'ftraverse'],
    ['f_out_putc',     'fputc'],
    ['f_out_write',    'fwrite'],
    ['f_out_flush',    'fflush'],
    ['f_out_close',    'fclose'],
    ['output_u',       'out'],
  ]],

  ['Writer',  'Object', None, None, [
    ['knh_OutputStream*',  'out'],
    ['knh_Bytes*',  'strbuf'],
    ['size_t',  'strpos'],
    ['knh_int_t',   'indent'],
    ['knh_String*', 'tab', '@set'],
    ['knh_String*', 'lineFeed', '@set'],
  ]],

  ['MovableText',  'Object', None, None, [
    ['knh_Array*',  'stack'],
    ['knh_uint_t',  'indent'],
  ]],

  ['Exception',  'Object', None, None, [
    ['knh_expt_t',    'eid'],
    ['knh_flag_ef_t', 'flag'],
    ['knh_String*', 'message', '@get'],
    ['Object*', 'bag', '@get'],
    ['knh_Array*', 'traces'],
  ]],

  ['System',  'Object', None, '@tuple', [
    ['knh_DictMap*', 'props'],
    ['knh_InputStream*',   'in'],
    ['knh_OutputStream*',  'out'],
    ['knh_OutputStream*',  'err'],
  ]],

  ['NameSpace', 'Object', None, '@tuple', [
   ['struct knh_NameSpace*', 'parent'],
   ['knh_String*',  'nsname'],
   ['knh_Array*',   'imports'],
   ['knh_DictSet*', 'name2cidDictSet'],
   ['knh_DictMap*', 'tag2urnDictMap'],
  ]],

  ['Runtime',  'Object', None, None, [
    ['knh_uint_t',     'runtime_id'],
    ['knh_HashMap*',   'tmetaHashMap'],
    ['knh_DictMap*',   'tnameContextDictMap'],
    ['knh_HashMap*',   'tmapmapHashMap'],
    ['knh_HashMap*',   'tmethodHashMap'],
    ['knh_NameSpace*', 'ns'],
  ]],

  ['Context',  'Object', None, None, [
    ['knh_Runtime*', 'runtime'],
    ['knh_flag_t',     'flag'],
    ['knh_nsn_t',      'nsn'],
    ['Object**', 'ebp'],
    ['Object**', 'stack'],
    ['knh_uint_t*', 'stackop'],
    ['size_t',   'size'],
#    ['Nue*',     'gchook'],

    ['knh_String*',      'name'],
    ['knh_InputStream*', 'in'],
    ['knh_Writer*',      'out'],
    ['knh_Bytes*',       'buffer'],
    ['knh_Writer*',      'bufferWriter'],
    ['knh_DictMap*',     'props'],
    ['Object*',          'cmpl'],
  ]],

  ['ExceptionHandler',  'Object', None, '@Private', [
   ['knh_Exception*', 'caught'],
   ['jmp_buf',   'jmpbuf'],
  ]],
  
  ['Mutex',  'Object', None, None, [
    ['knh_uint_t',    'magic'],
    ['knh_uint_t',    'loccount'],
    ['knh_mutex_t',   'mutex'],
  ]],
  
  ['Amazon', 'Object', None, None, [
   ['int',     'dummy'],
  ]],

]