/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif


/* ======================================================================== */
/* [structs] */

void
knh_Long_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs)
{
	Long *b =  (Long*)s1;
	b->value = 0;
}

/* ------------------------------------------------------------------------ */

void
knh_Long_struct_copy(Ctx *ctx, Struct *s1, Struct *s2)
{
	Long *b =  (Long*)s1;
	Long *b2 = (Long*)s2;
	b2->value = b->value;
}

/* ------------------------------------------------------------------------ */

knh_int_t
knh_Long_struct_compare(Ctx *ctx, Struct *s1, Struct *s2) 
{
	Long *b =  (Long*)s1;
	Long *b2 = (Long*)s2;
	//knh_class_t cid = knh_struct_cid(s1);
	TODO();
	return b->value - b2->value;
	//return knh_IntSpec_compare(knh_tclass_getIntUnit(ctx, cid), b->value, b2->value);
}

/* ------------------------------------------------------------------------ */

#define _knh_Long_struct_traverse NULL


/* ======================================================================== */
/* [constructors] */

Long* new_Long__fast(Ctx *ctx, knh_class_t cid, knh_int64_t value)
{
	Long *b = (Long*)knh_Object_malloc0(ctx, OF_Long, cid, sizeof(Long));
	b->value = value;
	return b;
}

#define _new_Long(ctx, value) new_Long__fast(ctx, CLASS_Long, value)

/* ------------------------------------------------------------------------ */

Long* new_Long__checked(Ctx *ctx, knh_class_t cid, knh_int64_t value)
{
	TODO();
	return new_Long__fast(ctx, cid, value);
}

/* ======================================================================== */
/* [utils] */

INLINE
knh_int64_t knh_long_max(knh_int64_t a, knh_int64_t b)
{
	return (a > b) ? a : b;
}

/* ------------------------------------------------------------------------ */

INLINE
knh_int64_t knh_long_min(knh_int64_t a, knh_int64_t b)
{
	return (a < b) ? a : b;
}

/* ------------------------------------------------------------------------ */

INLINE
knh_uint64_t knh_ulong_max(knh_uint64_t a, knh_uint64_t b)
{
	return (a > b) ? a : b;
}

/* ------------------------------------------------------------------------ */

INLINE
knh_uint64_t knh_ulong_min(knh_uint64_t a, knh_uint64_t b)
{
	return (a < b) ? a : b;
}

///* ======================================================================== */
///* [mappings] */
//
///* @map String Long */
//
//Object* 
//knh_String_Long(Ctx *ctx, Object *self, Mapping *map)
//{
//	knh_bytes_t t = knh_String_tobytes(self);
//	if(!knh_byte_isnum(t)) {
//		return_Null(ctx, "NumberFormat!!: %s", t.buf);
//	}
//	return new_Long(ctx, knh_bytes_toint(t));
//}
//
///* ------------------------------------------------------------------------ */
//
///* ------------------------------------------------------------------------ */
///* Long original */
//
///* @method[VARARGS] Long! Long.opAdd(Long! v) */
//
//INLINE
//knh_int64_t knh_Long_opAdd(Long *b, knh_vargc_t ac, Long **v)
//{
//	knh_int64_t i, n = knh_Long_value(b);
//	for(i = 0; i < ac; i++) {
//		n += knh_Long_value(v[i]);
//	}
//	return n;
//}
//
///* ------------------------------------------------------------------------ */
//
///* @method[VARAR] Long! Long.opSub(Long! n) */
//
//INLINE
//knh_int64_t knh_Long_opSub(Long *b, knh_vargc_t ac, Long **v)
//{
//	knh_int64_t i, n = knh_Long_value(b);
//	for(i = 0; i < ac; i++) {
//		n -= knh_Long_value(v[i]);
//	}
//	return n;
//}
//
///* ------------------------------------------------------------------------ */
//
///* @method[VARARGS] Long! Long.opMul(Long! n) */
//
//INLINE
//knh_int64_t knh_Long_opMul(Long *b, knh_vargc_t ac, Long **v)
//{
//	knh_int64_t i, n = knh_Long_value(b);
//	for(i = 0; i < ac; i++) {
//		n *= knh_Long_value(v[i]);
//	}
//	return n;
//}
//
///* ------------------------------------------------------------------------ */
//
///* @method[VARARGS] Long! Long.opDiv(Long! n) */
//
//INLINE
//knh_int64_t knh_Long_opDiv(Long *b, knh_vargc_t ac, Long **v)
//{
//	knh_int64_t i, n = knh_Long_value(b);
//	for(i = 0; i < ac; i++) {
//		n /= knh_Long_value(v[i]);
//	}
//	return n;
//}
//
///* ------------------------------------------------------------------------ */
//
///* @method Long! Long.opMod(Long! n) */
//
//INLINE
//knh_int64_t knh_Long_opMod(Long *b, knh_int64_t n)
//{
//	return knh_Long_value(b) % n;
//}

/* ======================================================================== */
/* [movabletext] */

/* @method void Long.%dump(Writer w=new, Any m) */


void knh_Long__dump(Ctx *ctx, Long *b, Writer *w, Any *m)
{
//	char buf[FMT_NSPEC_BUFSIZE];
//	IntSpec *spec = knh_tclass_getIntUnit(ctx, knh_Object_cid(b));
//	knh_IntSpec_format(spec, buf, knh_Long_value(b)); 
//	knh_prints(ctx, w, buf);
}

#ifdef __cplusplus
}
#endif
