/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif


/* ======================================================================== */
/* [structs] */

void knh_StreamStat_struct_init(Ctx *ctx, Struct *s, int init, Object *cs)
{
	StreamStat* b = (StreamStat*)s;
	KNH_INITv(b->urn, knh_String_EMPTY());
	b->filen = 0;
	knh_StreamStat_init(b);
}

/* ------------------------------------------------------------------------ */

#define _knh_StreamStat_struct_copy   NULL

/* ------------------------------------------------------------------------ */

#define _knh_StreamStat_struct_compare  NULL

/* ------------------------------------------------------------------------ */

void
knh_StreamStat_struct_traverse(Ctx *ctx, Struct *s, f_gc gc)
{
	StreamStat *b = (StreamStat*)s;
	gc(ctx, b->urn);
}

/* ======================================================================== */
/* [constructors] */

StreamStat* new_StreamStat_filen(Ctx *ctx, knh_filen_t filen)
{
	StreamStat* b = (StreamStat*)knh_Object_malloc(ctx, CLASS_StreamStat);
	knh_StreamStat_struct_init(ctx, (Struct*)b, 0, NULL);
	b->filen = filen;
	KNH_SETv(ctx, b->urn, knh_tfilen_name(filen));
	return b;
}

/* ======================================================================== */
/* [method] */

void knh_StreamStat_init(StreamStat *b)
{
	b->size    = 0;
	b->line    = 1;
	b->prev    = '\n';
	b->pos     = 0;
}

/* ======================================================================== */
/* [stat] */


void knh_StreamStat_read_ch(StreamStat *b, int_byte_t ch)
{
	if(ch == EOF) return;
	b->size++;
	if(ch == '\n') {
		if(b->prev != '\r') {
			b->line++;
			b->pos = 0;
		}
	}else if(ch == '\r') {
		b->line++;
		b->pos = 0;
	}else {
		b->pos++;
	}
	b->prev = ch;
}

/* ------------------------------------------------------------------------ */

INLINE
void knh_StreamStat_write_size(StreamStat *b, size_t size)
{
	b->size+=size;
}

///* ======================================================================== */
///* [movabletext] */
//
///* @method void StreamStat.%dump(Writer w, Any m) */
//
//void knh_StreamStat__dump(Ctx *ctx, StreamStat *b, Writer *w, Any *m)
//{
//
//}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
