/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif


/* ======================================================================== */
/* [label] */

int knh_Cmpl_nastep(Cmpl *b)
{
	return (int)b->nastep++;
}

/* ------------------------------------------------------------------------ */

int knh_Cmpl_llstep(Cmpl *b)
{
	return (int)b->llstep++;
}

/* ------------------------------------------------------------------------ */

knh_bytes_t knh_bytes_nzlabel(knh_bytes_t t)
{
	DEBUG_ASSERT(t.len > 0);
	if(t.buf[t.len-1] == ':') t.len -= 1;
	return t;
}

/* ------------------------------------------------------------------------ */

void knh_Cmpl_setLabel(Ctx *ctx, Cmpl *b, knh_bytes_t label)
{
	knh_DictIdx_add__b(ctx, b->labelIdDictIdx, label);
}

/* ------------------------------------------------------------------------ */

knh_bool_t knh_Cmpl_hasLabel(Ctx *ctx, Cmpl *b, knh_bytes_t label)
{
#if defined(KONOHA_DEBUGMODE)
	knh_ushort_t id = (knh_ushort_t)knh_DictIdx_add__b(ctx, b->labelIdDictIdx, label);
	DEBUG("LABEL %s id=%d", label.buf, (int)id);
#endif
	TODO();
	return (knh_DictIdx_add__b(ctx, b->labelIdDictIdx, label) != 0);
}

/* ------------------------------------------------------------------------ */

knh_short_t knh_Cmpl_labelId(Ctx *ctx, Cmpl *b, knh_bytes_t label)
{
	knh_ushort_t id = (knh_ushort_t)knh_DictIdx_add__b(ctx, b->labelIdDictIdx, label);
//	DEBUG("LABEL %s id=%d", label.buf, (int)id);
	return id;
}

/* ------------------------------------------------------------------------ */

void KNH_ASM_LABEL(Ctx *ctx, Cmpl *b, String *label)
{
	if(knh_DictSet_get__b(b->labelAddrDictSet, knh_String_tobytes(label)) != 0) {
		DEBUG("Duplicated label: %s", knh_String_tochar(label));
		DEBUG_ASSERT(ctx == NULL);
	}
	knh_vmc_t *pc = (knh_vmc_t*)knh_Bytes_last(b->elf);
	knh_DictSet_put(ctx, b->labelAddrDictSet, label, (knh_uint_t)pc);
	//DEBUG("SET LABEL %s at %p", knh_String_tochar(label), pc);
}

/* ------------------------------------------------------------------------ */

void KNH_ASM_LABEL__b(Ctx *ctx, Cmpl *b, knh_bytes_t t)
{
	KNH_ASM_LABEL(ctx, b, new_String__fast(ctx, CLASS_String, t));
}


//void knh_Cmpl_rewrite_addr(Ctx *ctx, Cmpl *b, knh_vmc_t *pc)
//{
//	//DEBUG("label: id=%d", knh_VirtualMachineCode_uread_short(pc));
//	String *name = knh_DictIdx_get(b->labelIdDictIdx, knh_vmc_read_short(pc));
//	DEBUG_ASSERT(IS_NOTNULL(name));
//	knh_vmc_t *pa = (knh_vmc_t*)knh_DictSet_get__b(b->labelAddrDictSet, knh_String_tobytes(name));
//	if(pa == NULL) {
//		TODO();
//		DEBUG("Asm!!: Unknown Label '%s'", knh_String_tochar(name));
//	}else {
//		//DEBUG("**** %d %d", (int)knh_VirtualMachineCode_uread_short(pc), (int)pc[2]);
//		knh_short_t addr = (pa - pc);
//		knh_vmc_write_short(pc, addr);
//		//DEBUG("**** %d %d", (int)knh_VirtualMachineCode_uread_short(pc), (int)pc[2]);
//	}
//}


/* ======================================================================== */
/* [stack] */

void knh_Cmpl_stack_push(Ctx *ctx, Cmpl *b, String *label)
{
	DEBUG("label='%s'", knh_String_tochar(label));
	knh_Array_add(ctx, b->stacks, label);
}

/* ------------------------------------------------------------------------ */

String *knh_Cmpl_labelOnStackTop(Ctx *ctx, Cmpl *b)
{
	size_t s = knh_Array_size(b->stacks);
	DEBUG_ASSERT(s != 0);
	return knh_Array_n(b->stacks, s-1);
}

/* ------------------------------------------------------------------------ */


void knh_Cmpl_stack_pop(Ctx *ctx, Cmpl *b)
{
	knh_Array_pop(ctx, b->stacks);
}

////
/////* ======================================================================== */
/////* [step] */
////
////
////knh_uint_t knh_Cmpl_nastep(Asm *b)
////{
////	return ++(b->step);
////}
////
////
/////* ======================================================================== */
/////* [stack] */
////
////
////void knh_Cmpl_stack_push(Ctx *ctx, Asm *b, Object *label)
////{
////	knh_Array_add(ctx, b->stacks, label);
////}
////
/////* ------------------------------------------------------------------------ */
////
////
////Object *knh_Cmpl_stack_label(Ctx *ctx, Asm *b)
////{
////	size_t s = knh_Array_size(b->stacks);
////	if(s == 0) return Null;
////	return knh_Array_n(b->stacks, s-1);
////}
////
/////* ------------------------------------------------------------------------ */
////
////
////void knh_Cmpl_stack_pop(Ctx *ctx, Asm *b)
////{
////	knh_Array_pop(ctx, b->stacks);
////}
////
////
/////* ======================================================================== */
/////* [stmt_label] */
////
////
////void knh_Cmpl_set_stmt_label(Ctx *ctx, Asm *b, String *lbl)
////{
////	DEBUG_DUMP(ctx, lbl);
////	KNH_SETv(ctx, b->stmt_label, lbl);
////}
////
///* ------------------------------------------------------------------------ */
////
////
////String *knh_Cmpl_stmt_label(Ctx *ctx, Asm *b)
////{
////	return b->stmt_label;
////}
//
///* ======================================================================== */
///* [label] */
//
//knh_bool_t knh_Cmpl_hasLabel(Ctx *ctx, Cmpl *b, knh_bytes_t label)
//{
//	DEBUG("LABEL '%s'", (char*)label.buf);
//	return (knh_DictSet_get__b(b->labelAddrDictSet, label) != 0);
//}
//
///* ------------------------------------------------------------------------ */
//
//
//void knh_Cmpl_write_label(Ctx *ctx, Cmpl *b, String *label)
//{
//	if(knh_DictSet_get__b(b->labelAddrDictSet, knh_String_tobytes(label)) != 0) {
//		DEBUG("Error!!: Duplicated label: %s", knh_String_tochar(label));
//	}
//	knh_vmc_t *pc = (knh_vmc_t*)knh_Bytes_last(b->elf);
//	knh_DictSet_put(ctx, b->labelAddrDictSet, label, (knh_uint_t)pc);
//	DEBUG("LABEL %s %p", knh_String_tochar(label), pc);
//}
//
//#define _ASM_LABEL(ctx,b,l)  knh_Cmpl_write_label(ctx,b,new_String__fast(ctx, CLASS_String,l));
//
///* ------------------------------------------------------------------------ */
//
//INLINE
//knh_short_t knh_Cmpl_labelid(Ctx *ctx, Cmpl *b, knh_bytes_t label)
//{
//	knh_short_t id = (knh_short_t)knh_DictIdx_addb(ctx, b->labelIdDictIdx, label);
//	DEBUG("LABEL %s id=%d", label.buf, id);
//	return id;
//}
//
///* ------------------------------------------------------------------------ */
//
//
//void knh_Cmpl_rewrite_addr(Ctx *ctx, Cmpl *b, knh_vmc_t *pc)
//{
//	//DEBUG("label: id=%d", knh_VirtualMachineCode_uread_short(pc));
//	String *name = knh_DictIdx_get(b->labelIdDictIdx, knh_VirtualMachineCode_uread_short(pc));
//	DEBUG_ASSERT(IS_NOTNULL(name));
//	knh_vmc_t *pa = (knh_vmc_t*)knh_DictSet_get__b(b->labelAddrDictSet, knh_String_tobytes(name));
//	if(pa == NULL) {
//		DEBUG("Cmpl!!: Unknown Label '%s'", knh_String_tochar(name));
//	}else {
//		//DEBUG("**** %d %d", (int)knh_VirtualMachineCode_uread_short(pc), (int)pc[2]);
//		knh_short_t addr = (pa - pc);
//		knh_VirtualMachineCode_uwrite_short(pc, addr);
//		//DEBUG("**** %d %d", (int)knh_VirtualMachineCode_uread_short(pc), (int)pc[2]);
//	}
//}
//
//
///* ======================================================================== */
///* [stmt_label] */
//
//
//void knh_Cmpl_set_stmt_label(Ctx *ctx, Cmpl *b, String *lbl)
//{
//	DEBUG_DUMP(ctx, lbl);
//	KNH_SETv(ctx, b->stmt_label, lbl);
//}
//
///* ------------------------------------------------------------------------ */
//
//
//String *knh_Cmpl_stmt_label(Ctx *ctx, Cmpl *b)
//{
//	return b->stmt_label;
//}

#ifdef __cplusplus
}
#endif
