/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ------------------------------------------------------------------------ */
/* [Bytes] */


knh_bool_t knh_Bytes_isTripleQuote(Bytes *b, knh_int_t ch)
{
	if(b->size > 2 && 
		b->value[b->size-1] == ch && 
		b->value[b->size-2] == ch &&
		b->value[b->size-3] == ch) return 1;
	return 0;
}

/* ------------------------------------------------------------------------ */
/* [Token] */


Token *new_Token__ch(Ctx *ctx, StreamStat *stat, int_byte_t ch)
{
	char buf[2] = {ch, 0};
	return new_Token__parse(ctx, 0, stat->filen, stat->line, B(buf));
}

/* ------------------------------------------------------------------------ */


void knh_Token_toMismatchedBlock(Ctx *ctx, Token *b, int_byte_t ch, size_t line, size_t pos)
{
	char buf[KONOHAC_ERROR_BUFSIZ];
	knh_snprintf(buf, KONOHAC_ERROR_BUFSIZ, "SyntaxError!!: Mismatched '%c'[%d+%d]", (int)ch, (int)line, (int)pos);
	b->tt = TT_ERR;
	KNH_SETv(ctx, b->data, new_String__fast(ctx, CLASS_String, B(buf)));
}

/* ======================================================================== */
/* [parser] */

void knh_Token_padd(Ctx *ctx, Token *b, Token *tk)
{
	if(knh_Token_tokens_size(b) > 0) {
		Token *tk_prev = knh_Tokens(b, knh_Token_tokens_size(b)-1);
		if(tk->tt == TT_PARENTHESIS) {
			tk_prev->flag |= KNH_FLAG_TKF_FUNC; 
		}
#ifdef KONOHA_GENERICS
		if(tk_prev->tt == TT_ETYPEN) {
			TODO();
			//knh_Token_parser_typeadd(ctx, b, tk_prev, tk);
			//return;
		}
#endif
	}
	knh_Token_tokens_add(ctx, b, tk);
}

/* ------------------------------------------------------------------------ */


void knh_Token_padd__buf(Ctx *ctx, Token *b, StreamStat *stat, Bytes *buf, size_t buf_pos)
{
	knh_bytes_t t = knh_Bytes_lastbyte(buf, buf_pos);
	//DEBUG("'%s'", (char*)t.buf);
	if(t.len == 0 || (t.buf[0] == '.' && t.len == 1)) return ;
	knh_Token_padd(ctx, b, new_Token__parse(ctx, 0, stat->filen, stat->line, t));
	knh_Bytes_subclear(buf, buf_pos);
}

/* ------------------------------------------------------------------------ */


void knh_Token_parse(Ctx *ctx, Token *b, InputStream *in)
{
	knh_int_t ch, prev, quote, lv;

	Bytes *buf = ((Context*)ctx)->buffer;
	size_t buf_pos = knh_Bytes_size(buf);
	StreamStat *stat = in->stat;
	
	MAIN_PART:;
	prev = '\n';
	while((ch = knh_InputStream_getc(ctx, in)) != EOF) {
		MAIN_PART_INLOOP:;
		switch(ch) {
		case '"': case '\'': case '`' :
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			quote = ch;
			goto QUOTED_PART;
			break;
			
		case ' ': case '\t': case '\r':
		case '\n': case '\v':
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			break;
		
		case '(': case '{': case '[': 
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			Token *tk = new_Token__ch(ctx, stat, ch);
			knh_Token_padd(ctx, b, tk);
			knh_Token_parse(ctx, tk, in);
			break;

		case ')': 
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			if(b->tt != TT_PARENTHESIS) {
				knh_Token_toMismatchedBlock(ctx, b, ch, stat->line, stat->pos);
			}
			return ;

		case '}':  
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			if(b->tt != TT_BRACE) {
				knh_Token_toMismatchedBlock(ctx, b, ch, stat->line, stat->pos);
			}
			return ;

		case ']': 
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			if(b->tt != TT_BRANCET) {
				knh_Token_toMismatchedBlock(ctx, b, ch, stat->line, stat->pos);
			}
			return ;

			
		case '@': case '$': case '%':
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			knh_Bytes_putc(ctx, buf, ch);
			break;
					
		case ',': case ';':
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			knh_Token_padd(ctx, b, new_Token__ch(ctx, stat, ch));
			break;

//		case '.':
//			ch = knh_InputStream_getc(ctx, in); 
//			if(ch != '.') {  /* a.b */
//				knh_Bytes_putc(ctx, buf, '.');
//				goto MAIN_PART_INLOOP;
//			}
//			if(knh_Bytes_startsWithClass(buf, buf_pos)) {
//				knh_Bytes_putc(ctx, buf, '.'); /* Class.. */
//				knh_Bytes_putc(ctx, buf, '.');
//				knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
//			}else {  /* a..b ==> a .. b */
//				knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
//				knh_Bytes_putc(ctx, buf, '.');
//				knh_Bytes_putc(ctx, buf, '.');
//				ch = knh_InputStream_getc(ctx, in); 
//				if(ch == '.') {
//					knh_Bytes_putc(ctx, buf, '.');
//					knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
//				}
//				else {
//					knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
//					goto MAIN_PART_INLOOP;
//				}				
//			}
//			break;

		case '#':
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			goto LINE_COMMENT;
			break;
																	
		case '/':
			// knh_Token_split(ctx, b, buf, buf_pos, ba_top, stat, ch);
			ch = knh_InputStream_getc(ctx, in); 
			if(ch == '*' && knh_Bytes_lastsize(buf, buf_pos) == 0) {
				//knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
				goto BLOCK_COMMENT;
			}else if(ch == '/'  && knh_Bytes_lastsize(buf, buf_pos) == 0) {
				//knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
				goto LINE_COMMENT;
			}
			knh_Bytes_putc(ctx, buf, '/');
			goto MAIN_PART_INLOOP;
			break;

		case EOF :
			break;

		default:
			//knh_Token_split(ctx, b, buf, buf_pos, ba_top, stat, ch);
			knh_Bytes_putc(ctx, buf, ch);

		} /* switch */
		prev = ch;
	}/* while */
	knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
	return ;

	/* 'email:java' */
		
	QUOTED_PART:;
	lv = 1;
	KNH_ASSERT(quote == '"' || quote == '\'' || quote == '`');
	ch = knh_InputStream_getc(ctx, in); 
	if(ch == quote) {
		ch = knh_InputStream_getc(ctx, in); 
		if(quote == ch) { /* triple quote */
			knh_Bytes_putc(ctx, buf, ch);
			goto TRIPLE_QUOTED_PART;		
		}else {
			knh_Bytes_putc(ctx, buf, '"');			
			knh_Bytes_putc(ctx, buf, '"');
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			goto MAIN_PART_INLOOP;
		}
	}
	else {
		knh_Bytes_putc(ctx, buf, quote);			
		goto QUOTE_PART_INLOOP;
	}
	while((ch = knh_InputStream_getc(ctx, in)) != EOF) {
		QUOTE_PART_INLOOP:;
		knh_Bytes_putc(ctx, buf, ch);
		if(ch == quote && prev != '\\') {
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			goto MAIN_PART;
		}else if(ch == '\n' || ch == '\r') {
			knh_Bytes_putc(ctx, buf, quote);
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			goto MAIN_PART;
		}
		prev = ch;
	}
	knh_Bytes_putc(ctx, buf, quote);
	knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
	return;
	
	TRIPLE_QUOTED_PART:;
	while((ch = knh_InputStream_getc(ctx, in)) != EOF) { 
		if(ch == '\r') {
			continue;
		}
		if(ch == '\n') {
			if(knh_Bytes_size(buf) - buf_pos == 1) continue;
		}
		knh_Bytes_putc(ctx, buf, ch);
		if(knh_Bytes_isTripleQuote(buf, quote)) {
			knh_Bytes_unputc(buf);
			knh_Bytes_unputc(buf);
			knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
			goto MAIN_PART;
		}
		prev = ch;
	}
	knh_Bytes_putc(ctx, buf, quote);
	knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);
	return;

	LINE_COMMENT:
	while((ch = knh_InputStream_getc(ctx, in)) != EOF) {
		if(ch == '\r' || ch == '\n') {
			goto MAIN_PART;
		}
	}
	//knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);;
	return ;

	BLOCK_COMMENT:
	prev = ' '; quote = 1; 
	while((ch = knh_InputStream_getc(ctx, in)) != EOF) {
		if(ch == '\r' || ch == '\n') {
		}
		if(prev == '*' && ch == '/') {
			quote--;
			if(quote == 0) goto MAIN_PART;
		}else if(prev == '/' && ch == '*') {
			quote++;
		}
		prev = ch;
	}
	//knh_Token_padd__buf(ctx, b, stat, buf, buf_pos);;
	return ;			
}

/* ======================================================================== */
/* [ANY] */

knh_bool_t knh_Token_isANY(Token *tk)
{
	return (IS_String(tk->data));
}

/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
