/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

#include<konoha/konohac_asm_.h>

/* ======================================================================== */
/* [structs] */

void
knh_VirtualMachineCode_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs)
{
	VirtualMachineCode *b =  (VirtualMachineCode*)s1;
	b->size = 0;
	b->code = (knh_vmc_t*)"";
}

/* ------------------------------------------------------------------------ */

void
knh_VirtualMachineCode_struct_copy(Ctx *ctx, Struct *s1, Struct *s2)
{
	VirtualMachineCode *b =  (VirtualMachineCode*)s1;
	VirtualMachineCode *b2 = (VirtualMachineCode*)s2;
	
	b2->size = b->size;
	b2->code = (knh_vmc_t*)knh_malloc(ctx, KNH_SIZE(b->size));
	knh_memcpy(b2->code, b->code, b2->size);
}

/* ------------------------------------------------------------------------ */

#define _knh_VirtualMachineCode_struct_compare  NULL

/* ------------------------------------------------------------------------ */

void
knh_VirtualMachineCode_struct_traverse(Ctx *ctx, Struct *s, f_gc gc)
{
	VirtualMachineCode *b = (VirtualMachineCode*)s;
	knh_VirtualMachineCode_utraverse(ctx, knh_VirtualMachineCode_tobytes(b), gc);
	if(IS_SWEEP(gc)) {
		knh_free(b->code, KNH_SIZE(b->size));
	} 
}

/* ======================================================================== */
/* [constructors] */


VirtualMachineCode* new_VirtualMachineCode(Ctx *ctx, knh_bytes_t code)
{
	VirtualMachineCode* b = (VirtualMachineCode*)knh_Object_malloc(ctx, CLASS_VirtualMachineCode);
	b->code = (knh_vmc_t*)knh_malloc(ctx, KNH_SIZE(code.len));
	b->size = code.len;
	knh_memcpy(b->code, code.buf, code.len);
	return b;
}


/* ======================================================================== */
/* [methods] */

void knh_VirtualMachineCode_exec(Ctx *ctx, Object **sf);

/* ------------------------------------------------------------------------ */

void knh_Method_setVirtualMachineCode(Ctx *ctx, Method *b, VirtualMachineCode *code)
{
	DEBUG_ASSERT(IS_VirtualMachineCode(code));
	if(knh_Method_isObjectCode(b)) {
		KNH_SETv(ctx, b->code, code);
	}else {
		KNH_INITv(b->code, code);
		knh_Method_setObjectCode(b, 1);
	}
	b->func = knh_VirtualMachineCode_exec;
}

/* ------------------------------------------------------------------------ */

INLINE
VirtualMachineCode *knh_Method_vmc(Method *b)
{
	DEBUG_ASSERT(IS_VirtualMachineCode(b->code));
	return (VirtualMachineCode*)b->code;
}

/* ------------------------------------------------------------------------ */


knh_bytes_t knh_VirtualMachineCode_tobytes(VirtualMachineCode *b)
{
	return new_bytes__2(b->code, b->size);
}

/* ------------------------------------------------------------------------ */

INLINE
knh_bytes_t knh_stackf_vmc(Ctx *ctx, Object **sf)
{
	return knh_VirtualMachineCode_tobytes((VirtualMachineCode*)knh_Method_vmc(sf[-1]));
}

/* ------------------------------------------------------------------------ */

INLINE
knh_vmc_t *knh_VirtualMachineCode_pc(VirtualMachineCode *b)
{
	return b->code;
}

/* ------------------------------------------------------------------------ */

INLINE
knh_vmc_t *knh_stackf_VirtualMachineCode_pc(Ctx *ctx, Object **sf)
{
	return knh_VirtualMachineCode_pc((VirtualMachineCode*)knh_Method_vmc(sf[-1]));
}

/* ------------------------------------------------------------------------ */

/* @method void VirtualMachineCode.%dump(Writer w, Any m) */

void knh_VirtualMachineCode__dump(Ctx *ctx, VirtualMachineCode *b, Writer *w, Any *m)
{
	knh_VirtualMachineCode__dump_(ctx, b, w, m);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
