/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/


/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [konohac] */


Stmt *knh_konohac_parse(Ctx *ctx, InputStream *in)
{
	KNH_LOPEN(ctx, 0);
	Token *tk = new_Token__ch(ctx, in->stat, '{');
	KNH_LPUSH(ctx, tk);
	knh_Token_parse(ctx, tk, in);
	DEKNH_DUMP(ctx, tk, "tokens");
	Stmt *stmt = new_Stmt__block(ctx, knh_Token_ts(tk), 0, knh_Token_tokens_size(tk));
	KNH_LCLOSE(ctx);
	return stmt; 
}

/* ------------------------------------------------------------------------ */

knh_nsn_t knh_konohac_compile(Ctx *ctx, knh_nsn_t nsn, Stmt *stmt)
{
	DEKNH_DUMP(ctx, stmt, "parsed tree");

	Cmpl *cmpl = knh_Context_getCompiler(ctx, (Context*)ctx);

	knh_Cmpl_changeNameSpace(ctx, cmpl, nsn);
	knh_Stmt_visit(ctx, stmt, knh_stmtvisit_declc, cmpl, 0);

	knh_Cmpl_changeNameSpace(ctx, cmpl, nsn);
	knh_Stmt_visit(ctx, stmt, knh_stmtvisit_declm, cmpl, 0);

	knh_Cmpl_changeNameSpace(ctx, cmpl, nsn);
	knh_Stmt_visit(ctx, stmt, knh_stmtvisit_declv, cmpl, 0);

	knh_Cmpl_changeNameSpace(ctx, cmpl, nsn);
	knh_Stmt_visit(ctx, stmt, knh_stmtvisit_asm, cmpl, 0);

	return cmpl->nsn;
}

/* ------------------------------------------------------------------------ */

knh_nsn_t
knh_konohac_eval(Ctx *ctx, knh_nsn_t nsn, InputStream *in)
{
	/* try */
	KNH_LOPEN(ctx, 0);
	KNH_PUSHv(ctx, new_ExceptionHandler(ctx));      /* 0 */
	KNH_PUSHv(ctx, Null);                           /* 1 Exception e */

	DEBUG_ASSERT(IS_ExceptionHandler(KNH_LOCALv(0)));
	VM_TRY_BEGIN(ctx, NPC, L_CATCH_EXCEPTION, KNH_LOCALv(0), KNH_LOCALv(1));

	/* body */
	KNH_LPUSH(ctx, in);
//	int ch;
//	while((ch = knh_InputStream_getc(ctx, in)) != EOF) {
//		putchar(ch);
//	}
//	putchar('\n');
	Stmt *stmt = knh_konohac_parse(ctx, in);
	KNH_LPUSH(ctx, stmt);
	nsn = knh_konohac_compile(ctx, nsn, stmt);
	KNH_LCLOSE(ctx);	
	return nsn;
	
	/* catch */
	L_CATCH_EXCEPTION:;
	VM_TRY_END(ctx, KNH_LOCALv(0));
	DEBUG_ASSERT(IS_Exception(KNH_LOCALv(1)));
	knh_format(ctx, StdOut, METHODN__dump, KNH_LOCALv(1), Null);
	KNH_LCLOSE(ctx);
	return nsn;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
