/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef CLASS_KONOHA_H_
#define CLASS_KONOHA_H_

#include<konoha/konoha_t.h>
#include<konoha/konoha_api.h>


/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ------------------------------------------------------------------------ */
/* Object */

//#ifndef KONOHA_OBJECT_MAGIC
//#ifdef  KONOHA_SAFEMODE
#define KONOHA_OBJECT_MAGIC  ((7777 << 7) + 777)
//#endif 
//#endif

typedef struct hObject {
#ifdef KONOHA_OBJECT_MAGIC
	knh_uint_t   magic;
#endif
	knh_uint_t   refc;
	knh_class_t  cid;   
	knh_flag_t   flag;
} hObject;
                   
#define knh_Object_head(b)     (((hObject*)b) - 1)

/* ------------------------------------------------------------------------ */
/* Tuple */

#ifndef KNH_OBJECT_FIELDSIZE
#define KNH_OBJECT_FIELDSIZE 64
#endif

typedef struct {
	Object* value[KNH_OBJECT_FIELDSIZE];
} knh_Tuple;

typedef struct Tuple0 {

} knh_Tuple0 ;


/* ------------------------------------------------------------------------ */
/* Prototype */

#define KNH_PROTOTYPE_FIELDSIZE  KNH_OBJECT_FIELDSIZE

/* ------------------------------------------------------------------------ */
/* HashMap */

typedef struct {
	knh_hcode_t key;
	Object *keyobj;
} knh_hashkey_t;

typedef struct knh_hashmape_t {
	knh_hashkey_t           h;
	struct knh_hashmape_t  *next;
	Object             *value;
} knh_hashmape_t ;

typedef struct knh_hashsete_t {
	knh_hashkey_t            h;
	struct knh_hashsete_t   *next;
	knh_uint_t               value;
} knh_hashsete_t ;

#define knh_qsort qsort

/* ------------------------------------------------------------------------ */
/* DictMap, DictSet */

struct knh_String;
typedef struct knh_dictmape_t {
	struct knh_String *key;
	Object *value;
} knh_dictmape_t; 

typedef struct knh_dictsete_t {
	struct knh_String *key;
	knh_uint_t  value;
} knh_dictsete_t; 

/* ------------------------------------------------------------------------ */
/* Iterator */

struct knh_Iterator;
typedef Object* (*f_next)(Ctx *, struct knh_Iterator *);
typedef Object* (*f_each)(Ctx *, struct knh_Iterator *, knh_class_t);

/* ------------------------------------------------------------------------ */
/* ClassStruct */

typedef struct knh_cfield_t {
	knh_flag_t    flag  ;
	knh_type_t    type  ; 
	knh_fieldn_t  fn    ;
	Object      *value; 
} knh_cfield_t ;

/* ------------------------------------------------------------------------ */

typedef struct  knh_mfield_t {
	knh_type_t   type  ; 
	knh_fieldn_t  fn    ;
} knh_mfield_t ;

/* ------------------------------------------------------------------------ */
/* IntSpec, FloatSpec, StringSpec */

typedef struct knh_cspec_t {
	knh_flag_t  flag;
	knh_class_t cid;
	struct knh_String* urn;
	struct knh_String* tag;
	Object* defvalue;
} knh_cspec_t;

typedef struct knh_ClassSpec {
	knh_cspec_t spec;
} knh_ClassSpec;

struct  knh_IntUnit;
typedef knh_bool_t  (*f_iunit_chk)(struct knh_IntUnit *, knh_int_t v);
typedef knh_int_t   (*f_iunit_cmp)(struct knh_IntUnit *, knh_int_t v1, knh_int_t v2);
typedef void       (*f_iunit_fmt)(struct knh_IntUnit *, char *buf, knh_int_t v);

struct knh_FloatUnit;
typedef knh_bool_t  (*f_funit_chk)(struct knh_FloatUnit *, knh_float_t v);
typedef knh_int_t   (*f_funit_cmp)(struct knh_FloatUnit *, knh_float_t v1, knh_float_t v2);
typedef void       (*f_funit_fmt)(struct knh_FloatUnit *, char *buf, knh_float_t v);

struct knh_Vocabulary;
typedef knh_bool_t   (*f_vocab_nmz)(Ctx *, knh_bytes_t, struct knh_Bytes *);
typedef struct knh_String *(*f_vocab_val)(Ctx *, struct knh_Vocabulary *, knh_bytes_t, void *, size_t, size_t);
typedef knh_int_t   (*f_vocab_cmp)(struct knh_Vocabulary *, knh_bytes_t, knh_bytes_t);

/* ------------------------------------------------------------------------ */
/* InputStream, OutputStream */

struct knh_InputStream;
typedef int_byte_t (*f_in_getc)(Ctx *ctx, struct knh_InputStream *);
typedef void  (*f_in_close)(Ctx *ctx, struct knh_InputStream *);
typedef void  (*f_in_traverse)(Ctx *ctx, struct knh_InputStream *, f_gc gc);

struct knh_Bytes;
typedef struct barray_range_t {
	struct knh_Bytes *ba;
	size_t  pos;
	size_t  end;
} barray_range_t;

typedef union insrc {
	FILE *fp;
	barray_range_t buf;
} input_u;

struct knh_OutputStream;
typedef void  (*f_out_putc)(Ctx *ctx, struct knh_OutputStream *, int_byte_t);
typedef void  (*f_out_write)(Ctx *ctx, struct knh_OutputStream *, knh_bytes_t);
typedef void  (*f_out_flush)(Ctx *ctx, struct knh_OutputStream *);
typedef void  (*f_out_close)(Ctx *ctx, struct knh_OutputStream *);
typedef void  (*f_out_traverse)(Ctx *ctx, struct knh_OutputStream *, f_gc);

typedef union outsrc {
	FILE *fp;
	struct knh_Bytes *ba;
} output_u ;

/* ------------------------------------------------------------------------ */

#define KONOHA_TABLE_MAGIC   4219881

/* ------------------------------------------------------------------------ */

typedef struct {
	size_t                size;
	char                 *name;
	f_struct_init         finit;
	f_struct_traverse     ftravr;
	f_struct_compare      fcompr;
	f_struct_copy         fcopy;
} knh_tstruct_t ;

#ifndef KONOHA_TSTRUCT_SIZE
#define KONOHA_TSTRUCT_SIZE 256
#endif

#define TSTRUCTDB_SIZE  (KONOHA_TSTRUCT_SIZE * sizeof(knh_tstruct_t))

/* ------------------------------------------------------------------------ */

typedef ObjectNULL* (*f_value)(Ctx *ctx, knh_class_t cid);

typedef struct {
	knh_uint_t    count;
	knh_flag_t    cflag;
	knh_flag_t    oflag;
	knh_struct_t  topsid;    
	knh_class_t   supcid;
	knh_ushort_t  offset;
	knh_struct_t  sid;    
	knh_index_t   keyidx;
	Object    *name;
	Object    *class;
	Object    *cstruct;
	Object    *crel;
	Object    *spec;
	f_value   fvalue;
} knh_tclass_t;

#ifndef KONOHA_TCLASS_SIZE 
#define KONOHA_TCLASS_SIZE 256
#endif  

#define TCLASSDB_SIZE  (KONOHA_TCLASS_SIZE * sizeof(knh_tclass_t))

#ifndef KONOHA_TFIELDN_SIZE
#define KONOHA_TFIELDN_SIZE 256
#endif

#ifndef KONOHA_TMETHODN_SIZE
#define KONOHA_TMETHODN_SIZE 512
#endif

/* ------------------------------------------------------------------------ */

typedef struct {
	knh_flag_t   flag;
	knh_expt_t   parent;
	Object     *name;
} knh_texpt_t;

#ifndef KONOHA_TEXPT_SIZE
#define KONOHA_TEXPT_SIZE (KONOHA_TCLASS_SIZE/4)
#endif

#define TEXPTDB_SIZE  (KONOHA_TEXPT_SIZE * sizeof(knh_texpt_t))


/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* include generated header file */

#ifdef __cplusplus 
}
#endif

#include"konoha_.h"

#endif /*CLASS_KONOHA_H_*/

