/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA__H
#define KONOHA__H

#include<konoha/konoha_t.h>
#include<konoha/class/konoha.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

typedef knh_flag_t knh_flag_of_t;
#define KNH_FLAG_OF_RELEASE             KNH_FLAG0
#define KNH_FLAG_OF_IMMUTABLE           KNH_FLAG1
#define KNH_FLAG_OF_METADATA            KNH_FLAG2
#define KNH_FLAG_OF_SYNCHRONIZED        KNH_FLAG3
#define KNH_FLAG_OF_MODIFIED            KNH_FLAG4
#define KNH_FLAG_OF_LOCAL4              KNH_FLAG5
#define KNH_FLAG_OF_LOCAL3              KNH_FLAG6
#define KNH_FLAG_OF_LOCAL2              KNH_FLAG7
#define KNH_FLAG_OF_LOCAL1              KNH_FLAG8

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[1];
 } knh_Tuple1; 

#define knh_Tuple1NULL          knh_Tuple1

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[2];
 } knh_Tuple2; 

#define knh_Tuple2NULL          knh_Tuple2

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[3];
 } knh_Tuple3; 

#define knh_Tuple3NULL          knh_Tuple3

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[4];
 } knh_Tuple4; 

#define knh_Tuple4NULL          knh_Tuple4

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[5];
 } knh_Tuple5; 

#define knh_Tuple5NULL          knh_Tuple5

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[6];
 } knh_Tuple6; 

#define knh_Tuple6NULL          knh_Tuple6

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[7];
 } knh_Tuple7; 

#define knh_Tuple7NULL          knh_Tuple7

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[8];
 } knh_Tuple8; 

#define knh_Tuple8NULL          knh_Tuple8

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[9];
 } knh_Tuple9; 

#define knh_Tuple9NULL          knh_Tuple9

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[10];
 } knh_Tuple10; 

#define knh_Tuple10NULL         knh_Tuple10

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[11];
 } knh_Tuple11; 

#define knh_Tuple11NULL         knh_Tuple11

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[12];
 } knh_Tuple12; 

#define knh_Tuple12NULL         knh_Tuple12

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[13];
 } knh_Tuple13; 

#define knh_Tuple13NULL         knh_Tuple13

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[14];
 } knh_Tuple14; 

#define knh_Tuple14NULL         knh_Tuple14

/* ------------------------------------------------------------------------ */

 typedef struct {
 	Object* v[15];
 } knh_Tuple15; 

#define knh_Tuple15NULL         knh_Tuple15

/* ------------------------------------------------------------------------ */
/* class knh_Prototype */

typedef struct knh_Prototype {
	Object* value[KNH_PROTOTYPE_FIELDSIZE];
	Object* ns;
} knh_Prototype;

#define knh_PrototypeNULL               knh_Prototype

/* ------------------------------------------------------------------------ */
/* knh_Prototype */

knh_Prototype* knh_Prototype_cast(Ctx *ctx, Object *b);
knh_Prototype* knh_Prototype_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
#define KNH_FLAG_NUE_GCHOOK             KNH_FLAG_OF_LOCAL1
#define KNH_FLAG_NUE_OBJECTTEXT         KNH_FLAG_OF_LOCAL2

/* ------------------------------------------------------------------------ */
/* class knh_Nue */

typedef struct knh_Nue {
	void* msg;
} knh_Nue;

#define knh_NueNULL                     knh_Nue

/* ------------------------------------------------------------------------ */
/* knh_Nue */

knh_Nue* knh_Nue_cast(Ctx *ctx, Object *b);
knh_Nue* knh_Nue_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Bool */

typedef struct knh_Bool {
	knh_bool_t value;
} knh_Bool;

#define knh_BoolNULL                    knh_Bool

/* ------------------------------------------------------------------------ */
/* knh_Bool */

knh_Bool* knh_Bool_cast(Ctx *ctx, Object *b);
knh_Bool* knh_Bool_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Int */

typedef struct knh_Int {
	knh_int_t value;
} knh_Int;

#define knh_IntNULL                     knh_Int

/* ------------------------------------------------------------------------ */
/* knh_Int */

knh_Int* knh_Int_cast(Ctx *ctx, Object *b);
knh_Int* knh_Int_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Float */

typedef struct knh_Float {
	knh_float_t value;
} knh_Float;

#define knh_FloatNULL                   knh_Float

/* ------------------------------------------------------------------------ */
/* knh_Float */

knh_Float* knh_Float_cast(Ctx *ctx, Object *b);
knh_Float* knh_Float_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Long */

typedef struct knh_Long {
	knh_int64_t value;
} knh_Long;

#define knh_LongNULL                    knh_Long

/* ------------------------------------------------------------------------ */
/* knh_Long */

knh_Long* knh_Long_cast(Ctx *ctx, Object *b);
knh_Long* knh_Long_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
#define KNH_FLAG_STRING_STEXT           KNH_FLAG_OF_LOCAL1

/* ------------------------------------------------------------------------ */
/* class knh_String */

typedef struct knh_String {
	knh_uchar_t* value;
	size_t strlen;
	knh_hcode_t hcode;
	Object* orig;
} knh_String;

#define knh_StringNULL                  knh_String

/* ------------------------------------------------------------------------ */
/* knh_String */

knh_String* knh_String_cast(Ctx *ctx, Object *b);
knh_String* knh_String_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Bytes */

typedef struct knh_Bytes {
	knh_uchar_t* value;
	size_t size;
	size_t capacity;
} knh_Bytes;

#define knh_BytesNULL                   knh_Bytes

/* ------------------------------------------------------------------------ */
/* knh_Bytes */

knh_Bytes* knh_Bytes_cast(Ctx *ctx, Object *b);
knh_Bytes* knh_Bytes_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Regex */

typedef struct knh_Regex {
	knh_String* pstr;
	void * re;
} knh_Regex;

#define knh_RegexNULL                   knh_Regex

/* ------------------------------------------------------------------------ */
/* knh_Regex */

knh_Regex* knh_Regex_cast(Ctx *ctx, Object *b);
knh_Regex* knh_Regex_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Array */

typedef struct knh_Array {
	Object** list;
	size_t size;
	size_t capacity;
} knh_Array;

#define knh_ArrayNULL                   knh_Array

/* ------------------------------------------------------------------------ */
/* knh_Array */

knh_Array* knh_Array_cast(Ctx *ctx, Object *b);
knh_Array* knh_Array_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_HashMap */

typedef struct knh_HashMap {
	size_t size;
	size_t capacity;
	knh_hashmape_t** array;
	float factor;
} knh_HashMap;

#define knh_HashMapNULL                 knh_HashMap

/* ------------------------------------------------------------------------ */
/* knh_HashMap */

knh_HashMap* knh_HashMap_cast(Ctx *ctx, Object *b);
knh_HashMap* knh_HashMap_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_HashSet */

typedef struct knh_HashSet {
	size_t size;
	size_t capacity;
	knh_hashsete_t** array;
	float factor;
} knh_HashSet;

#define knh_HashSetNULL                 knh_HashSet

/* ------------------------------------------------------------------------ */
/* knh_HashSet */

knh_HashSet* knh_HashSet_cast(Ctx *ctx, Object *b);
knh_HashSet* knh_HashSet_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_DictMap */

typedef struct knh_DictMap {
	size_t size;
	size_t capacity;
	knh_dictmape_t* list;
	size_t sorted;
} knh_DictMap;

#define knh_DictMapNULL                 knh_DictMap

/* ------------------------------------------------------------------------ */
/* knh_DictMap */

knh_DictMap* knh_DictMap_cast(Ctx *ctx, Object *b);
knh_DictMap* knh_DictMap_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_DictSet */

typedef struct knh_DictSet {
	size_t size;
	size_t capacity;
	knh_dictsete_t* list;
	size_t sorted;
} knh_DictSet;

#define knh_DictSetNULL                 knh_DictSet

/* ------------------------------------------------------------------------ */
/* knh_DictSet */

knh_DictSet* knh_DictSet_cast(Ctx *ctx, Object *b);
knh_DictSet* knh_DictSet_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Iterator */

typedef struct knh_Iterator {
	Object* source;
	knh_class_t cid;
	knh_flag_t flag;
	f_each feach;
	size_t pos;
	void* ref;
	f_next fnext;
	size_t count;
	size_t start;
	size_t end;
} knh_Iterator;

#define knh_IteratorNULL                knh_Iterator

/* ------------------------------------------------------------------------ */
/* knh_Iterator */

knh_Iterator* knh_Iterator_cast(Ctx *ctx, Object *b);
knh_Iterator* knh_Iterator_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_DictIdx */

typedef struct knh_DictIdx {
	knh_int_t offset;
	knh_Array* terms;
	knh_DictSet* termsDictSet;
} knh_DictIdx;

#define knh_DictIdxNULL                 knh_DictIdx

/* ------------------------------------------------------------------------ */
/* knh_DictIdx */

knh_DictIdx* knh_DictIdx_cast(Ctx *ctx, Object *b);
knh_DictIdx* knh_DictIdx_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

typedef knh_flag_t knh_flag_cf_t;
#define KNH_FLAG_CF_RELEASE             KNH_FLAG0
#define KNH_FLAG_CF_IMMUTABLE           KNH_FLAG1
#define KNH_FLAG_CF_METAEXTENSIBLE      KNH_FLAG2
#define KNH_FLAG_CF_PRIVATE             KNH_FLAG3
#define KNH_FLAG_CF_FINAL               KNH_FLAG4
#define KNH_FLAG_CF_STRICT              KNH_FLAG5
#define KNH_FLAG_CF_SYSTEM              KNH_FLAG6
#define KNH_FLAG_CF_NULLOBJECT          KNH_FLAG7
#define KNH_FLAG_CF_NA                  KNH_FLAG8

/* ------------------------------------------------------------------------ */
/* class knh_Class */

typedef struct knh_Class {
	knh_class_t bcid;
	knh_type_t type;
} knh_Class;

#define knh_ClassNULL                   knh_Class

/* ------------------------------------------------------------------------ */
/* knh_Class */

knh_Class* knh_Class_cast(Ctx *ctx, Object *b);
knh_Class* knh_Class_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

typedef knh_flag_t knh_flag_cff_t;
#define KNH_FLAG_CFF_HIDDEN             KNH_FLAG0
#define KNH_FLAG_CFF_AUTONAME           KNH_FLAG1
#define KNH_FLAG_CFF_SAFEVALUE          KNH_FLAG2
#define KNH_FLAG_CFF_PROTECTED          KNH_FLAG3
#define KNH_FLAG_CFF_GETTER             KNH_FLAG4
#define KNH_FLAG_CFF_SETTER             KNH_FLAG5
#define KNH_FLAG_CFF_KEY                KNH_FLAG6

/* ------------------------------------------------------------------------ */
/* class knh_ClassStruct */

typedef struct knh_ClassStruct {
	knh_struct_t sid;
	knh_ushort_t fsize;
	knh_cfield_t* fields;
	knh_Array* methods;
} knh_ClassStruct;

#define knh_ClassStructNULL             knh_ClassStruct

/* ------------------------------------------------------------------------ */
/* knh_ClassStruct */

knh_ClassStruct* knh_ClassStruct_cast(Ctx *ctx, Object *b);
knh_ClassStruct* knh_ClassStruct_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_MethodField */

typedef struct knh_MethodField {
	knh_flag_t flag;
	knh_ushort_t size;
	knh_mfield_t* params;
} knh_MethodField;

#define knh_MethodFieldNULL             knh_MethodField

/* ------------------------------------------------------------------------ */
/* knh_MethodField */

knh_MethodField* knh_MethodField_cast(Ctx *ctx, Object *b);
knh_MethodField* knh_MethodField_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

typedef knh_flag_t knh_flag_mf_t;
#define KNH_FLAG_MF_PUBLIC              KNH_FLAG0
#define KNH_FLAG_MF_VIRTUAL             KNH_FLAG1
#define KNH_FLAG_MF_STATIC              KNH_FLAG2
#define KNH_FLAG_MF_VARARGS             KNH_FLAG3
#define KNH_FLAG_MF_ASPECT              KNH_FLAG4
#define KNH_FLAG_MF_OBJECTCODE          KNH_FLAG5
#define KNH_FLAG_MF_GENERATED           KNH_FLAG6

/* ------------------------------------------------------------------------ */
/* class knh_Method */

typedef struct knh_Method {
	knh_flag_mf_t flag;
	knh_class_t cid;
	knh_methodn_t mn;
	knh_ushort_t delta;
	knh_MethodField* mf;
	f_method func;
	void* code;
} knh_Method;

#define knh_MethodNULL                  knh_Method

/* ------------------------------------------------------------------------ */
/* knh_Method */

knh_Method* knh_Method_cast(Ctx *ctx, Object *b);
knh_Method* knh_Method_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

typedef knh_flag_t knh_flag_mmf_t;
#define KNH_FLAG_MMF_INTERFACE          KNH_FLAG0
#define KNH_FLAG_MMF_VERYSIGNIFICANT    KNH_FLAG1
#define KNH_FLAG_MMF_SIGNIFICANT        KNH_FLAG2
#define KNH_FLAG_MMF_SYNONYM            KNH_FLAG3
#define KNH_FLAG_MMF_LOSSLESS           KNH_FLAG4
#define KNH_FLAG_MMF_TOTAL              KNH_FLAG5
#define KNH_FLAG_MMF_STATIC             KNH_FLAG6
#define KNH_FLAG_MMF_LOCAL              KNH_FLAG7
#define KNH_FLAG_MMF_DERIVED            KNH_FLAG8

/* ------------------------------------------------------------------------ */
/* class knh_MapMap */

typedef struct knh_MapMap {
	knh_ushort_t size;
	knh_flag_mmf_t flag;
	knh_class_t scid;
	knh_class_t tcid;
	f_mapmap fmap;
	Object* config;
} knh_MapMap;

#define knh_MapMapNULL                  knh_MapMap

/* ------------------------------------------------------------------------ */
/* knh_MapMap */

knh_MapMap* knh_MapMap_cast(Ctx *ctx, Object *b);
knh_MapMap* knh_MapMap_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_ClassRel */

typedef struct knh_ClassRel {
	knh_MapMap** maplist;
	knh_ushort_t size;
	knh_ushort_t capacity;
	knh_ushort_t psize;
	knh_ushort_t sorted;
} knh_ClassRel;

#define knh_ClassRelNULL                knh_ClassRel

/* ------------------------------------------------------------------------ */
/* knh_ClassRel */

knh_ClassRel* knh_ClassRel_cast(Ctx *ctx, Object *b);
knh_ClassRel* knh_ClassRel_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Closure */

typedef struct knh_Closure {
	Object* self;
	knh_Method* method;
} knh_Closure;

#define knh_ClosureNULL                 knh_Closure

/* ------------------------------------------------------------------------ */
/* knh_Closure */

knh_Closure* knh_Closure_cast(Ctx *ctx, Object *b);
knh_Closure* knh_Closure_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

typedef knh_flag_t knh_flag_uf_t;
#define KNH_FLAG_UF_UNSIGNED            KNH_FLAG0

/* ------------------------------------------------------------------------ */
/* class knh_IntUnit */

typedef struct knh_IntUnit {
	knh_cspec_t spec;
	f_iunit_chk fchk;
	f_iunit_cmp fcmp;
	f_iunit_fmt ffmt;
	knh_int_t min;
	knh_int_t max;
	knh_int_t step;
	knh_int_t bfoffset;
	size_t bfsize;
	Object** bfarray;
} knh_IntUnit;

#define knh_IntUnitNULL                 knh_IntUnit

/* ------------------------------------------------------------------------ */
/* knh_IntUnit */

knh_IntUnit* knh_IntUnit_cast(Ctx *ctx, Object *b);
knh_IntUnit* knh_IntUnit_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_FloatUnit */

typedef struct knh_FloatUnit {
	knh_cspec_t spec;
	f_funit_chk fchk;
	f_funit_cmp fcmp;
	f_funit_fmt ffmt;
	knh_float_t min;
	knh_float_t max;
	knh_float_t step;
} knh_FloatUnit;

#define knh_FloatUnitNULL               knh_FloatUnit

/* ------------------------------------------------------------------------ */
/* knh_FloatUnit */

knh_FloatUnit* knh_FloatUnit_cast(Ctx *ctx, Object *b);
knh_FloatUnit* knh_FloatUnit_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Vocabulary */

typedef struct knh_Vocabulary {
	knh_cspec_t spec;
	f_vocab_nmz fnmz;
	f_vocab_val fval;
	f_vocab_cmp fcmp;
	knh_ushort_t bytelen;
	knh_ushort_t charlen;
	Object* pattern;
	knh_DictIdx* vocabDictIdx;
} knh_Vocabulary;

#define knh_VocabularyNULL              knh_Vocabulary

/* ------------------------------------------------------------------------ */
/* knh_Vocabulary */

knh_Vocabulary* knh_Vocabulary_cast(Ctx *ctx, Object *b);
knh_Vocabulary* knh_Vocabulary_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_AffineConv */

typedef struct knh_AffineConv {
	knh_float_t scale;
	knh_float_t shift;
	knh_int_t iscale;
	knh_int_t ishift;
} knh_AffineConv;

#define knh_AffineConvNULL              knh_AffineConv

/* ------------------------------------------------------------------------ */
/* knh_AffineConv */

knh_AffineConv* knh_AffineConv_cast(Ctx *ctx, Object *b);
knh_AffineConv* knh_AffineConv_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_StreamStat */

typedef struct knh_StreamStat {
	knh_String* urn;
	knh_filen_t filen;
	knh_ushort_t prev;
	size_t line;
	size_t size;
	size_t pos;
} knh_StreamStat;

#define knh_StreamStatNULL              knh_StreamStat

/* ------------------------------------------------------------------------ */
/* knh_StreamStat */

knh_StreamStat* knh_StreamStat_cast(Ctx *ctx, Object *b);
knh_StreamStat* knh_StreamStat_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_InputStream */

typedef struct knh_InputStream {
	knh_StreamStat* stat;
	f_in_traverse ftraverse;
	f_in_getc fgetc;
	f_in_close fclose;
	input_u in;
} knh_InputStream;

#define knh_InputStreamNULL             knh_InputStream

/* ------------------------------------------------------------------------ */
/* knh_InputStream */

knh_InputStream* knh_InputStream_cast(Ctx *ctx, Object *b);
knh_InputStream* knh_InputStream_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_OutputStream */

typedef struct knh_OutputStream {
	knh_StreamStat* stat;
	f_out_traverse ftraverse;
	f_out_putc fputc;
	f_out_write fwrite;
	f_out_flush fflush;
	f_out_close fclose;
	output_u out;
} knh_OutputStream;

#define knh_OutputStreamNULL            knh_OutputStream

/* ------------------------------------------------------------------------ */
/* knh_OutputStream */

knh_OutputStream* knh_OutputStream_cast(Ctx *ctx, Object *b);
knh_OutputStream* knh_OutputStream_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Writer */

typedef struct knh_Writer {
	knh_OutputStream* out;
	knh_Bytes* strbuf;
	size_t strpos;
	knh_int_t indent;
	knh_String* tab;
	knh_String* lineFeed;
} knh_Writer;

#define knh_WriterNULL                  knh_Writer

/* ------------------------------------------------------------------------ */
/* knh_Writer */

knh_Writer* knh_Writer_cast(Ctx *ctx, Object *b);
knh_Writer* knh_Writer_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_MovableText */

typedef struct knh_MovableText {
	knh_Array* stack;
	knh_uint_t indent;
} knh_MovableText;

#define knh_MovableTextNULL             knh_MovableText

/* ------------------------------------------------------------------------ */
/* knh_MovableText */

knh_MovableText* knh_MovableText_cast(Ctx *ctx, Object *b);
knh_MovableText* knh_MovableText_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

typedef knh_flag_t knh_flag_ef_t;
#define KNH_FLAG_EF_FATAL               KNH_FLAG0
#define KNH_FLAG_EF_LOGGING             KNH_FLAG1
#define KNH_FLAG_EF_GENERATED           KNH_FLAG2
#define KNH_FLAG_EF_CAUGHT              KNH_FLAG3

/* ------------------------------------------------------------------------ */
/* class knh_Exception */

typedef struct knh_Exception {
	knh_expt_t eid;
	knh_flag_ef_t flag;
	knh_String* message;
	Object* bag;
	knh_Array* traces;
} knh_Exception;

#define knh_ExceptionNULL               knh_Exception

/* ------------------------------------------------------------------------ */
/* knh_Exception */

knh_Exception* knh_Exception_cast(Ctx *ctx, Object *b);
knh_Exception* knh_Exception_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_System */

typedef struct knh_System {
	knh_DictMap* props;
	knh_InputStream* in;
	knh_OutputStream* out;
	knh_OutputStream* err;
} knh_System;

#define knh_SystemNULL                  knh_System

/* ------------------------------------------------------------------------ */
/* knh_System */

knh_System* knh_System_cast(Ctx *ctx, Object *b);
knh_System* knh_System_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_NameSpace */

typedef struct knh_NameSpace {
	struct knh_NameSpace* parent;
	knh_String* nsname;
	knh_Array* imports;
	knh_DictSet* name2cidDictSet;
	knh_DictMap* tag2urnDictMap;
} knh_NameSpace;

#define knh_NameSpaceNULL               knh_NameSpace

/* ------------------------------------------------------------------------ */
/* knh_NameSpace */

knh_NameSpace* knh_NameSpace_cast(Ctx *ctx, Object *b);
knh_NameSpace* knh_NameSpace_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Runtime */

typedef struct knh_Runtime {
	knh_uint_t runtime_id;
	knh_HashMap* tmetaHashMap;
	knh_DictMap* tnameContextDictMap;
	knh_HashMap* tmapmapHashMap;
	knh_HashMap* tmethodHashMap;
	knh_NameSpace* ns;
} knh_Runtime;

#define knh_RuntimeNULL                 knh_Runtime

/* ------------------------------------------------------------------------ */
/* knh_Runtime */

knh_Runtime* knh_Runtime_cast(Ctx *ctx, Object *b);
knh_Runtime* knh_Runtime_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Context */

typedef struct knh_Context {
	knh_Runtime* runtime;
	knh_flag_t flag;
	knh_nsn_t nsn;
	Object** ebp;
	Object** stack;
	knh_uint_t* stackop;
	size_t size;
	knh_String* name;
	knh_InputStream* in;
	knh_Writer* out;
	knh_Bytes* buffer;
	knh_Writer* bufferWriter;
	knh_DictMap* props;
	Object* cmpl;
} knh_Context;

#define knh_ContextNULL                 knh_Context

/* ------------------------------------------------------------------------ */
/* knh_Context */

knh_Context* knh_Context_cast(Ctx *ctx, Object *b);
knh_Context* knh_Context_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
#define KNH_FLAG_EHF_CATCHING           KNH_FLAG_OF_LOCAL1

/* ------------------------------------------------------------------------ */
/* class knh_ExceptionHandler */

typedef struct knh_ExceptionHandler {
	knh_Exception* caught;
	jmp_buf jmpbuf;
} knh_ExceptionHandler;

#define knh_ExceptionHandlerNULL        knh_ExceptionHandler

/* ------------------------------------------------------------------------ */
/* knh_ExceptionHandler */

knh_ExceptionHandler* knh_ExceptionHandler_cast(Ctx *ctx, Object *b);
knh_ExceptionHandler* knh_ExceptionHandler_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Mutex */

typedef struct knh_Mutex {
	knh_uint_t magic;
	knh_uint_t loccount;
	knh_mutex_t mutex;
} knh_Mutex;

#define knh_MutexNULL                   knh_Mutex

/* ------------------------------------------------------------------------ */
/* knh_Mutex */

knh_Mutex* knh_Mutex_cast(Ctx *ctx, Object *b);
knh_Mutex* knh_Mutex_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */
/* class knh_Amazon */

typedef struct knh_Amazon {
	int dummy;
} knh_Amazon;

#define knh_AmazonNULL                  knh_Amazon

/* ------------------------------------------------------------------------ */
/* knh_Amazon */

knh_Amazon* knh_Amazon_cast(Ctx *ctx, Object *b);
knh_Amazon* knh_Amazon_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ======================================================================== */

/* ------------------------------------------------------------------------ */
/* knh_Object */

knh_Object* knh_Object_cast(Ctx *ctx, Object *b);
knh_Object* knh_Object_castOrNull(Ctx *ctx, Object *b);

#define knh_Object_isRelease(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_RELEASE) == KNH_FLAG_OF_RELEASE)

#define knh_Object_isDebug(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_RELEASE) != KNH_FLAG_OF_RELEASE)

#define knh_Object_isImmutable(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_IMMUTABLE) == KNH_FLAG_OF_IMMUTABLE)

#define knh_Object_hasMetaData(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_METADATA) == KNH_FLAG_OF_METADATA)

#define knh_Object_setMetaData(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_OF_METADATA; else knh_Object_head(o)->flag &= ~(KNH_FLAG_OF_METADATA);


#define knh_Object_isSynchronized(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_SYNCHRONIZED) == KNH_FLAG_OF_SYNCHRONIZED)

#define knh_Object_isModified(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_MODIFIED) == KNH_FLAG_OF_MODIFIED)

#define knh_Object_setModified(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_OF_MODIFIED; else knh_Object_head(o)->flag &= ~(KNH_FLAG_OF_MODIFIED);


#define knh_Object_isLocal4(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_LOCAL4) == KNH_FLAG_OF_LOCAL4)

#define knh_Object_setLocal4(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_OF_LOCAL4; else knh_Object_head(o)->flag &= ~(KNH_FLAG_OF_LOCAL4);


#define knh_Object_isLocal3(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_LOCAL3) == KNH_FLAG_OF_LOCAL3)

#define knh_Object_setLocal3(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_OF_LOCAL3; else knh_Object_head(o)->flag &= ~(KNH_FLAG_OF_LOCAL3);


#define knh_Object_isLocal2(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_LOCAL2) == KNH_FLAG_OF_LOCAL2)

#define knh_Object_setLocal2(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_OF_LOCAL2; else knh_Object_head(o)->flag &= ~(KNH_FLAG_OF_LOCAL2);


#define knh_Object_isLocal1(o)   ((knh_Object_head(o)->flag & KNH_FLAG_OF_LOCAL1) == KNH_FLAG_OF_LOCAL1)

#define knh_Object_setLocal1(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_OF_LOCAL1; else knh_Object_head(o)->flag &= ~(KNH_FLAG_OF_LOCAL1);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple1 */

knh_Tuple1* knh_Tuple1_cast(Ctx *ctx, Object *b);
knh_Tuple1* knh_Tuple1_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple2 */

knh_Tuple2* knh_Tuple2_cast(Ctx *ctx, Object *b);
knh_Tuple2* knh_Tuple2_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple3 */

knh_Tuple3* knh_Tuple3_cast(Ctx *ctx, Object *b);
knh_Tuple3* knh_Tuple3_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple4 */

knh_Tuple4* knh_Tuple4_cast(Ctx *ctx, Object *b);
knh_Tuple4* knh_Tuple4_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple5 */

knh_Tuple5* knh_Tuple5_cast(Ctx *ctx, Object *b);
knh_Tuple5* knh_Tuple5_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple6 */

knh_Tuple6* knh_Tuple6_cast(Ctx *ctx, Object *b);
knh_Tuple6* knh_Tuple6_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple7 */

knh_Tuple7* knh_Tuple7_cast(Ctx *ctx, Object *b);
knh_Tuple7* knh_Tuple7_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple8 */

knh_Tuple8* knh_Tuple8_cast(Ctx *ctx, Object *b);
knh_Tuple8* knh_Tuple8_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple9 */

knh_Tuple9* knh_Tuple9_cast(Ctx *ctx, Object *b);
knh_Tuple9* knh_Tuple9_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple10 */

knh_Tuple10* knh_Tuple10_cast(Ctx *ctx, Object *b);
knh_Tuple10* knh_Tuple10_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple11 */

knh_Tuple11* knh_Tuple11_cast(Ctx *ctx, Object *b);
knh_Tuple11* knh_Tuple11_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple12 */

knh_Tuple12* knh_Tuple12_cast(Ctx *ctx, Object *b);
knh_Tuple12* knh_Tuple12_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple13 */

knh_Tuple13* knh_Tuple13_cast(Ctx *ctx, Object *b);
knh_Tuple13* knh_Tuple13_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple14 */

knh_Tuple14* knh_Tuple14_cast(Ctx *ctx, Object *b);
knh_Tuple14* knh_Tuple14_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Tuple15 */

knh_Tuple15* knh_Tuple15_cast(Ctx *ctx, Object *b);
knh_Tuple15* knh_Tuple15_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Prototype */

knh_Prototype* knh_Prototype_cast(Ctx *ctx, Object *b);
knh_Prototype* knh_Prototype_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Nue */

knh_Nue* knh_Nue_cast(Ctx *ctx, Object *b);
knh_Nue* knh_Nue_castOrNull(Ctx *ctx, Object *b);

#define knh_Nue_isGCHook(o)   ((knh_Object_head(o)->flag & KNH_FLAG_NUE_GCHOOK) == KNH_FLAG_NUE_GCHOOK)

#define knh_Nue_setGCHook(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_NUE_GCHOOK; else knh_Object_head(o)->flag &= ~(KNH_FLAG_NUE_GCHOOK);


#define knh_Nue_isObjectText(o)   ((knh_Object_head(o)->flag & KNH_FLAG_NUE_OBJECTTEXT) == KNH_FLAG_NUE_OBJECTTEXT)

#define knh_Nue_setObjectText(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_NUE_OBJECTTEXT; else knh_Object_head(o)->flag &= ~(KNH_FLAG_NUE_OBJECTTEXT);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Bool */

knh_Bool* knh_Bool_cast(Ctx *ctx, Object *b);
knh_Bool* knh_Bool_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Int */

knh_Int* knh_Int_cast(Ctx *ctx, Object *b);
knh_Int* knh_Int_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Float */

knh_Float* knh_Float_cast(Ctx *ctx, Object *b);
knh_Float* knh_Float_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Long */

knh_Long* knh_Long_cast(Ctx *ctx, Object *b);
knh_Long* knh_Long_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_String */

knh_String* knh_String_cast(Ctx *ctx, Object *b);
knh_String* knh_String_castOrNull(Ctx *ctx, Object *b);

#define knh_String_isSTEXT(o)   ((knh_Object_head(o)->flag & KNH_FLAG_STRING_STEXT) == KNH_FLAG_STRING_STEXT)

#define knh_String_setSTEXT(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_STRING_STEXT; else knh_Object_head(o)->flag &= ~(KNH_FLAG_STRING_STEXT);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Bytes */

knh_Bytes* knh_Bytes_cast(Ctx *ctx, Object *b);
knh_Bytes* knh_Bytes_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Regex */

knh_Regex* knh_Regex_cast(Ctx *ctx, Object *b);
knh_Regex* knh_Regex_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Array */

knh_Array* knh_Array_cast(Ctx *ctx, Object *b);
knh_Array* knh_Array_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_HashMap */

knh_HashMap* knh_HashMap_cast(Ctx *ctx, Object *b);
knh_HashMap* knh_HashMap_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_HashSet */

knh_HashSet* knh_HashSet_cast(Ctx *ctx, Object *b);
knh_HashSet* knh_HashSet_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_DictMap */

knh_DictMap* knh_DictMap_cast(Ctx *ctx, Object *b);
knh_DictMap* knh_DictMap_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_DictSet */

knh_DictSet* knh_DictSet_cast(Ctx *ctx, Object *b);
knh_DictSet* knh_DictSet_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Iterator */

knh_Iterator* knh_Iterator_cast(Ctx *ctx, Object *b);
knh_Iterator* knh_Iterator_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_DictIdx */

knh_DictIdx* knh_DictIdx_cast(Ctx *ctx, Object *b);
knh_DictIdx* knh_DictIdx_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Class */

knh_Class* knh_Class_cast(Ctx *ctx, Object *b);
knh_Class* knh_Class_castOrNull(Ctx *ctx, Object *b);

#define knh_Class_isRelease(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_RELEASE) == KNH_FLAG_CF_RELEASE)

#define knh_Class_isDebug(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_RELEASE) != KNH_FLAG_CF_RELEASE)

#define knh_Class_isImmutable(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_IMMUTABLE) == KNH_FLAG_CF_IMMUTABLE)

#define knh_Class_isMetaExtensible(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_METAEXTENSIBLE) == KNH_FLAG_CF_METAEXTENSIBLE)

#define knh_Class_isPrivate(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_PRIVATE) == KNH_FLAG_CF_PRIVATE)

#define knh_Class_isPublic(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_PRIVATE) != KNH_FLAG_CF_PRIVATE)

#define knh_Class_isFinal(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_FINAL) == KNH_FLAG_CF_FINAL)

#define knh_Class_isStrict(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_STRICT) == KNH_FLAG_CF_STRICT)

#define knh_Class_isSystem(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_SYSTEM) == KNH_FLAG_CF_SYSTEM)

#define knh_Class_isNullObject(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_NULLOBJECT) == KNH_FLAG_CF_NULLOBJECT)

#define knh_Class_isNA(o)   ((knh_tclass_table(knh_Class_cid(o))->cflag & KNH_FLAG_CF_NA) == KNH_FLAG_CF_NA)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_ClassStruct */

knh_ClassStruct* knh_ClassStruct_cast(Ctx *ctx, Object *b);
knh_ClassStruct* knh_ClassStruct_castOrNull(Ctx *ctx, Object *b);

#define knh_ClassStruct_isHidden(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_HIDDEN) == KNH_FLAG_CFF_HIDDEN)

#define knh_ClassStruct_setHidden(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_HIDDEN; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_HIDDEN);


#define knh_ClassStruct_isAutoName(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_AUTONAME) == KNH_FLAG_CFF_AUTONAME)

#define knh_ClassStruct_setAutoName(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_AUTONAME; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_AUTONAME);


#define knh_ClassStruct_isSafeValue(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_SAFEVALUE) == KNH_FLAG_CFF_SAFEVALUE)

#define knh_ClassStruct_setSafeValue(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_SAFEVALUE; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_SAFEVALUE);


#define knh_ClassStruct_isProtected(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_PROTECTED) == KNH_FLAG_CFF_PROTECTED)

#define knh_ClassStruct_setProtected(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_PROTECTED; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_PROTECTED);


#define knh_ClassStruct_isGetter(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_GETTER) == KNH_FLAG_CFF_GETTER)

#define knh_ClassStruct_setGetter(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_GETTER; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_GETTER);


#define knh_ClassStruct_isSetter(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_SETTER) == KNH_FLAG_CFF_SETTER)

#define knh_ClassStruct_setSetter(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_SETTER; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_SETTER);


#define knh_ClassStruct_isKey(o,n)   ((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_KEY) == KNH_FLAG_CFF_KEY)

#define knh_ClassStruct_setKey(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_KEY; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_KEY);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_MethodField */

knh_MethodField* knh_MethodField_cast(Ctx *ctx, Object *b);
knh_MethodField* knh_MethodField_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Method */

knh_Method* knh_Method_cast(Ctx *ctx, Object *b);
knh_Method* knh_Method_castOrNull(Ctx *ctx, Object *b);

#define knh_Method_isPublic(o)   ((((Method*)o)->flag & KNH_FLAG_MF_PUBLIC) == KNH_FLAG_MF_PUBLIC)

#define knh_Method_isPrivate(o)   ((((Method*)o)->flag & KNH_FLAG_MF_PUBLIC) != KNH_FLAG_MF_PUBLIC)

#define knh_Method_setPublic(o,b)  \
	if(b) ((Method*)o)->flag |= KNH_FLAG_MF_PUBLIC; else ((Method*)o)->flag &= ~(KNH_FLAG_MF_PUBLIC);


#define knh_Method_setPrivate(o,b)  \
	if(b) ((Method*)o)->flag &= ~(KNH_FLAG_MF_PUBLIC); else ((Method*)o)->flag |= KNH_FLAG_MF_PUBLIC;


#define knh_Method_isVirtual(o)   ((((Method*)o)->flag & KNH_FLAG_MF_VIRTUAL) == KNH_FLAG_MF_VIRTUAL)

#define knh_Method_isFinal(o)   ((((Method*)o)->flag & KNH_FLAG_MF_VIRTUAL) != KNH_FLAG_MF_VIRTUAL)

#define knh_Method_setVirtual(o,b)  \
	if(b) ((Method*)o)->flag |= KNH_FLAG_MF_VIRTUAL; else ((Method*)o)->flag &= ~(KNH_FLAG_MF_VIRTUAL);


#define knh_Method_setFinal(o,b)  \
	if(b) ((Method*)o)->flag &= ~(KNH_FLAG_MF_VIRTUAL); else ((Method*)o)->flag |= KNH_FLAG_MF_VIRTUAL;


#define knh_Method_isStatic(o)   ((((Method*)o)->flag & KNH_FLAG_MF_STATIC) == KNH_FLAG_MF_STATIC)

#define knh_Method_isVarArgs(o)   ((((Method*)o)->mf->flag & KNH_FLAG_MF_VARARGS) == KNH_FLAG_MF_VARARGS)

#define knh_Method_setVarArgs(o,b)  \
	if(b) ((Method*)o)->mf->flag |= KNH_FLAG_MF_VARARGS; else ((Method*)o)->mf->flag &= ~(KNH_FLAG_MF_VARARGS);


#define knh_Method_isAspect(o)   ((((Method*)o)->mf->flag & KNH_FLAG_MF_ASPECT) == KNH_FLAG_MF_ASPECT)

#define knh_Method_setAspect(o,b)  \
	if(b) ((Method*)o)->mf->flag |= KNH_FLAG_MF_ASPECT; else ((Method*)o)->mf->flag &= ~(KNH_FLAG_MF_ASPECT);


#define knh_Method_isObjectCode(o)   ((((Method*)o)->flag & KNH_FLAG_MF_OBJECTCODE) == KNH_FLAG_MF_OBJECTCODE)

#define knh_Method_setObjectCode(o,b)  \
	if(b) ((Method*)o)->flag |= KNH_FLAG_MF_OBJECTCODE; else ((Method*)o)->flag &= ~(KNH_FLAG_MF_OBJECTCODE);


#define knh_Method_isGenerated(o)   ((((Method*)o)->mf->flag & KNH_FLAG_MF_GENERATED) == KNH_FLAG_MF_GENERATED)

#define knh_Method_setGenerated(o,b)  \
	if(b) ((Method*)o)->mf->flag |= KNH_FLAG_MF_GENERATED; else ((Method*)o)->mf->flag &= ~(KNH_FLAG_MF_GENERATED);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_MapMap */

knh_MapMap* knh_MapMap_cast(Ctx *ctx, Object *b);
knh_MapMap* knh_MapMap_castOrNull(Ctx *ctx, Object *b);

#define knh_MapMap_isInterface(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_INTERFACE) == KNH_FLAG_MMF_INTERFACE)

#define knh_MapMap_setInterface(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_INTERFACE; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_INTERFACE);


#define knh_MapMap_isSignificant(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_SIGNIFICANT) == KNH_FLAG_MMF_SIGNIFICANT)

#define knh_MapMap_setSignificant(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_SIGNIFICANT; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_SIGNIFICANT);


#define knh_MapMap_isSynonym(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_SYNONYM) == KNH_FLAG_MMF_SYNONYM)

#define knh_MapMap_setSynonym(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_SYNONYM; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_SYNONYM);


#define knh_MapMap_isLossLess(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_LOSSLESS) == KNH_FLAG_MMF_LOSSLESS)

#define knh_MapMap_setLossLess(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_LOSSLESS; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_LOSSLESS);


#define knh_MapMap_isTotal(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_TOTAL) == KNH_FLAG_MMF_TOTAL)

#define knh_MapMap_isPartial(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_TOTAL) != KNH_FLAG_MMF_TOTAL)

#define knh_MapMap_setTotal(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_TOTAL; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_TOTAL);


#define knh_MapMap_setPartial(o,b)  \
	if(b) ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_TOTAL); else ((MapMap*)o)->flag |= KNH_FLAG_MMF_TOTAL;


#define knh_MapMap_isStatic(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_STATIC) == KNH_FLAG_MMF_STATIC)

#define knh_MapMap_isTemporal(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_STATIC) != KNH_FLAG_MMF_STATIC)

#define knh_MapMap_setStatic(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_STATIC; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_STATIC);


#define knh_MapMap_setTemporal(o,b)  \
	if(b) ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_STATIC); else ((MapMap*)o)->flag |= KNH_FLAG_MMF_STATIC;


#define knh_MapMap_isLocal(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_LOCAL) == KNH_FLAG_MMF_LOCAL)

#define knh_MapMap_setLocal(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_LOCAL; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_LOCAL);


#define knh_MapMap_isDerived(o)   ((((MapMap*)o)->flag & KNH_FLAG_MMF_DERIVED) == KNH_FLAG_MMF_DERIVED)

#define knh_MapMap_setDerived(o,b)  \
	if(b) ((MapMap*)o)->flag |= KNH_FLAG_MMF_DERIVED; else ((MapMap*)o)->flag &= ~(KNH_FLAG_MMF_DERIVED);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_ClassRel */

knh_ClassRel* knh_ClassRel_cast(Ctx *ctx, Object *b);
knh_ClassRel* knh_ClassRel_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Closure */

knh_Closure* knh_Closure_cast(Ctx *ctx, Object *b);
knh_Closure* knh_Closure_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_IntUnit */

knh_IntUnit* knh_IntUnit_cast(Ctx *ctx, Object *b);
knh_IntUnit* knh_IntUnit_castOrNull(Ctx *ctx, Object *b);

#define knh_IntUnit_isUnsigned(o)   ((((IntUnit*)o)->spec.flag & KNH_FLAG_UF_UNSIGNED) == KNH_FLAG_UF_UNSIGNED)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_FloatUnit */

knh_FloatUnit* knh_FloatUnit_cast(Ctx *ctx, Object *b);
knh_FloatUnit* knh_FloatUnit_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Vocabulary */

knh_Vocabulary* knh_Vocabulary_cast(Ctx *ctx, Object *b);
knh_Vocabulary* knh_Vocabulary_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_AffineConv */

knh_AffineConv* knh_AffineConv_cast(Ctx *ctx, Object *b);
knh_AffineConv* knh_AffineConv_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_StreamStat */

knh_StreamStat* knh_StreamStat_cast(Ctx *ctx, Object *b);
knh_StreamStat* knh_StreamStat_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_InputStream */

knh_InputStream* knh_InputStream_cast(Ctx *ctx, Object *b);
knh_InputStream* knh_InputStream_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_OutputStream */

knh_OutputStream* knh_OutputStream_cast(Ctx *ctx, Object *b);
knh_OutputStream* knh_OutputStream_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Writer */

knh_Writer* knh_Writer_cast(Ctx *ctx, Object *b);
knh_Writer* knh_Writer_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_MovableText */

knh_MovableText* knh_MovableText_cast(Ctx *ctx, Object *b);
knh_MovableText* knh_MovableText_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Exception */

knh_Exception* knh_Exception_cast(Ctx *ctx, Object *b);
knh_Exception* knh_Exception_castOrNull(Ctx *ctx, Object *b);

#define knh_Exception_isFatal(o)   ((((Exception*)o)->flag & KNH_FLAG_EF_FATAL) == KNH_FLAG_EF_FATAL)

#define knh_Exception_isLogging(o)   ((((Exception*)o)->flag & KNH_FLAG_EF_LOGGING) == KNH_FLAG_EF_LOGGING)

#define knh_Exception_isGenerated(o)   ((((Exception*)o)->flag & KNH_FLAG_EF_GENERATED) == KNH_FLAG_EF_GENERATED)

#define knh_Exception_isCaught(o)   ((((Exception*)o)->flag & KNH_FLAG_EF_CAUGHT) == KNH_FLAG_EF_CAUGHT)

#define knh_Exception_setCaught(o,b)  \
	if(b) ((Exception*)o)->flag |= KNH_FLAG_EF_CAUGHT; else ((Exception*)o)->flag &= ~(KNH_FLAG_EF_CAUGHT);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_System */

knh_System* knh_System_cast(Ctx *ctx, Object *b);
knh_System* knh_System_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_NameSpace */

knh_NameSpace* knh_NameSpace_cast(Ctx *ctx, Object *b);
knh_NameSpace* knh_NameSpace_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Runtime */

knh_Runtime* knh_Runtime_cast(Ctx *ctx, Object *b);
knh_Runtime* knh_Runtime_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Context */

knh_Context* knh_Context_cast(Ctx *ctx, Object *b);
knh_Context* knh_Context_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_ExceptionHandler */

knh_ExceptionHandler* knh_ExceptionHandler_cast(Ctx *ctx, Object *b);
knh_ExceptionHandler* knh_ExceptionHandler_castOrNull(Ctx *ctx, Object *b);

#define knh_ExceptionHandler_isCatching(o)   ((knh_Object_head(o)->flag & KNH_FLAG_EHF_CATCHING) == KNH_FLAG_EHF_CATCHING)

#define knh_ExceptionHandler_setCatching(o,b)  \
	if(b) knh_Object_head(o)->flag |= KNH_FLAG_EHF_CATCHING; else knh_Object_head(o)->flag &= ~(KNH_FLAG_EHF_CATCHING);


/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Mutex */

knh_Mutex* knh_Mutex_cast(Ctx *ctx, Object *b);
knh_Mutex* knh_Mutex_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* knh_Amazon */

knh_Amazon* knh_Amazon_cast(Ctx *ctx, Object *b);
knh_Amazon* knh_Amazon_castOrNull(Ctx *ctx, Object *b);

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* knh_AffineConv.c */
#define knh_AffineConv_struct_copy      NULL
#define knh_AffineConv_struct_compare   NULL
#define knh_AffineConv_struct_traverse  NULL



void knh_AffineConv_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);

AffineConv *new_AffineConv(Ctx *ctx, knh_float_t fa, knh_float_t fb);

Object *knh_AffineConv_fmap__ftof(Ctx *ctx, Object *self, MapMap *map);
Object *knh_AffineConv_fmap__itof(Ctx *ctx, Object *self, MapMap *map);
Object *knh_AffineConv_fmap__ftoi(Ctx *ctx, Object *self, MapMap *map);
Object *knh_AffineConv_fmap__itoi(Ctx *ctx, Object *self, MapMap *map);
f_mapmap knh_AffineConv_fmap(Ctx *ctx, AffineConv *b, knh_class_t scpid, knh_class_t tpcid);
MapMap *new_MapMap_inv__AffineConv(Ctx *ctx, MapMap *map);



/* ======================================================================== */
/* knh_Amazon.c */
#define knh_Amazon_struct_copy      NULL
#define knh_Amazon_struct_compare   NULL
#define knh_Amazon_struct_traverse  NULL



void knh_Amazon_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);

Amazon *new_Amazon(Ctx *ctx);
Object *knh_Amazon_fvalue(Ctx *ctx, knh_class_t cid);

void knh_Amazon_placeOrder(Ctx *ctx, Amazon *b, String *uname, String *order);
void knh_security_RBAC(Ctx *ctx, Object **sfp);
void knh_security_Audit(Ctx *ctx, Object **sfp);
void knh_Method_weave(Ctx *ctx, Method *b, f_method f);
void knh_weave(Ctx *ctx, f_method f, Method *mtd);



/* ======================================================================== */
/* knh_Array.c */
#define knh_Array_size(a)     (a)->size
#define knh_Array_n(a,n)      (a)->list[(n)]
#define KNH_ARRAY_RESIZE(ctx, TYPE, array, oldsize, newsize) \
	if(newsize != 0 && newsize != oldsize) { \
		TYPE *newarray = (TYPE *)knh_malloc(ctx, KNH_SIZE(sizeof(TYPE) * newsize)); \
		if(newsize < oldsize) { \
			knh_memcpy(newarray, array, (sizeof(TYPE) * newsize)); \
		}else { \
			knh_memcpy(newarray, array, (sizeof(TYPE) * oldsize)); \
		} \
		knh_free(array, KNH_SIZE(sizeof(TYPE) * oldsize)); \
		array = newarray; \
		oldsize = newsize; \
	} \


#define knh_Array_setn(ctx,b,n,v) knh_Array_set__fast(ctx,b,n,v)
#define knh_Array_append(ctx,b,n) knh_Array_add__fast(ctx,b,n)





void knh_Array_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Array_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Array_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_Array_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Array* knh_Array_new(Ctx *ctx, Array *b, size_t initialCapacity);
Array* new_Array(Ctx *ctx, size_t capacity);
Object* knh_Array_fvalue(Ctx *ctx, knh_class_t cid);
Array* knh_Array_new__init(Ctx *ctx, Array *b, knh_vargc_t n, Any **v);

Object** knh_Array_list(Array *b);
Object* knh_Array_last(Array *b);
void knh_Array_subclear(Ctx *ctx, Array *b, size_t n);

size_t knh_array_index(knh_int_t n, size_t size);
size_t knh_Array_util_slice(knh_int_t n, size_t size);

Any* knh_Array_get__fast(Array *b, size_t index);
void knh_Array_set__fast(Ctx *ctx, Array *b, size_t index, Object *value);
Any* knh_Array_get(Array *b, knh_int_t index);
void knh_Array_set(Ctx *ctx, Array *b, knh_int_t index, Any *value);
void knh_Array_resize(Ctx *ctx, Array *b, size_t newsize);
void knh_Array_add__fast(Ctx *ctx, Array *b, Any *value);
void knh_Array_add(Ctx *ctx, Array *b, Any *value);
Any* knh_Array_pop(Ctx *ctx, Array *b);
Array *knh_Array_slice(Ctx *ctx, Array *b, knh_int_t start, knh_int_t end);
void knh_Array_swap(Array *b, knh_int_t n, knh_int_t n2);
void knh_Array_clear(Ctx *ctx, Array *b);

knh_bool_t knh_array_isdump(size_t c);
void knh_Array__dump(Ctx *ctx, Array *b, Writer *w, Any *m);

Object* knh_Array_var_next(Ctx *ctx, Iterator *it);
Object* knh_Array_Iterator(Ctx *ctx, Object *self, MapMap *map);



/* ======================================================================== */
/* knh_Bool.c */
#define True                knh_Bool_TRUE()
#define False               knh_Bool_FALSE()
#define IS_TRUE(o)          (o != False && IS_NOTNULL(o))
#define IS_FALSE(o)         (o == False || IS_NULL(o))
#define new_Bool(ctx,b)     ((b == 0) ? knh_Bool_FALSE() : knh_Bool_TRUE())
#define knh_Bool_struct_traverse NULL




void knh_Bool_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_Bool_struct_copy(Ctx *ctx, Struct *s, Struct *s2);
knh_int_t knh_Bool_struct_compare(Ctx *ctx, Struct *s, Struct *s2);

Object* knh_Bool_String(Ctx *ctx, Object *self, MapMap *map);

void knh_Bool__s(Ctx *ctx, Bool *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Bytes.c */
#define knh_Bytes_size(o)      (o)->size
#define knh_Bytes_value(o)     (o)->value
#define knh_Bytes_tochar(b)  (char*)knh_Bytes_value(b)




void knh_Bytes_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Bytes_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Bytes_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_Bytes_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Bytes* knh_Bytes_new(Ctx *ctx, Bytes *b, size_t initialCapacity);
Bytes* new_Bytes(Ctx *ctx, size_t capacity);
Object* knh_Bytes_fvalue(Ctx *ctx, knh_class_t cid);

knh_bytes_t knh_Bytes_tobytes(Bytes *b);
knh_uchar_t *knh_Bytes_last(Bytes *b);
void knh_Bytes_resize(Ctx *ctx, Bytes *b, size_t newsize);
void knh_Bytes_clear(Bytes *b);
void knh_Bytes_putc(Ctx *ctx, Bytes *b, int_byte_t ch);
void knh_Bytes_write(Ctx *ctx, Bytes *b, knh_bytes_t v);
void knh_Bytes_unputc(Bytes *b);

Object* knh_Bytes_String(Ctx *ctx, Object *self, MapMap *map);
Object* knh_String_Bytes(Ctx *ctx, Object *self, MapMap *map);




/* ======================================================================== */
/* knh_Bytes_byte_t.c */
#define KNH_SIZE(v)         knh_size(v)
#define B(c)     new_bytes(c)
#define B2(c,n)   new_bytes__2(c,n)
#define STEXT(c)  new_bytes__2(c,sizeof(c)-1)
#define TEXT(c)   new_bytes__2(c,sizeof(c)-1)
#define ISB(t,c) (t.len == (sizeof(c)-1) && knh_strncmp((char*)t.buf,c,t.len) == 0)




size_t knh_size(size_t s);
size_t knh_strlen(void *c);
void knh_memcpy(void *d, void *s, size_t n);
void knh_bzero(void *s, size_t n);
knh_int_t knh_strcmp(char *s1, char *s2);
knh_int_t knh_strncmp(char *s1, char *s2, size_t n);
knh_int_t knh_bytes_strcmp(knh_bytes_t v1, knh_bytes_t v2);
knh_bool_t knh_bytes_equals(knh_bytes_t v1, knh_bytes_t v2);
knh_bool_t knh_bytes_startsWith(knh_bytes_t v1, knh_bytes_t v2);
knh_bool_t knh_bytes_endsWith(knh_bytes_t v1, knh_bytes_t v2);
knh_index_t knh_bytes_index(knh_bytes_t v, knh_int_t ch);
knh_index_t knh_bytes_rindex(knh_bytes_t v, knh_int_t ch);
knh_bytes_t knh_bytes_first(knh_bytes_t t, knh_int_t loc);
knh_bytes_t knh_bytes_last(knh_bytes_t t, knh_int_t loc);
knh_bytes_t knh_bytes_trim(knh_bytes_t t, knh_int_t ch);

knh_bytes_t new_bytes(char *c);
knh_bytes_t new_bytes__2(void *buf, size_t len);

knh_int_t knh_bytes_toint(knh_bytes_t t);
knh_float_t knh_bytes_tofloat(knh_bytes_t t);
knh_int_t knh_bytes_tolong(knh_bytes_t t);



/* ======================================================================== */
/* knh_Class.c */
#define CLASS_Object         ((knh_class_t)0)
#define CLASS_newid          ((knh_class_t)-1)
#define CLASS_unknown        ((knh_class_t)-2)
#define CLASS_any            CLASS_Prototype
#define CLASS_any__          CLASS_TOPLURAL(CLASS_Prototype)
#define CLASS_Any            CLASS_Prototype
#define knh_Class_type(c)     (c)->type
#define knh_Class_class(c)    TYPE_UNMASK_NULL((c)->type)
#define knh_Class_bcid(c)     (c)->bcid
#define knh_Class_struct_copy   NULL
#define knh_Class_struct_traverse   NULL




void knh_Class_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
knh_int_t knh_Class_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);

Class* new_Class__base(Ctx *ctx, knh_class_t bcid, knh_class_t cid);
Class* new_Class__type(Ctx *ctx, knh_type_t type);

knh_class_t knh_Class_cid(Class *b);


Object* knh_Class_null_next(Ctx *ctx, Iterator *it);

void knh_Class__s(Ctx *ctx, knh_type_t type, Writer *w, Any *m);
void knh_Class__dump(Ctx *ctx, knh_type_t type, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Class_spec_t.c */
#define IS_SPEC(o)                (CLASS_IntUnit <= knh_Object_cid(o)  && knh_Object_cid(o) <= CLASS_Vocabulary)







/* ======================================================================== */
/* knh_Class_type_t.c */
#define KNH_FLAG_TF_NULLABLE        KNH_FLAG_T0
#define KNH_FLAG_TF_PLURAL          KNH_FLAG_T1
#define CLASS_TONULLABLE(c)        (c|KNH_FLAG_TF_NULLABLE)
#define CLASS_TOPLURAL(c)          (c|KNH_FLAG_TF_PLURAL)
#define TYPE_ISBASE(t)             (t < KONOHA_TCLASS_SIZE)    /* new_Class_type.c */
#define TYPE_ISNULLABLE(t)         ((t & KNH_FLAG_TF_NULLABLE)==KNH_FLAG_TF_NULLABLE)
#define TYPE_ISNOTNULL(t)          ((t & KNH_FLAG_TF_NULLABLE)==0)
#define TYPE_ISPLURAL(t)           ((t & KNH_FLAG_TF_PLURAL)==KNH_FLAG_TF_PLURAL)
#define KNH_TYPE_MASK               (KNH_FLAG_TF_NULLABLE|KNH_FLAG_TF_PLURAL)
#define KNH_CLASS_MASK              (~(KNH_TYPE_MASK))
#define TYPE_UNMASK(t)              (t & KNH_CLASS_MASK)
#define TYPE_UNMASK_NULL(t)         (t&(~KNH_FLAG_TF_NULLABLE))
#define TYPE_TONOTNULL(t)           (t&(~KNH_FLAG_TF_NULLABLE))
#define TYPE_COPY(t,t2)             ((t & KNH_TYPE_MASK) | t2) 
#define TYPEQN(t)                TYPEN(t), TYPEQ(t)
#define CLASSQN(t)               CLASSN(TYPE_UNMASK(t)), knh_CLASSQ(t)
#define TYPE_Any                 CLASS_TONULLABLE(CLASS_any)
#define TYPE_any                 CLASS_TONULLABLE(CLASS_any)
#define TYPE_any__               CLASS_Iterator
#define TYPE_any__               CLASS_Iterator
#define TYPE_void                CLASS_TONULLABLE(CLASS_Object)
#define TYPE_Object              CLASS_TONULLABLE(CLASS_Object)
#define TYPE_Object__            CLASS_Iterator
#define TYPE_Tuple               CLASS_TONULLABLE(CLASS_Tuple)
#define TYPE_Tuple__             CLASS_TOPLURAL(CLASS_Tuple)
#define TYPEN(type)  knh_TYPEN(ctx,type)



knh_class_t knh_type_toclass(knh_type_t t);

knh_bool_t knh_bytes_isPluralType(knh_bytes_t t);
knh_bool_t knh_bytes_isNotNullType(knh_bytes_t t);
knh_int_t knh_type_compare(Ctx *ctx, knh_type_t t1, knh_type_t t2);

char *TYPEQ(knh_type_t type);
char *knh_TYPEN(Ctx *ctx, knh_type_t type);
char *knh_CLASSQ(knh_type_t type);



/* ======================================================================== */
/* knh_ClassRel.c */
#define knh_ClassRel_struct_copy    NULL
#define knh_ClassRel_struct_compare  NULL



void knh_ClassRel_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_ClassRel_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

ClassRel* new_ClassRel(Ctx *ctx, knh_ushort_t capacity);
void knh_ClassRel_resize(Ctx *ctx, ClassRel *b, size_t newsize);
int knh_ClassRel_util_cmp(const MapMap *m1, const MapMap *m2);
void knh_ClassRel_sort(Ctx *ctx, ClassRel *b);
void knh_ClassRel_add(Ctx *ctx, ClassRel *b, MapMap *map);

MapMapNULL *knh_ClassRel_find__first(ClassRel *b, knh_class_t tcid);
MapMapNULL *knh_ClassRel_findp__first(ClassRel *b, knh_class_t tcid);



void knh_ClassRel__dump(Ctx *ctx, ClassRel *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_ClassStruct.c */
#define knh_tstruct_isNative(sid)   (sid < KONOHA_TSTRUCT_SIZE)
#define knh_ClassStruct_struct_copy    NULL
#define knh_ClassStruct_struct_compare NULL
#define knh_Class_getMethod(ctx, c, mn)    knh_Class_getMethod__(ctx, c, mn, 0)
#define knh_Class_findMethod(ctx, c, mn)   knh_Class_getMethod__(ctx, c, mn, 1)




void knh_ClassStruct_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_ClassStruct_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

ClassStruct* new_ClassStruct(Ctx *ctx, knh_struct_t sid);

void knh_cfield_safetype(knh_cfield_t *cf);
Object *knh_cfield_safevalue(Ctx *ctx, knh_cfield_t *cf);

knh_index_t knh_Class_initField(Ctx *ctx, knh_class_t cid, knh_flag_t flag, knh_type_t type, knh_fieldn_t fn, Object *value);
knh_index_t knh_Class_indexOfField(knh_class_t cid, knh_fieldn_t fn);
knh_index_t knh_Class_queryField(knh_class_t cid, knh_fieldn_t fnq);
knh_cfield_t *knh_Class_fieldAt(knh_class_t cid, size_t n);
Object *knh_ClassStruct_safevalue(Ctx *ctx, ClassStruct *b, size_t n);

void knh_Class_addMethod__fast(Ctx *ctx, knh_class_t cid, Method *method);
void knh_Class_addMethod(Ctx *ctx, knh_class_t cid, Method *method);
Method* knh_Class_getMethod__(Ctx *ctx, knh_class_t this_cid, knh_methodn_t mn, knh_bool_t gen);

void knh__ClassStruct_fmethodGetter(Ctx *ctx, Object **sf);
void knh__ClassStruct_fmethodSetter(Ctx *ctx, Object **sf);
MethodField* new_MethodField__getter(Ctx *ctx, knh_type_t type);
MethodField* new_MethodField__setter(Ctx *ctx, knh_type_t type, knh_fieldn_t fn);

void knh_cfield_dump(Ctx *ctx, knh_cfield_t *f, size_t offset, size_t fsize, Writer *w);



/* ======================================================================== */
/* knh_Closure.c */

Closure* new_Closure(Ctx *ctx, Object *self, Method *method);



/* ======================================================================== */
/* knh_Context.c */
#define StdOut    (((Context*)ctx)->out)
#define knh_Context_struct_copy   NULL
#define knh_Context_struct_compare  NULL




void knh_Context_struct_init(Ctx *ctx0, Struct *s, int init, Object *cs);
void knh_Context_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Context* new_Context(Ctx *ctx0, Runtime *runtime, String *name, size_t size);
Object* knh_Context_fvalue(Ctx *ctx, knh_class_t cid);

Any* knh_Context_getProperty(Ctx *ctx, Context *b, knh_bytes_t key);
void knh_Context_setProperty(Ctx *ctx, Context *b, String *key, Any *value);

void knh_Context__dump(Ctx *ctx, Context *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Context_buffer.c */

knh_bytes_t knh_Bytes_firstbyte(Bytes *b, size_t pos);
knh_bytes_t knh_Bytes_lastbyte(Bytes *b, size_t pos);
size_t knh_Bytes_lastsize(Bytes *b, size_t pos);
void knh_Bytes_subclear(Bytes *b, size_t pos);

String *new_String__buffer(Ctx *ctx, knh_class_t cid, knh_buffer_t cb);

knh_buffer_t knh_Context_buffer(Ctx* ctx);
void knh_buffer_size(knh_buffer_t cb);
knh_bytes_t knh_buffer_tobytes(knh_buffer_t cb);
void knh_buffer_clear(knh_buffer_t cb);



/* ======================================================================== */
/* knh_DictIdx.c */
#define knh_DictIdx_struct_copy   NULL
#define knh_DictIdx_struct_compare  NULL



void knh_DictIdx_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_DictIdx_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

DictIdx* new_DictIdx(Ctx *ctx, size_t initialCapacity, knh_int_t offset);

knh_index_t knh_DictIdx_index(Ctx *ctx, DictIdx *b, knh_bytes_t v);
knh_index_t knh_DictIdx_add__fast(Ctx *ctx, DictIdx *b, String *term);
knh_index_t knh_DictIdx_add(Ctx *ctx, DictIdx *b, String *term);
knh_index_t knh_DictIdx_add__b(Ctx *ctx, DictIdx *b, knh_bytes_t term);
String* knh_DictIdx_get__fast(DictIdx *b, knh_int_t termid);
String* knh_DictIdx_get(DictIdx *b, knh_int_t termid);
void knh_DictIdx_clear(Ctx *ctx, DictIdx *b);

Object* knh_DictIdx_Iterator(Ctx *ctx, Object *self, MapMap *map);

void knh_DictIdx__dump(Ctx *ctx, DictIdx *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_DictMap.c */
#define knh_DictMap_put(ctx,b,k,v) knh_DictMap_set(ctx,b,k,v)
#define knh_DictMap_put(ctx,b,k,v) knh_DictMap_set(ctx,b,k,v)
#define knh_DictMap_String__   knh_DictMap_Iterator



void knh_DictMap_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_DictMap_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_DictMap_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_DictMap_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

DictMap* new_DictMap(Ctx *ctx0, knh_int_t capacity);
DictMap *knh_DictMap_new(Ctx *ctx, DictMap *b, knh_int_t initialCapacity);
DictMap* knh_DictMap_new__init(Ctx *ctx, DictMap *b, knh_vargc_t ac, Object **a);

int knh_DictMap_util_cmp(const knh_dictmape_t *n1, const knh_dictmape_t *n2);
void knh_DictMap_sort(DictMap *b);
	 knh_int_t knh_DictMap_findb_between(DictMap *b, knh_bytes_t kv, size_t sp, size_t ep);
knh_index_t knh_DictMap_indexb(DictMap *b, knh_bytes_t kv);

String* knh_DictMaps_key(DictMap *b, size_t n);
Any* knh_DictMaps_value(DictMap *b, size_t n);
Any *knh_DictMap_getb(Ctx *ctx, DictMap *b, knh_bytes_t key);
Any *knh_DictMap_get(Ctx *ctx, DictMap *b, String *key);
void knh_DictMap_resize(Ctx *ctx, DictMap *b, size_t newsize);
void knh_DictMap_append(Ctx *ctx, DictMap *b, String *key, Any *value);
void knh_DictMap_set(Ctx *ctx, DictMap *b, String *key, Any *value);
void knh_DictMap_remove(Ctx *ctx, DictMap *b, String *key);
void knh_DictMap_clear(Ctx *ctx, DictMap *b);


Object *knh_DictMap_key_next(Ctx *ctx, Iterator *it);
Any* knh_DictMap_Iterator(Ctx *ctx, Object *self, MapMap *map);

void knh_DictMap__dump(Ctx *ctx, DictMap *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_DictSet.c */
#define knh_DictSet_put(ctx,b,k,v) knh_DictSet_set(ctx,b,k,v)



void knh_DictSet_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_DictSet_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_DictSet_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_DictSet_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

DictSet *new_DictSet(Ctx *ctx, knh_int_t capacity);
DictSet* knh_DictSet_new(Ctx *ctx, DictSet *b, knh_int_t initialCapacity);

void knh_DictSet_sort(DictSet *b);
knh_index_t knh_DictSet_index__b(DictSet *b, knh_bytes_t kv);

String* knh_DictSet_key(DictSet *b, size_t n);
knh_uint_t knh_DictSet_value(DictSet *b, size_t n);
knh_uint_t knh_DictSet_get__b(DictSet *b, knh_bytes_t kv);
knh_int_t knh_DictSet_get(DictSet *b, String *key);
knh_bool_t knh_DictSet_opIn(Ctx *ctx, DictSet *b, Any *value);
void knh_DictSet_resize(Ctx *ctx, DictSet *b, size_t newsize);
void knh_DictSet_append(Ctx *ctx, DictSet *b, String *key, knh_uint_t value);
void knh_DictSet_set(Ctx *ctx, DictSet *b, String *key, knh_uint_t value);
void knh_DictSet_add(Ctx *ctx, DictSet *b, String *key);
void knh_DictSet_clear(Ctx *ctx, DictSet *b);


Object* knh_DictSet_key_next(Ctx *ctx, Iterator *it);
Object* knh_DictSet_Iterator(Ctx *ctx, Object *self, MapMap *map);

void knh_DictSet__dump(Ctx *ctx, DictSet *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Exception.c */
#define EXPT_newid            ((knh_expt_t)0)
#define EXPT_Exception        ((knh_expt_t)1)
#define EXPT_NoSuchException  ((knh_expt_t)2)
#define knh_Exception_eid(o)   (o)->eid
#define knh_Exception_struct_copy   NULL
#define knh_Exception_struct_compare  NULL




void knh_Exception_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_Exception_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Exception* knh_Exception_new(Ctx *ctx, Exception *b, String *msg, Object *bag);
Exception* new_Exception(Ctx *ctx, String *msg);
Exception* new_Exception__b(Ctx *ctx, knh_bytes_t msg);
Exception* new_Exception__Nue(Ctx *ctx, Nue *nue);

Object* knh_Exception_var_next(Ctx *ctx, Iterator *it);
Object * knh_Exception_Iterator(Ctx *ctx, Object *self, MapMap *map);

void knh_Exception__s(Ctx *ctx, Exception *b, Writer *w, Any *m);
void knh_Exception__dump(Ctx *ctx, Exception *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_ExceptionHandler.c */
#define KNH_SETJUMP(hdlr)   setjmp(((ExceptionHandler*)hdlr)->jmpbuf)
#define knh_ExceptionHandler_struct_copy   NULL
#define knh_ExceptionHandler_struct_compare  NULL




void knh_ExceptionHandler_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_ExceptionHandler_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

ExceptionHandler* new_ExceptionHandler(Ctx *ctx);
Object *knh_ExceptionHandler_fvalue(Ctx *ctx, knh_class_t cid);

void knh_ExceptionHandler_longjmp(Context *ctx, ExceptionHandler *b, Exception *e);
Exception* knh_ExceptionHandler_getCaughtException(ExceptionHandler *b);




/* ======================================================================== */
/* knh_Float.c */
#define knh_Float_value(o)    (o)->value
#define knh_Float_struct_traverse NULL
#define new_Float(ctx, value) new_Float__fast(ctx, CLASS_Float, value)




void knh_Float_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Float_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Float_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);

Float* new_Float__fast(Ctx *ctx, knh_class_t cid, knh_float_t value);
Float* new_Float__checked(Ctx *ctx, knh_class_t cid, knh_float_t value);

knh_float_t knh_float_max(knh_float_t a, knh_float_t b);
knh_float_t knh_float_min(knh_float_t a, knh_float_t b);

Object* knh_String_Float(Ctx *ctx, Object *self, MapMap *map);
Object* knh_Float_String(Ctx *ctx, Object *self, MapMap *map);
Object* knh_Int_Float(Ctx *ctx, Object *self, MapMap *map);
Object* knh_Float_Int(Ctx *ctx, Object *self, MapMap *map);

knh_float_t knh_Float_opAdd(Float *b, knh_vargc_t ac, Float **v);
knh_float_t knh_Float_opSub(Float *b, knh_vargc_t ac, Float **v);
knh_float_t knh_Float_opMul(Float *b, knh_vargc_t ac, Float **v);
knh_float_t knh_Float_opDiv(Float *b, knh_vargc_t ac, Float **v);

void knh_Float__s(Ctx *ctx, Float *b, Writer *w, Any *m);
void knh_Float__dump(Ctx *ctx, Float *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_FloatUnit.c */
#define knh_FloatUnit_struct_copy    NULL
#define knh_FloatUnit_struct_compare NULL



void knh_FloatUnit_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_FloatUnit_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

FloatUnit *new_FloatUnit__STEXT(Ctx *ctx, knh_flag_t flag, knh_class_t cid, char *urn, char *tag, knh_float_t min, knh_float_t max, knh_float_t defvalue, knh_float_t step);

FloatUnit* knh_tclass_getFloatUnit(Ctx *ctx, knh_class_t cid);
FloatUnit *knh_Float_spec(Ctx *ctx);

void knh_FloatUnit_initId(Ctx *ctx, FloatUnit *b, knh_flag_t flag, knh_class_t cid, String *urn, String *tag);
void knh_FloatUnit_initStep(Ctx *ctx, FloatUnit *b, knh_float_t step);
void knh_FloatUnit_initMinMax(Ctx *ctx, FloatUnit *b, knh_float_t min, knh_float_t max);
void knh_FloatUnit_initDefaultValue(Ctx *ctx, FloatUnit *b, knh_float_t v);
knh_bool_t knh_FloatUnit_check(FloatUnit *b, knh_int_t value);
Float *new_Nue__asFloat(Ctx *ctx, knh_class_t cid, knh_float_t value);
Float *knh_FloatUnit_value(Ctx *ctx, FloatUnit *b, knh_float_t value);
knh_int_t knh_FloatUnit_compare(FloatUnit *b, knh_float_t v1, knh_float_t v2);
void knh_FloatUnit_format(FloatUnit *b, char *buf, knh_float_t v);

knh_bool_t knh_FloatUnit_fchk__default(FloatUnit *b, knh_float_t v);
knh_int_t knh_FloatUnit_fcmp__default(FloatUnit *b, knh_float_t v1, knh_float_t v2);
knh_int_t knh_FloatUnit_fcmp__step(FloatUnit *b, knh_float_t v1, knh_float_t v2);
void knh_FloatUnit_ffmt__default(FloatUnit *b, char *buf, knh_float_t v);

knh_bool_t knh_FloatUnit_fchk__min(FloatUnit *b, knh_float_t v);
knh_bool_t knh_FloatUnit_fchk__max(FloatUnit *b, knh_float_t v);
knh_bool_t knh_FloatUnit_fchk__range(FloatUnit *b, knh_float_t v);



/* ======================================================================== */
/* knh_HashMap.c */
#define knh_HashMap_struct_compare NULL
#define knh_HashMap_put(ctx,b,h,k,v) knh_HashMap_set(ctx,b,h,k,v)
#define knh_HashSet_key_next knh_HashMap_key_next



knh_hashmape_t *knh_HashMape_new(Ctx *ctx, knh_hcode_t key, Object *kobj, Object *value);
void knh_HashMape_traverse(Ctx *ctx, knh_hashmape_t *cur, f_gc gc);

void knh_HashMap_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_HashMap_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
void knh_HashMap_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

HashMap* new_HashMap(Ctx *ctx, size_t capacity);
HashMap *knh_HashMap_new(Ctx *ctx, HashMap *b, size_t initialCapacity);
HashMap* knh_HashMap_new__init(Ctx *ctx, HashMap *b, knh_vargc_t ac, Object **a);

Any *knh_HashMap_get(Ctx *ctx, HashMap *b, knh_hcode_t key, Any *kobj);
Object *knh_HashMap_get__b(HashMap *b, knh_bytes_t kv);
void knh_HashMap_rehash(Ctx *ctx, HashMap *b);
void knh_HashMap_resize(Ctx *ctx, HashMap *b, size_t nc);
void knh_HashMap_set(Ctx *ctx, HashMap *b, knh_hcode_t key, Any *kobj, Any *value);
void knh_HashMap_remove(Ctx *ctx, HashMap *b, knh_hcode_t key, Any *kobj);
knh_bool_t knh_HashMap_opIn(Ctx *ctx, HashMap *b, knh_hcode_t key, Any *keyobj);


knh_hashmape_t * knh_HashMape_next(Ctx *ctx, Iterator *it);
Object* knh_HashMap_key_next(Ctx *ctx, Iterator *it);
Iterator *knh_HashMap_keys(Ctx *ctx, HashMap *b);
Object* knh_HashMap_Iterator(Ctx *ctx, Object *self, MapMap *map);
Object *knh_HashMap_tuple2_next(Ctx *ctx, Iterator *it);
Object* knh_HashMap_Tuple2__(Ctx *ctx, Object *self, MapMap *map);

void knh_HashMap__dump(Ctx *ctx, HashMap *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_HashSet.c */
#define knh_HashSet_struct_compare NULL
#define knh_HashSet_put(ctx,b,h,k,v) knh_HashSet_set(ctx,b,h,k,v)



knh_hashsete_t *knh_HashSete_new(Ctx *ctx, knh_hcode_t key, Object *keyobj, knh_uint_t value);
void knh_HashSete_traverse(Ctx *ctx, knh_hashsete_t *cur, f_gc gc);

void knh_HashSet_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_HashSet_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
void knh_HashSet_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

HashSet* new_HashSet(Ctx *ctx, size_t capacity);
HashSet *knh_HashSet_new(Ctx *ctx, HashSet *b, size_t initialCapacity);

void knh_HashSet_rehash(Ctx *ctx, HashSet *b);
void knh_HashSet_resize(Ctx *ctx, HashSet *b, size_t nc);

knh_uint_t knh_HashSet_get(Ctx *ctx, HashSet *b, knh_hcode_t key, Object *keyobj);
knh_bool_t knh_HashSet_opIn(Ctx *ctx, HashSet *b, knh_hcode_t key, Object *keyobj);
knh_uint_t knh_HashSet_get__b(Ctx *ctx, HashSet *b, knh_bytes_t kv);
void knh_HashSet_set(Ctx *ctx, HashSet *b, knh_hcode_t key, Any *keyobj, knh_uint_t value);
void knh_HashSet_add(Ctx *ctx, HashSet *b, knh_hcode_t key, Any *keyobj);
void knh_HashSet_remove(Ctx *ctx, HashSet *b, knh_hcode_t key, Any *keyobj);

Object* knh_HashSet_Iterator(Ctx *ctx, Object *self, MapMap *map);

void knh_HashSet__dump(Ctx *ctx, HashSet *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_InputStream.c */
#define knh_InputStream_struct_copy   NULL
#define knh_InputStream_struct_compare  NULL



void knh_InputStream_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_InputStream_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);


int_byte_t knh_InputStream_getc(Ctx *ctx, InputStream *b);
void knh_InputStream_close(Ctx *ctx, InputStream *b);

InputStream *new_InputStream__FILE(Ctx *ctx, StreamStat *stat, FILE *fp);
void knh_InputStream_FILE_traverse(Ctx *ctx, InputStream *b, f_gc gc);
int_byte_t knh_InputStream_FILE_getc(Ctx *ctx, InputStream *b);
int_byte_t knh_InputStream_FILE_getc__stat(Ctx *ctx, InputStream *b);
int_byte_t knh_InputStream_NULL_getc(Ctx *ctx, InputStream *b);
void knh_InputStream_FILE_close(Ctx *ctx, InputStream *b);

InputStream *new_InputStream__Bytes(Ctx *ctx, StreamStat *stat, Bytes *ba, size_t s, size_t e);
InputStream *new_InputStream__NULL(Ctx *ctx);
void knh_InputStream_Bytes_traverse(Ctx *ctx, InputStream *b, f_gc gc);
int_byte_t knh_InputStream_Bytes_getc(Ctx *ctx, knh_InputStream *b);
int_byte_t knh_InputStream_Bytes_getc__stat(Ctx *ctx, knh_InputStream *b);
void knh_InputStream_Bytes_close(Ctx *ctx, InputStream *b);



void knh_InputStream__dump(Ctx *ctx, InputStream *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Int.c */
#define INT_BUFSIZ 32
#define knh_Int_value(b)      (b)->value
#define knh_Int_struct_traverse NULL
#define new_Int(ctx, value) new_Int__fast(ctx, CLASS_Int, value)




void knh_Int_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Int_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Int_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);

Int* new_Int__fast(Ctx *ctx, knh_class_t cid, knh_int_t value);
Int* new_Int__checked(Ctx *ctx, knh_class_t cid, knh_int_t value);

knh_int_t knh_int_max(knh_int_t a, knh_int_t b);
knh_int_t knh_int_min(knh_int_t a, knh_int_t b);
knh_uint_t knh_uint_max(knh_uint_t a, knh_uint_t b);
knh_uint_t knh_uint_min(knh_uint_t a, knh_uint_t b);


Object* knh_String_Int(Ctx *ctx, Object *self, MapMap *map);
Object* knh_Int_String(Ctx *ctx, Object *self, MapMap *map);
knh_int_t knh_Int_opAdd(Int *b, knh_vargc_t ac, Int **v);
knh_int_t knh_Int_opSub(Int *b, knh_vargc_t ac, Int **v);
knh_int_t knh_Int_opMul(Int *b, knh_vargc_t ac, Int **v);
knh_int_t knh_Int_opDiv(Int *b, knh_vargc_t ac, Int **v);
knh_int_t knh_Int_opMod(Int *b, knh_int_t n);
knh_int_t knh_Int_opBitAnd(Int *b, knh_vargc_t ac, Int **v);
knh_int_t knh_Int_opBitOr(Int *b, knh_vargc_t ac, Int **v);
knh_int_t knh_Int_opLShift(Int *b, knh_int_t n);
knh_int_t knh_Int_opRShift(Int *b, knh_int_t n);
knh_int_t knh_Int_opBitNot(Int *b);

void knh_Int__s(Ctx *ctx, Int *b, Writer *w, Any *m);
void knh_Int__x(Ctx *ctx, Int *b, Writer *w, Any *m);
void knh_Int__bits(Ctx *ctx, Int *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_IntUnit.c */
#define knh_IntUnit_struct_copy    NULL
#define knh_IntUnit_struct_compare NULL



void knh_IntUnit_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_IntUnit_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Object *knh_intunit_fvalue(Ctx *ctx, knh_class_t cid);

IntUnit *new_IntUnit__STEXT(Ctx *ctx, knh_flag_t flag, knh_class_t cid, char *urn, char *tag, knh_int_t min, knh_int_t max, knh_int_t defvalue, knh_int_t bf_start, knh_int_t bf_end);

IntUnit* knh_tclass_getIntUnit(Ctx *ctx, knh_class_t cid);
IntUnit *knh_Int_spec(Ctx *ctx);

void knh_IntUnit_initId(Ctx *ctx, IntUnit *b, knh_flag_t flag, knh_class_t cid, String *urn, String *tag);
void knh_IntUnit_initMinMax(Ctx *ctx, IntUnit *b, knh_int_t min, knh_int_t max);
void knh_IntUnit_init_bfarray(Ctx *ctx, IntUnit *b, knh_int_t bf_start, knh_int_t bf_end);
void knh_IntUnit_initDefaultValue(Ctx *ctx, IntUnit *b, knh_int_t v);

knh_bool_t knh_IntUnit_check(IntUnit *b, knh_int_t value);
Int *new_Nue__asInt(Ctx *ctx, knh_class_t cid, knh_int_t value);
Int *new_Nue__asuInt(Ctx *ctx, knh_class_t cid, knh_uint_t value);
Int *knh_IntUnit_value(Ctx *ctx, IntUnit *b, knh_int_t value);
knh_int_t knh_IntUnit_compare(IntUnit *b, knh_int_t v1, knh_int_t v2);
void knh_IntUnit_format(IntUnit *b, char *buf, knh_int_t v);
void knh_IntUnit_format_unit(IntUnit *b, char *buf);

knh_bool_t knh_IntUnit_fchk__nop(IntUnit *b, knh_int_t v);
knh_int_t knh_IntUnit_fcmp__signed(IntUnit *b, knh_int_t v1, knh_int_t v2);
knh_int_t knh_IntUnit_fcmp__unsigned(IntUnit *b, knh_int_t v1, knh_int_t v2);
void knh_IntUnit_ffmt__signed(IntUnit *b, char *buf, knh_int_t v);
void knh_IntUnit_ffmt__unsigned(IntUnit *b, char *buf, knh_int_t v);

knh_bool_t knh_IntUnit_fchk__signed_min(IntUnit *b, knh_int_t v);
knh_bool_t knh_IntUnit_fchk__signed_max(IntUnit *b, knh_int_t v);
knh_bool_t knh_IntUnit_fchk__signed(IntUnit *b, knh_int_t v);
knh_bool_t knh_IntUnit_fchk__unsigned_min(IntUnit *b, knh_int_t v);
knh_bool_t knh_IntUnit_fchk__unsigned_max(IntUnit *b, knh_int_t v);
knh_bool_t knh_IntUnit_fchk__unsigned(IntUnit *b, knh_int_t v);



/* ======================================================================== */
/* knh_Iterator.c */
#define knh_Iterator_cid(it)          (((Iterator*)it)->cid)
#define knh_Iterator_source(it)       (((Iterator*)it)->source)
#define knh_Iterator_setsource(ctx, it, s)    KNH_SETv(ctx, (((Iterator*)it)->pos), s)
#define knh_Iterator_pos(it)          (((Iterator*)it)->pos)
#define knh_Iterator_setpos(it, size)  ((Iterator*)it)->pos = (size)
#define knh_Iterator_ref(it)          (((Iterator*)it)->ref)
#define knh_Iterator_setref(it, rr)       ((Iterator*)it)->ref = (rr)
#define knh_Iterator_struct_compare NULL




void knh_Iterator_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Iterator_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
void knh_Iterator_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Object * knh_Object_single_next(Ctx *ctx, Iterator *it);
Iterator* new_Iterator(Ctx *ctx, knh_class_t cid, Object *source, f_next f);
Object *knh_Iterator_fvalue(Ctx *ctx, knh_class_t cid);
Object* knh_MapMap_fmap__Interface(Ctx *ctx, Object *self, MapMap *map);

knh_class_t knh_Object_pcid(Object *b);

Object *knh_Iterator_foreach(Ctx *ctx, Iterator *b, knh_class_t cid);

Object *knh_Iterator_each(Ctx *ctx, Iterator *b, knh_class_t cid);
Object *knh_Iterator_each__slice(Ctx *ctx, Iterator *b, knh_class_t cid);
Object *knh_Iterator_each__map(Ctx *ctx, Iterator *b, knh_class_t tcid);


Object* knh_Iterator_Array(Ctx *ctx, Object *self, MapMap *map);

void knh_Iterator__dump(Ctx *ctx, Iterator *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Long.c */
#define knh_Long_struct_traverse NULL
#define new_Long(ctx, value) new_Long__fast(ctx, CLASS_Long, value)



void knh_Long_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Long_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Long_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);

Long* new_Long__fast(Ctx *ctx, knh_class_t cid, knh_int64_t value);
Long* new_Long__checked(Ctx *ctx, knh_class_t cid, knh_int64_t value);

knh_int64_t knh_long_max(knh_int64_t a, knh_int64_t b);
knh_int64_t knh_long_min(knh_int64_t a, knh_int64_t b);
knh_uint64_t knh_ulong_max(knh_uint64_t a, knh_uint64_t b);
knh_uint64_t knh_ulong_min(knh_uint64_t a, knh_uint64_t b);

void knh_Long__dump(Ctx *ctx, Long *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_MapMap.c */
#define knh_MapMap_struct_compare  NULL




void knh_MapMap_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_MapMap_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
void knh_MapMap_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

MapMap* new_MapMap(Ctx *ctx, knh_flag_t flag, knh_class_t scid, knh_class_t tcid, f_mapmap fmap, Object *conf);

Object* knh_MapMap_fmap__Interface(Ctx *ctx, Object *self, MapMap *map);
MapMap* new_MapMap__interface(Ctx *ctx, knh_class_t scid, knh_class_t tcid);
Object* knh_MapMap_fmap__defvalue(Ctx *ctx, Object *self, MapMap *map);
Object* knh_MapMap_fmap__Null(Ctx *ctx, Object *self, MapMap *map);
MapMap* new_MapMap__NoSuchMapping(Ctx *ctx, knh_class_t scid, knh_class_t tcid);
knh_bool_t knh_MapMap_isNoSuchMapping(MapMap *b);

Object *knh_MapMap_execMap(Ctx *ctx, MapMap *b, Object *sub);

Object* knh_MapMap_toString(Ctx *ctx, Object *self, MapMap *map);

void knh_MapMap__dump(Ctx *ctx, MapMap *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Method.c */
#define FIELDN_NONAME    ((knh_fieldn_t)-1)
#define FIELDN_NEWID     ((knh_fieldn_t)-2)
#define FIELDN_return    FIELDN_
#define METHODN_NONAME   ((knh_methodn_t)-1)
#define METHODN_NEWID    ((knh_methodn_t)-2)
#define KNH_FLAG_FN_SUPER   KNH_FLAG_T0
#define KNH_FLAG_FN_U1      KNH_FLAG_T1
#define KNH_FLAG_FN_U2      KNH_FLAG_T2
#define FIELDN_IS_SUPER(fnq)       ((fnq & KNH_FLAG_FN_SUPER) == KNH_FLAG_FN_SUPER)
#define FIELDN_IS_U1(fnq)          ((fnq & KNH_FLAG_FN_U1) == KNH_FLAG_FN_U1)
#define FIELDN_IS_U2(fnq)          ((fnq & KNH_FLAG_FN_U2) == KNH_FLAG_FN_U2)
#define FIELDN_IS_PROTECTED(fnq)   (FIELDN_IS_U1(fnq)||FIELDN_IS_U2(fnq))
#define FIELDN_UNMASK(fnq)         (fnq & (~(KNH_FLAG_FN_SUPER|KNH_FLAG_FN_U1|KNH_FLAG_FN_U2)))
#define KNH_FLAG_MN_SUPER        KNH_FLAG_T0
#define KNH_FLAG_MN_GETTER       KNH_FLAG_T1
#define KNH_FLAG_MN_SETTER       KNH_FLAG_T2
#define KNH_FLAG_MN_MOVTEXT      (KNH_FLAG_T1|KNH_FLAG_T2)
#define KNH_FLAG_MN_FIELDN       (~(KNH_FLAG_T0|KNH_FLAG_T1|KNH_FLAG_T2))
#define METHODN_IS_GETTER(mn)   ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_GETTER)
#define METHODN_TO_GETTER(mn)   (mn | KNH_FLAG_MN_GETTER)
#define METHODN_IS_SETTER(mn)   ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_SETTER)
#define METHODN_TO_SETTER(mn)   (mn | KNH_FLAG_MN_SETTER)
#define METHODN_IS_MOVTEXT(mn)  ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_MOVTEXT)
#define METHODN_TO_MOVTEXT(mn)  (mn | KNH_FLAG_MN_MOVTEXT)
#define METHODN_TOFIELDN(mn)     (mn & KNH_FLAG_MN_FIELDN)
#define knh_Method_mn(mtd)    (mtd)->mn
#define knh_Method_mf(mtd)    (mtd)->mf




void knh_Method_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Method_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Method_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_Method_code_traverse(Ctx *ctx, Method *b, f_gc gc);
void knh_Method_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Method* new_Method(Ctx *ctx, knh_flag_t flag, knh_class_t cid, knh_methodn_t mn, f_method func);

void knh_Method_fAbstractMethod(Ctx *ctx, Object **sf);
knh_bool_t knh_Method_isAbstract(Method *b);
void knh_Method_toAbstract(Ctx *ctx, Method *b);

void knh_ClassStruct_toAbstractAll(Ctx *ctx, ClassStruct *b);

Object * knh_Method_returnValue(Ctx *ctx, Method *mtd);
void knh_Method_fNoSuchMethod(Ctx *ctx, Object **sf);
knh_bool_t knh_Method_isNoSuchMethod(Method *b);
Method* new_Method__NoSuchMethod(Ctx *ctx, knh_class_t cid, knh_methodn_t mn);

knh_bool_t knh_methodn_isNew(knh_methodn_t mn);
knh_bool_t knh_Method_isNew(Method *b);
knh_bool_t knh_methodn_isOp(knh_methodn_t mn);

String* knh_Method_getName(Ctx *ctx, Method *b);
String* knh_Method_getURN(Ctx *ctx, Method *b);

void knh_Method__s(Ctx *ctx, Method *b, Writer *w, Any *m);
void knh_Method__dump(Ctx *ctx, Method *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_MethodField.c */
#define knh_Method_rtype(mtd)          knh_MethodField_rtype(knh_Method_mf(mtd))
#define knh_Method_psize(mtd)      knh_MethodField_psize(knh_Method_mf(mtd))
#define knh_Method_ptype(mtd,n)          knh_MethodField_ptype(knh_Method_mf(mtd),n)
#define knh_Method_pfields(mtd,n)   knh_MethodField_pfields(knh_Method_mf(mtd),n)
#define knh_Method_lastfield(mtd)   knh_MethodField_lastfield(knh_Method_mf(mtd))



void knh_MethodField_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_MethodField_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_MethodField_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_MethodField_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

MethodField* new_MethodField(Ctx *ctx, knh_flag_t flag, size_t size);

knh_hcode_t knh_methodfield_hcode(knh_type_t r, knh_type_t a0, knh_type_t a1);
knh_hcode_t knh_MethodField_hcode(MethodField *b);
knh_bool_t knh_MethodField_equalsType(MethodField *b, MethodField *b2);

void knh_MethodField_setVarArgs(MethodField *b);
knh_bool_t knh_MethodField_isVarArgs(MethodField *b);

knh_type_t knh_MethodField_rtype(MethodField *b);
size_t knh_MethodField_psize(MethodField *b);
knh_index_t knh_MethodField_pindex(MethodField *b, knh_fieldn_t fn);
knh_type_t knh_MethodField_ptype(MethodField *b, size_t n);
knh_mfield_t knh_MethodField_pfields(MethodField *b, size_t n);
knh_mfield_t knh_MethodField_lastfield(MethodField *b);

MethodField* new_MethodField__mt(Ctx *ctx);
MethodField* new_MethodField__NoSuchMethod(Ctx *ctx);
MethodField* new_MethodField__PrototypeRun(Ctx *ctx);



/* ======================================================================== */
/* knh_MovableText.c */
#define knh_MovableText_struct_copy  NULL
#define knh_MovableText_struct_compare NULL




void knh_MovableText_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_MovableText_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

MovableText *new_MovableText(Ctx *ctx);


void knh_MovableText__s(Ctx *ctx, MovableText *b, Writer *w, Any *m);
void knh_MovableText__dump(Ctx *ctx, MovableText *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Mutex__pthread.c */
#define KNH_MUTEX_RECURSIVE    0
#define KNH_MUTEX_FAST         1
#define knh_Mutex_struct_copy  NULL
#define knh_Mutex_struct_compare   NULL




void knh_Mutex_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Mutex_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Mutex* new_Mutex(Ctx *ctx);

void knh_Mutex_lock(Ctx *ctx, Mutex *b);
void knh_Mutex_unlock(Ctx *ctx, Mutex *b);

void knh_Object_lock(Ctx *ctx, Object *b);
void knh_Object_unlock(Ctx *ctx, Object *b);

void knh_Mutex__dump(Ctx *ctx, Mutex *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_NameSpace.c */

NameSpace* new_NameSpace(Ctx *ctx0, NameSpace *parent, String *nsname);

void knh_NameSpace_setClass(Ctx *ctx, NameSpace *b, String *name, knh_class_t c);
void knh_NameSpace_setLocalName(Ctx *ctx, NameSpace *b, String *name, knh_class_t c);
knh_class_t knh_NameSpace_getClass(Ctx *ctx, NameSpace *b, knh_bytes_t name);

knh_type_t knh_NameSpace_type(Ctx *ctx, NameSpace *b, knh_bytes_t name);
knh_type_t knh_NameSpace_tagcid(Ctx *ctx, NameSpace *b, knh_class_t bcid, knh_bytes_t tag);

Class *knh_NameSpace_getFuncClass(Ctx *ctx, NameSpace *b, knh_bytes_t funcname);



/* ======================================================================== */
/* knh_Nue.c */
#define Null                knh_Nue_NULL()
#define IS_NULL(o)          (knh_Object_cid(o) == CLASS_Nue)
#define IS_NOTNULL(o)       (knh_Object_cid(o) != CLASS_Nue)
#define KNH_DONE_IFNULL(w)         if(IS_NULL(w)) return ;
#define KNH_RETURN_IFNULL(w,v)     if(IS_NULL(w)) return v;
#define KNH_THROW_IFNULL(ctx,w)    if(IS_NULL(w)) knh_konohavm_throwException(ctx, new_Exception__Nue(ctx, w));




void knh_Nue_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Nue_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Nue_struct_compare(Ctx *ctx, Struct *s, Struct *s2);
void knh_Nue_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Nue * new_Nue__STEXT(Ctx *ctx, char *msg);
Nue * new_Nue(Ctx *ctx, String *msg);
ObjectNULL *knh_Nue_fvalue(Ctx *ctx, knh_class_t cid);

Object* knh_Nue_String(Ctx *ctx, Object *self, MapMap *map);

void knh_Nue__s(Ctx *ctx, Nue *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Number.c */
#define IS_Number(o)  (STRUCT_Nue <= knh_Object_topsid(o) && knh_Object_topsid(o) <= STRUCT_String)
#define IS_CLASS_Number(cid) (CLASS_Int <= cid && cid < CLASS_String)
#define CLASS_ISNUMBER(c)    (STRUCT_Int <= knh_tclass_topsid(c) && knh_tclass_topsid(c) < STRUCT_String)



Number *new_Number__RAW(Ctx *ctx, knh_class_t cid, knh_bytes_t t);

knh_int_t knh_Nue_toint(Number *b);
knh_int_t knh_Bool_toint(Number *b);
knh_int_t knh_String_toint(Number *b);

knh_float_t knh_Nue_tofloat(Number *b);
knh_float_t knh_Bool_tofloat(Number *b);
knh_float_t knh_String_tofloat(Number *b);

knh_int64_t knh_Nue_tolong(Number *b);
knh_int64_t knh_Bool_tolong(Number *b);
knh_int64_t knh_String_tolong(Number *b);

Number *new_Number__i(Ctx *ctx, knh_class_t cid, knh_int_t n);
Number *new_Number__f(Ctx *ctx, knh_class_t cid, knh_float_t n);
Number *new_Number__l(Ctx *ctx, knh_class_t cid, knh_int64_t n);
Number *new_Number__b(Ctx *ctx, knh_class_t cid, knh_bytes_t t);

knh_int_t knh_Number_toint(Number *n);
knh_float_t knh_Number_tofloat(Number *n);
knh_int64_t knh_Number_tolong(Number *n);

Number *new_Int__i(Ctx *ctx, knh_class_t cid, knh_int_t n);
Number *new_Int__f(Ctx *ctx, knh_class_t cid, knh_float_t n);
Number *new_Int__l(Ctx *ctx, knh_class_t cid, knh_int64_t n);
Number *new_Int__b(Ctx *ctx, knh_class_t cid, knh_bytes_t t);
knh_int_t knh_Int_toint(Number *b);
knh_float_t knh_Int_tofloat(Number *b);
knh_int64_t knh_Int_tolong(Number *b);

Number *new_Float__i(Ctx *ctx, knh_class_t cid, knh_int_t n);
Number *new_Float__f(Ctx *ctx, knh_class_t cid, knh_float_t n);
Number *new_Float__l(Ctx *ctx, knh_class_t cid, knh_int64_t n);
Number *new_Float__b(Ctx *ctx, knh_class_t cid, knh_bytes_t t);
knh_int_t knh_Float_toint(Number *b);
knh_float_t knh_Float_tofloat(Number *b);
knh_int64_t knh_Float_tolong(Number *b);

Number *new_Long__i(Ctx *ctx, knh_class_t cid, knh_int_t n);
Number *new_Long__f(Ctx *ctx, knh_class_t cid, knh_float_t n);
Number *new_Long__l(Ctx *ctx, knh_class_t cid, knh_int64_t n);
Number *new_Long__b(Ctx *ctx, knh_class_t cid, knh_bytes_t t);
knh_int_t knh_Long_toint(Number *b);
knh_float_t knh_Long_tofloat(Number *b);
knh_int64_t knh_Long_tolong(Number *b);



/* ======================================================================== */
/* knh_Object.c */
#define knh_Object_cid(o)           (knh_class_t)(knh_Object_head(o)->cid)
#define knh_Object_topsid(o)        knh_tclass_topsid(knh_Object_cid(o))
#define knh_Object_offset(o)        knh_tclass_offset(knh_Object_cid(o))




Object * new_Object__cid(Ctx *ctx, knh_flag_t flag, knh_class_t cid);
Object *knh_Object_copy(Ctx *ctx, Object *b);

knh_class_t knh_Object_getClass(Object *b);

knh_hcode_t knh_Object_hcode(Ctx *ctx, Object *self);
knh_bytes_t knh_Object_tobytes(Ctx *ctx, Object *v);

knh_int_t knh_Object_compare(Ctx *ctx, Object *o1, Object *o2);
knh_bool_t knh_Object_equals(Ctx *ctx, Object *o1, Object *o2);

knh_bool_t knh_Object_opEq(Ctx *ctx, Object *b, Any *value);
knh_bool_t knh_Object_opNeq(Ctx *ctx, Object *b, Any *value);
knh_bool_t knh_Object_opLt(Ctx *ctx, Object *b, Any *value);
knh_bool_t knh_Object_opLte(Ctx *ctx, Object *b, Any *value);
knh_bool_t knh_Object_opGt(Ctx *ctx, Object *b, Any *value);
knh_bool_t knh_Object_opGte(Ctx *ctx, Object *b, Any *value);
knh_bool_t knh_Object_opNot(Ctx *ctx, Object *b);

Object* knh_Object_Iterator(Ctx *ctx, Object *self, MapMap *map);
Object* knh_Object_String(Ctx *ctx, Object *self, MapMap *map);
void knh_Object_save(Ctx *ctx, Object *b, knh_int_t lv);

void knh_Object__s(Ctx *ctx, Object *b, Writer *w, Any *m);
void knh_Object__dump(Ctx *ctx, Object *b, Writer *w, Any *m);
void knh_Object__empty(Ctx *ctx, Object *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_OutputStream.c */
#define knh_OutputStream_struct_copy      NULL
#define knh_OutputStream_struct_compare   NULL



void knh_OutputStream_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_OutputStream_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);


void knh_OutputStream_putc(Ctx *ctx, OutputStream *b, int_byte_t ch);
void knh_OutputStream_write(Ctx *ctx, OutputStream *b, knh_bytes_t buf);
void knh_OutputStream_flush(Ctx *ctx, OutputStream *b);
void knh_OutputStream_close(Ctx *ctx, OutputStream *b);

OutputStream *new_OutputStream__FILE(Ctx *ctx, StreamStat *stat, FILE *fp);
void knh_OutputStream_FILE_traverse(Ctx *ctx, OutputStream *b, f_gc gc);
void knh_OutputStream_FILE_putc(Ctx *ctx, OutputStream *b, int_byte_t ch);
void knh_OutputStream_FILE_putc__stat(Ctx *ctx, OutputStream *b, int_byte_t ch);
void knh_OutputStream_FILE_write(Ctx *ctx, OutputStream *b, knh_bytes_t byte);
void knh_OutputStream_FILE_write__stat(Ctx *ctx, OutputStream *b, knh_bytes_t byte);
void knh_OutputStream_FILE_flush(Ctx *ctx, OutputStream *b);
void knh_OutputStream_NULL_putc(Ctx *ctx, OutputStream *b, int_byte_t ch);
void knh_OutputStream_NULL_write(Ctx *ctx, OutputStream *b, knh_bytes_t byte);
void knh_OutputStream_NULL_flush(Ctx *ctx, OutputStream *b);
void knh_OutputStream_FILE_close(Ctx *ctx, OutputStream *b);

OutputStream *new_OutputStream__Bytes(Ctx *ctx, StreamStat *stat, Bytes *ba);
void knh_OutputStream_Bytes_traverse(Ctx *ctx, OutputStream *b, f_gc gc);
void knh_OutputStream_Bytes_putc(Ctx *ctx, OutputStream *b, int_byte_t ch);
void knh_OutputStream_Bytes_putc__stat(Ctx *ctx, OutputStream *b, int_byte_t ch);
void knh_OutputStream_Bytes_write(Ctx *ctx, OutputStream *b, knh_bytes_t buf);
void knh_OutputStream_Bytes_write__stat(Ctx *ctx, OutputStream *b, knh_bytes_t buf);
void knh_OutputStream_Bytes_flush(Ctx *ctx, OutputStream *b);
void knh_OutputStream_Bytes_close(Ctx *ctx, OutputStream *b);

OutputStream *new_OutputStream_Null(Ctx *ctx);

void knh_OutputStream__dump(Ctx *ctx, OutputStream *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Prototype.c */
#define knh_Prototype_struct_copy   NULL
#define knh_Prototype_struct_compare  NULL



void knh_Prototype_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_Prototype_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Prototype *new_Prototype(Ctx *ctx, knh_nsn_t nsn);


knh_bool_t knh_Class_isPrototype(Ctx *ctx, knh_class_t cid);

void knh_Prototype__dump(Ctx *ctx, Prototype *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Regex.c */
#define knh_Regex_struct_copy  NULL
#define knh_Regex_struct_compare NULL




void knh_Regex_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_Regex_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Regex *new_Regex(Ctx *ctx, String *pstr);

knh_bool_t knh_Regex_match__b(Ctx *ctx, Regex *b, knh_bytes_t s);
knh_bool_t knh_Regex_match(Ctx *ctx, Regex *b, String *s);

Object *knh_Regex_transform(Ctx *ctx, Regex *b, knh_class_t tcid, String *s);

Object *knh_mapserv__Regex(Ctx *ctx, Object *mapserv, Object *s, knh_class_t tcid);

void knh_Regex__s(Ctx *ctx, Regex *b, Writer *w, Any *m);
void knh_Regex__dump(Ctx *ctx, Regex *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Runtime.c */
#define knh_Runtime_struct_copy  NULL
#define knh_Runtime_struct_compare NULL



void knh_Runtime_struct_init(Ctx *ctx0, Struct *s1, int init, Object *cs);
void knh_Runtime_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Runtime* new_Runtime(Ctx *ctx0, knh_uint_t runtime_id);

Context *knh_Runtime_getContext(Ctx *ctx0, Runtime *b, knh_bytes_t name);
void knh_Runtime_removeContext(Ctx *ctx0, Runtime *b, knh_bytes_t name);



/* ======================================================================== */
/* knh_StreamStat.c */
#define knh_StreamStat_struct_copy   NULL
#define knh_StreamStat_struct_compare  NULL



void knh_StreamStat_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
void knh_StreamStat_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

StreamStat* new_StreamStat_filen(Ctx *ctx, knh_filen_t filen);

void knh_StreamStat_init(StreamStat *b);

void knh_StreamStat_read_ch(StreamStat *b, int_byte_t ch);
void knh_StreamStat_write_size(StreamStat *b, size_t size);



/* ======================================================================== */
/* knh_String.c */
#define new_String(ctx,t)              new_String__fast(ctx,CLASS_String,B(t))
#define new_String__STEXT(ctx,cid,s)   new_String__fast(ctx, cid, STEXT(s))
#define knh_String_value(o)   (o)->value
#define knh_String_struct_copy  NULL
#define knh_bytes_hcode(t)     knh_string_hash((t).buf, (t).len)




void knh_String_struct_init(Ctx *ctx, Struct *s, int init, Object *cs);
knh_int_t knh_String_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_String_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

knh_hcode_t knh_string_hash(knh_uchar_t *buf, knh_size_t len);

String *new_String__fast(Ctx *ctx, knh_class_t cid, knh_bytes_t t);
String *new_String__subfast(Ctx *ctx, knh_class_t cid, String *sub, knh_size_t offset, knh_size_t len);
String *new_String__checked(Ctx *ctx, knh_class_t cid, knh_bytes_t value);
String *new_String__sub(Ctx *ctx, knh_class_t cid, String *sub, knh_size_t offset, knh_size_t len);

knh_hcode_t knh_String_hcode(String *b);
char *knh_String_tochar(String *b);
knh_bytes_t knh_String_tobytes(String *b);

knh_bool_t knh_String_equals(String *b, knh_bytes_t s);
knh_bool_t knh_String_startsWith(String *b, knh_bytes_t s);
knh_bool_t knh_String_endsWith(String *b, knh_bytes_t s);
size_t knh_String_getSize(String *b);


Object* knh_String_byte_next(Ctx *ctx, Iterator *it);
Object* knh_String_INTbyte__(Ctx *ctx, Object *self, MapMap *map);
void knh_String_format(Ctx *ctx, String *b, OutputStream *out);
String* knh_String_opAdd(Ctx *ctx, String *b, knh_vargc_t ac, Any **v);
String* knh_String_opMul(Ctx *ctx, String *b, knh_int_t n);

void knh_String__s(Ctx *ctx, String *b, Writer *w, Any *m);
void knh_String__dump(Ctx *ctx, String *b, Writer *w, Any *m);

String *knh_String_EMPTY(void);
String *knh_String_NL(void);
String *knh_String_TAB(void);
String *knh_String_NULL(void);
String *knh_String_cTRUE(void);
String *knh_String_cFALSE(void);



/* ======================================================================== */
/* knh_String_charset.c */
size_t knh_string_size(knh_bytes_t s);
size_t knh_string_index(knh_bytes_t s, size_t n);
knh_bool_t knh_string_isvalid(knh_bytes_t s);



/* ======================================================================== */
/* knh_System.c */

System *new_System(Ctx *ctx);

char * knh_bytes_nzenvkey(knh_bytes_t t, char *buf, size_t bufsiz);
Any* knh_System_getProperty(Ctx *ctx, System *b, knh_bytes_t key);
void knh_System_setProperty(Ctx *ctx, System *b, String *key, Any *value);

void knh_System__dump(Ctx *ctx, System *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Tuple.c */
#define Tuple                   Tuple1 
#define TupleNULL               Tuple1NULL
#define CLASS_Tuple             CLASS_Tuple1
#define CF_Tuple                CF_Tuple1
#define OF_Tuple                OF_Tuple1
#define IS_STRUCT_Tuple(ctx,o)        (knh_Object_topsid(ctx,o) < STRUCT_Prototype)
#define IS_Tuple(o)             (knh_Object_cid(o) < CLASS_Prototype)
#define ISA_Tuple(ctx,o)        (knh_Object_cid(o) < CLASS_Prototype)
#define DEBUG_Tuple             DEBUG_Tuple1
#define SAFECAST_Tuple(ctx,o)          knh_Tuple_cast(ctx,o)
#define SAFECAST_TupleOrNull(ctx,o)    knh_Tuple_castOrNull(ctx,o)
#define knh_Tuple2_new(ctx,o1,o2) new_Tuple(ctx,o1,o2,NULL)
#define knh_Tuple_size(b)  knh_Tuple_getSize(b)




void knh_Tuple0_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Tuple0_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
knh_int_t knh_Tuple0_struct_compare(Ctx *ctx, Struct *s1, Struct *s2);
void knh_Tuple0_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

void knh__Tuple_get_field(Ctx *ctx, Object **sf);
void knh__Tuple_set_field(Ctx *ctx, Object **sf);

Tuple* knh_Tuple_new(Ctx *ctx, Tuple *b, knh_vargc_t ac, Any **value);
Tuple* new_Tuple(Ctx *ctx, ...);

size_t knh_Tuple_getSize(Tuple *b);
Object *knh_Tuple_get__fast(Tuple *b, knh_int_t index);
Object *knh_Tuple_get(Tuple *b, knh_int_t index);

Object* knh_Array_Tuple(Ctx *ctx, Object *self, MapMap *map);

Object* knh_Tuple_next(Ctx *ctx, Iterator *it);
Object* knh_Tuple_Iterator(Ctx *ctx, Object *self, MapMap *map);

void knh_Tuple__dump(Ctx *ctx, Tuple *b, Writer *w, Any *m);



/* ======================================================================== */
/* knh_Vocabulary.c */
#define knh_Vocabulary_struct_copy   NULL
#define knh_Vocabulary_struct_compare  NULL
#define knh_Vocabulary_fval__default knh_Vocabulary_newString



void knh_Vocabulary_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Vocabulary_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Vocabulary *new_Vocabulary__STEXT(Ctx *ctx, knh_flag_t flag, knh_class_t cid, char *urn, char *tag, ...);

Vocabulary* knh_tclass_getVocabulary(Ctx *ctx, knh_class_t cid);
Vocabulary *knh_String_spec(Ctx *ctx);

knh_bool_t knh_Vocabulary_fnmz__toupper(Ctx *ctx, knh_bytes_t t, Bytes *ba);
knh_bool_t knh_Vocabulary_fnmz__tolower(Ctx *ctx, knh_bytes_t t, Bytes *ba);
String *knh_Vocabulary_newString(Ctx *ctx, Vocabulary *b, knh_bytes_t t, void *orig, size_t off, size_t len);
String *new_Nue__asIllegalString(Ctx *ctx, Vocabulary *b, knh_bytes_t t);
String *knh_Vocabulary_value(Ctx *ctx, Vocabulary *b, knh_bytes_t t, void *orig, size_t off, size_t len);
knh_int_t knh_Vocabulary_fcmp__default(Vocabulary *b, knh_bytes_t v1, knh_bytes_t v2);
knh_int_t knh_Vocabulary_compare(Vocabulary *b, knh_bytes_t v1, knh_bytes_t v2);

void knh_Vocabulary_initDict(Ctx *ctx, Vocabulary *b, ObjectNULL *dict, f_vocab_nmz fnmz, f_vocab_val fval, f_vocab_cmp fcmp);
String* knh_Vocabulary_fval__dict(Ctx *ctx, Vocabulary *b, knh_bytes_t t, void *orig, size_t off, size_t len);
knh_int_t knh_Vocabulary_fcmp__dict(Vocabulary *b, knh_bytes_t v1, knh_bytes_t v2);
void knh_Vocabulary_addDict__STEXT(Ctx *ctx, Vocabulary *b, char *vocab);



/* ======================================================================== */
/* knh_Writer.c */
#define knh_Writer_struct_compare  NULL
#define new_Writer_StdOut(ctx)   new_Writer(ctx, System_out(ctx))
#define new_Writer_StdErr(ctx)   new_Writer(ctx, System_err(ctx))
#define knh_write(ctx,w,s)   knh_Writer_write(ctx,w,s)
#define knh_flush(ctx,w)   knh_Writer_flush(ctx,w)
#define knh_writeLine(ctx,w,s)   knh_Writer_writeLine(ctx,w,s)
#define knh_writeTab(ctx,w,n)   knh_Writer_writeTab(ctx,w,n)
#define knh_write__i(ctx, b, n) knh_write__ifmt(ctx, b, KNH_INT_FMT, n)
#define knh_write__u(ctx, b, n) knh_write__ifmt(ctx, b, KNH_UINT_FMT, n)
#define knh_write__x(ctx, b, n) knh_write__ifmt(ctx, b, KNH_INT_FMTX, n)
#define knh_write__f(ctx, b, f)  knh_write__ffmt(ctx, b, KNH_FLOAT_FMT, f)
#define knh_write__e(ctx, b, f)  knh_write__ffmt(ctx, b, KNH_FLOAT_FMTE, f)
#define knh_write__expt(ctx, b, eid)    knh_write__s(ctx, b, EXPTN(eid))
#define knh_write__fn(ctx, b, fn)   knh_write__s(ctx, b, FIELDN(fn))
#define knh_write_indent(ctx, b, tab)   knh_Writer_write_indent(ctx, b, tab)
#define knh_write__O(ctx, w, o)    knh_format(ctx,w,METHODN__s,o,Null)
#define knh_Object_toString(ctx, b)   knh_Object_movableText(ctx, b, METHODN__s, Null)



void knh_Writer_struct_init(Ctx *ctx, Struct *s1, int init, Object *cs);
void knh_Writer_struct_copy(Ctx *ctx, Struct *s1, Struct *s2);
void knh_Writer_struct_traverse(Ctx *ctx, Struct *s, f_gc gc);

Writer* knh_Writer_new(Ctx *ctx, Writer *b, OutputStream *out, String *tab);
Writer *new_Writer(Ctx *ctx, OutputStream *out);
Writer *new_Writer__Bytes(Ctx *ctx, Bytes *ba);

void knh_putc(Ctx *ctx, Writer *b, int_byte_t ch);
void knh_Writer_write(Ctx *ctx, Writer *b, knh_bytes_t s);
void knh_Writer_flush(Ctx *ctx, Writer *b);
void knh_Writer_writeLine(Ctx *ctx, Writer *b, knh_bytes_t s);
void knh_Writer_writeTab(Ctx *ctx, Writer *b, knh_int_t n);

void knh_write__p(Ctx *ctx, Writer *b, void *ptr);
void knh_write__s(Ctx *ctx, Writer *b, char *s);
void knh_write__ifmt(Ctx *ctx, Writer *b, char *fmt, knh_int_t n);
void knh_write__ffmt(Ctx *ctx, Writer *b, char *fmt, knh_float_t n);

void knh_write__flag(Ctx *ctx, Writer *b, knh_flag_t flag);
void knh_write__type(Ctx *ctx, Writer *b, knh_type_t type);
void knh_write__class(Ctx *ctx, Writer *b, knh_class_t cid);
void knh_write__mn(Ctx *ctx, Writer *b, knh_methodn_t mn);

void knh_write_delim(Ctx *ctx, Writer *b);
void knh_write_dots(Ctx *ctx, Writer *b);

void knh_Writer_indent_inc(Ctx *ctx, Writer *b);
void knh_Writer_indent_dec(Ctx *ctx, Writer *b);
void knh_Writer_write_indent(Ctx *ctx, Writer *b, knh_bytes_t tab);

void knh_format(Ctx *ctx, Writer *b, knh_methodn_t mn, Object *o, Any *m);
String* knh_Object_movableText(Ctx *ctx, Object *b, knh_methodn_t mn, Any *m);

void knh_printf(Ctx *ctx, Writer *b, char *fmt, ...);



/* ======================================================================== */
/* konoha_api.c */

knh_bool_t konoha_initcheck(void);
konoha_t konoha_open(void);
void konoha_close(konoha_t konoha);
void konoha_eval(konoha_t konoha, char *script);
void konoha_read(konoha_t konoha, knh_nsn_t nsn, char *fpath);

Ctx *konoha_ctx(konoha_t konoha);
konoha_t konoha_context(konoha_t konoha, char *name);



/* ======================================================================== */
/* konoha_call.c */
#define KNH_SETr(ctx,sf,v)          KNH_SETv(ctx,sf[-1],v)
#define KNH_SETr_void(ctx,sf)       KNH_SETv(ctx,sf[-1],Null)
#define KNH_SAFE_SETr(ctx, sf, v)   KNH_SETv(ctx, sf[-1], v)
#define KNH_LOPEN(ctx, n) \
	Object **local_ = ((Context*)ctx)->ebp; \
	knh_stackf_locals(ctx, n) \


#define KNH_LOCALv(n)                 local_[n+1]
#define KNH_LVALUE(n)                 local_[n+1]
#define KNH_LSETv(ctx, n, v)          KNH_SETv(ctx, local_[n+1], v) 
#define KNH_LCLOSE(ctx)              ((Context*)ctx)->ebp = local_
#define KNH_LPUSH(ctx,v) \
	((Context*)ctx)->ebp++; \
	KNH_SETv(ctx, ((Context*)ctx)->ebp[0], v); \


#define KNH_PUSHv(ctx,v) \
	((Context*)ctx)->ebp++; \
	KNH_SETv(ctx, ((Context*)ctx)->ebp[0], v); \


#define KNH_STACKOP(p)        ((Context*)ctx)->stackop[(p)-((Context*)ctx)->stack]




void knh_stackf_locals(Ctx *ctx, size_t n);

knh_vargc_t knh_stackf_argc(Ctx *ctx, Object **varg);
Array *knh_stackf_toArray(Ctx *ctx, Object **varg);
Method *knh_stackf_getMethod(Ctx *ctx, Object **sf);

Struct *knh_stackf_structDelta(Ctx *ctx, Object **sf);

void knh_stackf_new(Ctx *ctx, Object **mtdp);
void knh_stackf_typecheck__DCALL(Ctx *ctx, Object **mtdp);
void knh_stackf_typecheck__MCALL(Ctx *ctx, Object **mtdp);

void knh_stackf_dump(Ctx *ctx, Object **sf);
void knh_stackf_diagnose(Ctx *ctx, Object **sf, knh_int_t n);



/* ======================================================================== */
/* konoha_hobject.c */
#define knh_sweep      knh_Object_refc_dec
#define IS_SWEEP(gc)   (gc == knh_sweep)
#define KNH_SAFEFREE(ctx,o)  knh_Object_safefree(ctx,o)
#define KNH_INITv(a,v)            knh_INITv((Object**)&(a),(v))
#define KNH_INITn(a,n,v)          knh_INITn((a),(n),(v))
#define KNH_SETv(ctx,a,v)         knh_SETv(ctx,(Object**)&(a),(v))
#define KNH_SETn(ctx,a,n,v)       knh_SETn(ctx,a,(n),(v))
#define KNH_FINALv(ctx,a)         knh_FINALv(ctx,(Object**)&(a))
#define KNH_FINALn(ctx,a,n)       knh_FINALn(ctx,(a),(n))




Object *knh_Object_malloc0(Ctx *ctx, knh_flag_t flag, knh_class_t cid, size_t size);
Object *knh_Object_malloc(Ctx *ctx, knh_class_t cid);

Object *knh_Object_cast(Ctx *ctx, Object *o);
Object *knh_Object_castOrNull(Ctx *ctx, Object *o);
void knh_Object_dispose(Ctx *ctx, Object *o);
void knh_Object_refc_inc(Object *self);
void knh_Object_vmcinc(Ctx *ctx, Object *self);
void knh_Object_refc_dec(Ctx *ctx, Object *self);
void knh_Object_safefree(Ctx *ctx, Object *self);

void knh_INITv(Object **var, Object *o);
void knh_INITn(Object **var, int n, Object *o);
void knh_SETv(Ctx *ctx, Object **var, Object *o);
void knh_SETn(Ctx *ctx, Object **var, int n, Object *o);
void knh_FINALv(Ctx *ctx, Object **var);
void knh_FINALn(Ctx *ctx, Object **var, int n);

Object** knh_oarray_malloc(Ctx *ctx, size_t size, Object *value);
void knh_oarray_traverse(Ctx *ctx, Object **a, size_t size, f_gc gc);



/* ======================================================================== */
/* konoha_init.c */


Object *knh_Nue_NULL(void);

Runtime *knh_Runtime_ROOT();
Runtime *knh_Context_getRuntime(Ctx *ctx);
Object *knh_Runtime_fvalue(Ctx *ctx, knh_class_t cid);

System *knh_System_ROOT(void);
Object *knh_System_fvalue(Ctx *ctx, knh_class_t cid);

Bool *knh_Bool_TRUE(void);
Bool *knh_Bool_FALSE(void);
Object *knh_Bool_fvalue(Ctx *ctx, knh_class_t cid);

NameSpace *knh_NameSpace_SYSTEM(void);

void knh_konoha_ginit();
void knh_konoha_gtraverse(Ctx *ctx, f_gc gc);



/* ======================================================================== */
/* konoha_loader.c */

void knh_loader_ginit();
void knh_loader_gtraverse(Ctx *ctx, f_gc gc);

void *knh_loader_loaddll(Ctx *ctx, char *dirname, char *libname, char *funcname);
void knh_tlib_test(Ctx *ctx);

void knh_loader_load_package(Ctx *ctx, char *pkgname);
IntUnit *knh_loader_loadIntUnit(Ctx *ctx, char *urn);
FloatUnit *knh_loader_loadFloatUnit(Ctx *ctx, char *urn);
Vocabulary *knh_loader_loadVocabulary(Ctx *ctx, char *urn);
Object *knh_loader_load_spec(Ctx *ctx, knh_class_t bcid, char *urn);



/* ======================================================================== */
/* konoha_metadata.c */


void knh_metadata_set(Ctx *ctx, Object *b, String *key, Any *value);
Any *knh_metadata_get(Ctx *ctx, Object *b, knh_bytes_t key);
void knh_metadata_clear(Ctx *ctx, Object *b);



/* ======================================================================== */
/* konoha_print.c */
#define KNH_FLAG_PF_LINEFEED   KNH_FLAG_T0



int knh_verbose(void);

char *KNH_SAFEFILE(char *file);
void knh_vmprint(Ctx *ctx, Object **sfp, /* knh_dwarf_t dwf,*/ knh_flag_t flag, knh_methodn_t mn, Object *o);



/* ======================================================================== */
/* konoha_shell.c */

char *knh_readline(char *prompt);

void konoha_show_version(Ctx *ctx);
knh_int_t konoha_shell_checkline(char *ln, size_t len);
void konoha_shell(konoha_t konoha);



/* ======================================================================== */
/* konoha_tclass.c */
#define KNH_FLAG_CF2OF(f)        (f)
#define CLASSN(cid)   knh_String_tochar(knh_tclass_name(cid))
#define CLASSNo(o)    CLASSN(knh_Object_cid(o))




void knh_tclass_ginit();
	 void knh_tclass_gtraverse(Ctx *ctx, f_gc gc);

knh_class_t knh_tclass_newId(Ctx *ctx);

knh_bool_t knh_tclass_isvalid(knh_class_t cid);
knh_tclass_t* knh_tclass_table(knh_class_t cid);

void knh_tclass_count_inc(knh_class_t cid);
void knh_tclass_count_dec(knh_class_t cid);
knh_flag_t knh_tclass_cflag(knh_class_t cid);
knh_flag_t knh_tclass_oflag(knh_class_t cid);
knh_struct_t knh_tclass_topsid(knh_class_t cid);
knh_ushort_t knh_tclass_offset(knh_class_t cid);
knh_struct_t knh_tclass_sid(knh_class_t cid);
knh_ushort_t knh_tclass_supcid(knh_class_t cid);

knh_index_t knh_tclass_keyidx(knh_class_t cid);

String *knh_tclass_name(knh_class_t cid);

Class *knh_tclass_class(knh_class_t cid);
knh_class_t knh_tclass_bcid(knh_class_t cid);
knh_class_t knh_tclass_ensurebcid(knh_class_t bcid, knh_class_t cid);

ClassStruct *knh_tclass_cstruct(knh_class_t cid);
bsize_t knh_tclass_bsize(knh_class_t cid);
size_t knh_tclass_size(knh_class_t cid);

ClassRel *knh_tclass_crel(knh_class_t cid);

Object *knh_tclass_spec(knh_class_t cid);
knh_bool_t knh_Class_isSingleton(knh_class_t b);
ObjectNULL *knh_tclass_fvalue__singleton(Ctx *ctx, knh_class_t cid);

ObjectNULL *knh_tclass_fvalue__default(Ctx *ctx, knh_class_t cid);
knh_bool_t knh_tclass_hasDefaultValue(knh_class_t cid);
Object *knh_tclass_value(Ctx *ctx, knh_class_t cid, Object *alt);
Object *knh_tclass_safevalue(Ctx *ctx, knh_class_t cid);

knh_class_t KNH_TCLASS(Ctx *ctx, knh_flag_t flag, String *name, knh_class_t cid, knh_struct_t sid, knh_class_t supcid, Object *spec, f_value fvalue, int isize, ...);

ObjectNULL *knh_tclass_fvalue__spec(Ctx *ctx, knh_class_t cid);
knh_class_t KNH_TCLASS_SPEC(Ctx *ctx, knh_class_t bcid, Object *spec);
char * knh_nzformat_urn(char *buf, size_t bufsiz, char *urn);
knh_class_t knh_tclass_urn(Ctx *ctx, knh_class_t bcid, knh_bytes_t urn, knh_class_t def);

knh_class_t KNH_TCLASS_NEWCLASS(Ctx *ctx, String *name);
knh_class_t KNH_TCLASS_STRUCT(Ctx *ctx, knh_flag_t flag, knh_class_t cid, knh_struct_t sid, knh_class_t supcid, ClassStruct *cs);



/* ======================================================================== */
/* konoha_tconst.c */
knh_bool_t knh_tconst_exists(Ctx *ctx, knh_bytes_t name);
Object *knh_tconst_value(Ctx *ctx, knh_bytes_t name);
knh_type_t knh_tconst_type(Ctx *ctx, knh_bytes_t name);

char *knh_tconst_uname(void);



/* ======================================================================== */
/* konoha_texpt.c */
#define EXPTN(eid)   knh_String_tochar(knh_texpt_name(eid))




void knh_texpt_ginit();
void knh_texpt_gtraverse(Ctx *ctx, f_gc gc);

knh_expt_t knh_texpt_newId(Ctx *ctx);

knh_bool_t knh_texpt_isvalid(knh_expt_t eid);
knh_flag_t knh_texpt_flag(knh_expt_t eid);
knh_expt_t knh_texpt_parent(knh_expt_t eid);
knh_bool_t knh_texpt_isa(knh_expt_t eid, knh_expt_t parent);
String *knh_texpt_name(knh_expt_t eid);

knh_expt_t TEXPT(Ctx *ctx, knh_flag_t flag, knh_class_t eid, knh_bytes_t ename, char *pname);

knh_expt_t knh_texpt_forname(Ctx *ctx, knh_bytes_t msg, knh_expt_t def);



/* ======================================================================== */
/* konoha_tglobal.c */
#define TGLOBAL(v)   knh_tglobal_insert((Object**)(&(v)))



void knh_tglobal_ginit();
void knh_tglobal_insert(Object **var);
void knh_tglobal_gtraverse(Ctx *ctx, f_gc gc);



/* ======================================================================== */
/* konoha_throwcatch.c */
#define KNH_THROW(ctx, e) \
	if(IS_NULL(e)) { \
		knh_konohavm_throwException(ctx, knh_Exception__Nue(ctx, e)); \
	}else if(IS_Exception(e)) { \
		knh_konohavm_throwException(ctx, e); \
	}else if(IS_String(e)) { \
		knh_konohavm_throwException(ctx, knh_Exception(ctx, e)); \
	}else { \
		DEBUG("Cannot throw %s", CLASSN(e)); \
	} \


#define KNH_THROWs(ctx, s) \
	knh_konohavm_throwException(ctx, new_Exception__b(ctx, B(s))); \


#define KNH_THROWf(ctx, fmt, ...) \
	char throwbuf_[256]; \
	snprintf(throwbuf_, sizeof(throwbuf_), fmt, ## __VA_ARGS__); \
	knh_konohavm_throwException(ctx, new_Exception__b(ctx, B(throwbuf_))); \






void knh_konohavm_throwException(Context *ctx, Exception *e);
void knh_Exception_addStackTrace(Ctx *ctx, Exception *b, String *msg);
String *knh_stackf_getStackTraceMsg(Ctx *ctx, Object **sf);



/* ======================================================================== */
/* konoha_tmapmap.c */
Object* knh_MapMap_fMethod(Ctx *ctx, Object *self, MapMap *map);
f_mapmap knh_tmapmap_config(Ctx *ctx, Object *conf, knh_class_t scid, knh_class_t tcid);

void konoha_stat_tmapmap_cache();

void TMAPMAP(Ctx *ctx, knh_flag_t flag, f_mapmap fmap, knh_type_t stype, knh_type_t ttype, Object *conf);

MapMap *knh_tmapmap_find_cache(Ctx *ctx, knh_class_t scid, knh_class_t tcid);
void knh_tmapmap_set_cache(Ctx *ctx, MapMap *map);

MapMap *knh_tmapmap_find(Ctx *ctx, knh_class_t scid, knh_class_t tcid);



/* ======================================================================== */
/* konoha_tmemory.c */

size_t knh_tmemory_used_size(void);
void *knh_malloc(Ctx *ctx, size_t size);
void *knh_realloc(Ctx *ctx, void *ptr, size_t oldsize, size_t newsize);
void knh_free(void *block, size_t size);

void knh_tmemory_beginMemoryLeakNotice();
void knh_tmemory_endMemoryLeakNotice();



/* ======================================================================== */
/* konoha_tmethod.c */


knh_bool_t knh_Method_checkMethodField(Ctx *ctx, Method *mtd, knh_flag_t flag, knh_type_t rtype, size_t psize);
void TMETHOD(Ctx *ctx, knh_flag_t tflag, f_method func, knh_type_t rtype, knh_class_t cid, knh_methodn_t mn, knh_ushort_t psize, ...);

Method *knh_Method_ufind(Ctx *ctx, knh_class_t cid, knh_methodn_t mn);
Method *knh_Method_ufindb(Ctx *ctx, knh_class_t cid, knh_bytes_t mnm);



/* ======================================================================== */
/* konoha_tname.c */
#define NSN_main           0
#define FILEN_unknown      0
#define FIELDN(fn) knh_String_tochar(knh_tfieldn_name(fn))
#define METHODN(mn)  FIELDN(METHODN_TOFIELDN(mn))
#define NSN(nsn) knh_String_tochar(knh_tnsn_name(nsn))
#define FILEN(filen) knh_String_tochar(knh_tfilen_name(filen))




void knh_tname_ginit();
void knh_tname_gtraverse(Ctx *ctx, f_gc gc);

char * knh_format_nzname(char *buf, size_t bufsiz, knh_bytes_t t);
knh_fieldn_t knh_tfieldn_common(Ctx *ctx, knh_bytes_t n, knh_fieldn_t def);

String *knh_tfieldn_name(knh_fieldn_t fn);
knh_fieldn_t knh_tfieldn_forname(Ctx *ctx, knh_bytes_t tname, knh_fieldn_t def);
void KNH_TFIELDN(Ctx *ctx, knh_fieldn_t fn, String *name);

knh_methodn_t knh_tmethodn_forname(Ctx *ctx, knh_bytes_t tname, knh_methodn_t def);
char * knh_format_methodn(char *buf, size_t bufsiz, knh_methodn_t mn);

char * knh_bytes_nznsn(knh_bytes_t t, char *buf, size_t bufsiz);
knh_nsn_t knh_tnsn_forname(Ctx *ctx, knh_bytes_t t);
String *knh_tnsn_name(knh_nsn_t nsn);

knh_filen_t knh_tfilen_forname(Ctx *ctx, knh_bytes_t t);
String *knh_tfilen_name(knh_filen_t filen);



/* ======================================================================== */
/* konoha_tstruct.c */
#define STRUCT_newid         0
#define STRUCT_TUPLE(s)      (knh_struct_t)(sizeof(s)/sizeof(Object*))
#define STRUCTN(sid)   knh_tstruct_name(sid)




void knh_tstruct_ginit(void);
void knh_tstruct_gtraverse(Ctx *ctx, f_gc gc);
knh_struct_t KNH_TSTRUCT(Ctx *ctx, knh_struct_t sid, size_t size, char *name, f_struct_init f0, f_struct_copy f1, f_struct_compare f2, f_struct_traverse f3);
void knh_tstruct_init__default(Ctx *ctx, Struct *s1, int init, Object *cs);
knh_int_t knh_tstruct_compare__default(Ctx *ctx, Struct *s1, Struct *s2);
void knh_tstruct_traverse__default(Ctx *ctx, Struct *s, f_gc gc);

size_t knh_tstruct_size(knh_struct_t sid);
bsize_t knh_tstruct_bsize(knh_struct_t sid);
char *knh_tstruct_name(knh_struct_t sid);

f_struct_init knh_tstruct_finit(knh_struct_t sid);
f_struct_copy knh_tstruct_fcopy(knh_struct_t sid);
f_struct_compare knh_tstruct_fcompare(knh_struct_t sid);
f_struct_traverse knh_tstruct_ftraverse(knh_struct_t sid);



/* ======================================================================== */
/* konoha_typesystem.c */

knh_bool_t knh_class_instanceof(knh_class_t scid, knh_class_t tcid);
knh_bool_t knh_Object_opInstanceof(Ctx *ctx, Object *b, knh_type_t c);

Object * knh_typesystem_doCoercion(Ctx *ctx, knh_type_t type, Object *v);

Object * knh_typesystem_map(Ctx *ctx, Object *v, knh_type_t type);
Object * knh_typesystem_initialValue(Ctx *ctx, knh_type_t type);

Exception* new_Exception__type(Ctx *ctx, Object *value, knh_type_t spec_type);



#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA__H*/
