/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHAC_T_H_
#define KONOHAC_T_H_

#include<konoha/konoha_t.h>

#include"konoha.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

#define KNH_STT_LVALUE  0
#define KNH_STT_RVALUE  1

/* ------------------------------------------------------------------------ */

typedef knh_ushort_t   knh_token_t;
typedef knh_ushort_t   knh_stmt_t;

/* ------------------------------------------------------------------------ */

#define MC_FATAL     0
#define MC_LANG      1
#define MC_ERROR     2
#define MC_TYPE      3
#define MC_WARNING   4
#define MC_IGNORED   5
#define MC_ERRATA    6
#define MC_NOTICE    7
#define MC_INFO      8

#define MC_EPRINT(ctx, tk, lv, fmt, ...) { \
		DEBUG("<ERR=%d>", lv); \
		Writer *w_ = konohac_perror(ctx, tk, lv); \
		knh_printf(ctx, w_, fmt, ##__VA_ARGS__); \
		knh_writeLine(ctx, w_, STEXT("")); \
		knh_flush(ctx, w_); \
	} \

#define MC_EPRINT2(ctx, tk, lv, fmt, ...) \
	if(!knh_Token_isPerrored(tk)) { \
		DEBUG(fmt, ##__VA_ARGS__); \
		konohac_perror(ctx, tk, lv); \
		konohac_eprintf(ctx, tk, lv, fmt, ##__VA_ARGS__); \
		knh_Token_setPerrored(tk, 1); \
	} else { \
		DEBUG(fmt, ##__VA_ARGS__); \
	} \

/* ------------------------------------------------------------------------ */

#define KNH_GOTO(L) \
	DEBUG("goto .."); \
	goto L; \

/* ------------------------------------------------------------------------ */

#define Term         Object
#define IS_Term(o)   (IS_Token(o)||IS_Stmt(o))

struct knh_Stmt;
typedef void    (*f_stmtvisit)(Ctx*, struct knh_Stmt*, Object*, int, int);
//typedef void    (*f_termvisit)(Ctx*, Term *, Object*, int, int);

/* ------------------------------------------------------------------------ */

#define KNH_ASMV_ONSTACK 0
#define KNH_ASMV_EBP  0
#define KNH_ASMV_SFP  1
#define KNH_ASMV_OFP  2
#define KNH_ASMV_OBJ  3
#define KNH_ASMV_OIDX 4
#define KNH_ASMV_ERR  5

typedef struct {
	knh_uchar_t  potype;
	knh_uchar_t  index;
	knh_type_t   type; 
	Object     *value;
} knh_asmv_t;

/* ------------------------------------------------------------------------ */

typedef struct {
	void       *pc;
	knh_uint_t   loc;
} knh_dwarf_t;

///* ------------------------------------------------------------------------ */
//
//#define ASMEVAL_ERR  0
//#define ASMEVAL_EBP  1
//#define ASMEVAL_SFP  2
//#define ASMEVAL_OFP  3
//#define ASMEVAL_OBJ  4
//
//typedef struct {
//	knh_uchar_t  potype;
//	knh_uchar_t  index;
//	knh_type_t   type; 
//	Object  *value;
//} asmeval_t;
//
/////* ------------------------------------------------------------------------ */
////
////#define AT_ERR        0
////#define AT_LOCAL      1
////#define AT_SFP        1
////#define AT_FIELD      2
////#define AT_OFP        2
////#define AT_GLOBAL     3
////#define AT_GP         3
////#define AT_OBJ        4
////#define AT_PROP       5
////#define AT_TOCALL     6
////#define AT_STACK      6
////
////typedef struct asmv_t  {
////	knh_uchar_t  at;
////	knh_uchar_t  idx;
////	knh_type_t   type; 
////	Object  *value;
////} asmv_t;
////
///* ------------------------------------------------------------------------ */
//
//#define ASMF_STRICT    FLAG_T2
//#define ASM_LABEL_BUFSIZ    64

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* include generated header file */

/* ************************************************************************ */

#ifdef __cplusplus 
}
#endif

#include"konohac_.h"

#endif /*KONOHAC_T_H_*/
