#!/usr/bin/python
import os, sys
from pygenlib  import *

def body_filter(text):
	text = text.replace('PUBLIC ', '')
	text = text.replace('PUBLIC', '')
	text = text.replace('METHOD ', '')
	return text


def readwrite_c(fn):
	f = open(fn, 'r')
	hlines = []
	pp = 0
	
	for ln in f:
		if ln.startswith('/* @c '): break
		if ln.startswith('#endif') and pp == 1: break
		if ln.startswith('#ifdef __cplusplus'): 
			pp = 1
			continue
		if ln.startswith('/**') or ln.startswith(' *') :continue
		if ln.find('BY HAND') > 0 : continue
		if pp == 0:
			hlines.append(ln)
	
	blines = []
	pp = 0
	for ln in f:
		if ln.startswith('#endif') and pp == 1: break
		if ln.startswith('#ifdef __cplusplus'): 
			pp = 1
			continue
		ln = body_filter(ln)
		if pp == 0: blines.append(ln)
	
	flines = []
	for ln in f:
		flines.append(ln)
	
	f.close()
	
	f = open(fn, 'w')
	
	write_license(f)
	for ln in hlines:
		f.write(ln)
	write_begin_c(f)

	for ln in blines:
		f.write(ln)
	
	write_end_c(f)

	for ln in flines:
		f.write(ln)

	f.close()

#------------------------------------------------------------------------------------

for fn in sys.argv[1:]:
	readwrite_c(fn)
