/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef COMMONS_H_
#define COMMONS_H_

#include<konoha/konoha_dev.h>

#ifdef __cplusplus 
extern "C" {
#endif

#define DataTuple dbw_DataTuple
#define Connection dbw_Connection

struct dbw_DataTuple;
typedef void      dbw_result_t;
typedef void       (*f_dbw_free)(dbw_result_t *);
typedef knh_bool_t  (*f_dbw_next)(Ctx *,dbw_result_t *, struct dbw_DataTuple*);

typedef struct dbw_tuplefunc_l {
	f_dbw_free  free;
	f_dbw_next  next;
} dbw_tuplefunc_l;

#define DBW_DATATUPLE_CTYPE__null    0
#define DBW_DATATUPLE_CTYPE__int     1
#define DBW_DATATUPLE_CTYPE__int64   2
#define DBW_DATATUPLE_CTYPE__float   3
#define DBW_DATATUPLE_CTYPE__bytes   4

typedef struct dbw_tuplecolumn_t {
	knh_type_t type;
	knh_ushort_t ctype;
	knh_String *name;
	size_t start;
	size_t len;
} dbw_tuplecolumn_t;

typedef struct dbw_DataTuple {
	dbw_tuplefunc_l func;
	size_t size;
	knh_String        *tableName;
	dbw_tuplecolumn_t *column;
	knh_Bytes         *databuf;
	dbw_result_t      *resultptr;
} dbw_DataTuple;

struct dbw_Connection;
typedef void* (*f_dbw_connect)(Ctx *ctx, char *url, char *uname, char *upwd);
typedef struct dbw_DataTuple* (*f_dbw_execSQL)(Ctx *ctx, struct dbw_Connection *, char *sql);
typedef void  (*f_dbw_close)(Ctx *ctx, struct dbw_Connection *);

typedef struct dbw_connfunc_l {
	f_dbw_connect  connect;
	f_dbw_execSQL  execSQL;
	f_dbw_close    close;	
} dbw_connfunc_l;

typedef struct dbw_Connection {
	dbw_connfunc_l func;
	void *conn;	
	knh_String *url;
	knh_String *uname;
	knh_String *upwd;
} dbw_Connection;

#ifdef __cplusplus
}
#endif

#endif /*COMMONS_H_*/